/*---------------------------------------------------------------------
 *        [ Copyright (c) 1999 Alpha Processor Inc.] - Unpublished Work
 *          All rights reserved
 * 
 *    This file contains source code written by Alpha Processor, Inc.
 *    It may not be used without express written permission. The
 *    expression of the information contained herein is protected under
 *    federal copyright laws as an unpublished work and all copying
 *    without permission is prohibited and may be subject to criminal
 *    and civil penalties. Alpha Processor, Inc.  assumes no
 *    responsibility for errors, omissions, or damages caused by the use
 *    of these programs or from use of the information contained herein.
 *  
 *-------------------------------------------------------------------*/
/* 
 * $Id:
 * Author:
 * 	Stig Telfer 21 September 2000
 */

#undef TRACE_ENABLE

#include "lib.h"
#include "uilib.h"
#include "southbridge.h"

#include "i2c.h"
#include "i2c/pcf8574.h"


/*------------------------------------------------------------------------*/
/* Public interface */

DBM_STATUS pcf8574_get( uint8 addr, uint8 *data )
{
    TRACE( "reading mux/reg at 0x%02X\n", addr );
    return i2cdev_read( addr, -1, 1, data );
}


DBM_STATUS pcf8574_set( uint8 addr, uint8 *data )
{
    TRACE( "writing mux/reg at 0x%02X with 0x%02X\n", addr, *data );
    return i2cdev_write( addr, -1, 1, data );
}

