#ifndef DIAGS__ASSET_H_LOADED
#define DIAGS__ASSET_H_LOADED
/*---------------------------------------------------------------------
 *        [ Copyright (c) 1999 Alpha Processor Inc.] - Unpublished Work
 *          All rights reserved
 * 
 *    This file contains source code written by Alpha Processor, Inc.
 *    It may not be used without express written permission. The
 *    expression of the information contained herein is protected under
 *    federal copyright laws as an unpublished work and all copying
 *    without permission is prohibited and may be subject to criminal
 *    and civil penalties. Alpha Processor, Inc.  assumes no
 *    responsibility for errors, omissions, or damages caused by the use
 *    of these programs or from use of the information contained herein.
 *  
 *-------------------------------------------------------------------*/
/* Alpha Diagnostics Asset Info Manager */
/* Begun by Stig Telfer, API NetWorks, 21 February 2001 */

/* Maximum number of bytes in an EEPROM */
/* Note: strange things will happen if your EEPROM is not actually this size */
#define EEPROM_MAXLEN	256

/* Length of the 'abstract' (short version of contents) */
#define ABSTRACT_LEN	30


/* All the information required for an asset eeprom is in this structure */
typedef struct _eeprom {
    uint8 data[ EEPROM_MAXLEN ];
    I2Cbus_t *I;
    struct _eeprom *next;
} eeprom_t;


/* Given an asset EEPROM descriptor, fill in the details about it */
eeprom_t *eeprom_scan( eeprom_t *E );


/* Given EEPROM descriptor, allow the user to view the entire contents of
 * the EEPROM in an application box on the screen */
DBM_STATUS eeprom_examine( eeprom_t *E );


/* Given EEPROM descriptor, allow the user to edit the contents of the EEPROM */
/* Return value depends on whether the contents were written back OK */
DBM_STATUS eeprom_edit( eeprom_t *E );

#endif 		/* DIAGS__ASSET_H_LOADED */
