#ifndef DIAGS__PLATFORM_H__LOADED
#define DIAGS__PLATFORM_H__LOADED
/*---------------------------------------------------------------------
 *        [ Copyright (c) 1999 Alpha Processor Inc.] - Unpublished Work
 *          All rights reserved
 * 
 *    This file contains source code written by Alpha Processor, Inc.
 *    It may not be used without express written permission. The
 *    expression of the information contained herein is protected under
 *    federal copyright laws as an unpublished work and all copying
 *    without permission is prohibited and may be subject to criminal
 *    and civil penalties. Alpha Processor, Inc.  assumes no
 *    responsibility for errors, omissions, or damages caused by the use
 *    of these programs or from use of the information contained herein.
 *  
 *-------------------------------------------------------------------*/
/* Common interface for system-related configuration details */
/* Begun by Stig Telfer, Alpha Processor Inc, 28 Mar 1999 */

/* This file contains a number of definitions that can be redefined by
 * including a platform-specific include file above this generic include
 * file.
 */

#include "pci.h"
#include "mcheck.h"
#include "uilib.h"
#include "rom.h"
#include "i2c.h"



/*----------------------------------------------------------------------*/
/* Global definitions and data structures */

/* concise platform name for mfrg diagnostics prompt */
extern const char *Prompt;


/* If your platform has more PCI slots, define the correct value privately */
#ifndef PCI_MAXSLOTS
#define PCI_MAXSLOTS 6		/* may override in platform-specific include */
#endif

/* your platform bus config, defined according to the structure in pci.h */
extern const PCIStructure_t PCIStructure[];

/* Buses on the motherboard (NB may be others eg behind PCI-PCI bridges */
extern const short plat_pci_hose_count;


/* platform number codes for HWRPB and loading linux */
extern const unsigned plat_sys_type, plat_sys_variation;


/*----------------------------------------------------------------------*/
/* configuration of the system rom is a platform-dependent thing */

extern const unsigned long plat_romsize;
extern rom_t *plat_rom_rsvd;		/* unmarked, reserved regions */


/* Lowest-level ROM functionality */
/* adjust an address to sector ranges, finding upper, lower bounds */
extern unsigned plat_romlower( unsigned addr );
extern unsigned plat_romupper( unsigned addr );

/* reading and writing values to the ROM with the simplest mechanism */
extern unsigned plat_inroml( const unsigned offset );
extern unsigned char plat_inromb( const unsigned offset );

extern DBM_STATUS plat_outroml( const unsigned offset, const unsigned data );
extern DBM_STATUS plat_outromb( const unsigned offset, const unsigned char data );


/* Higher level ROM functionality */
/* Erase a region of the rom (nb, may be sectored) 
 * The callback function is called after every ncb bytes, or not if NULL
 */

extern DBM_STATUS plat_romerase( unsigned start, unsigned end,
			  Callback_t CB, unsigned ncb );

/* flash an image.  The callback function
 * is called after writing every ncb bytes, or is not used if NULL  */

extern DBM_STATUS plat_romwrite( unsigned start, const unsigned char *img,
			  unsigned nb, Callback_t CB, unsigned ncb );

/*----------------------------------------------------------------------*/
/* Other Interface function prototypes */

/* apply platform-specific initialisations */
extern DBM_STATUS plat_setup( void );
extern DBM_STATUS plat_fixup( void );

/* Power-on self-test: platform specific bootup diagnostics (must be quick) */
extern DBM_STATUS plat_post( void );

/* Reset this platform (parameters are for clean compilation, not used) */
extern DBM_STATUS plat_reset( int argc, char *argv[] );	

extern void plat_sysstat( String );	/* system status, for memory test */

extern void plat_intsetup( int );	/* enable/disable all system IRQs */
					/* note: doesn't change current IPL */
extern void plat_intclr( void );	/* clear any pending interrupts */
extern void plat_nmiclr( void );	/* clear any pending NMIs */

extern void plat_mchkinterp( String interp, int scb, LogoutFrame_t *L );


/*----------------------------------------------------------------------*/
/* low-level multiprocessor support */

/* start secondary CPUs, argument is PALbase */
extern void plat_smpstart( unsigned long palbase );	


/*----------------------------------------------------------------------*/
/* I2C access functions */

/* Bus layout data */
extern const I2Cbus_t plat_i2c_bus[];

extern DBM_STATUS plat_i2cinit( void );

/* Wire up the I2C bus (eg, by setting multiplexers) for this device */
/* A STATUS_WARNING return signal means that the device may not be present
 * for no reason of error (eg CPU removed).
 * A STATUS_FAILURE return signal means that the device could not be selected.
 */
extern DBM_STATUS plat_i2c_select( const I2Cbus_t *I );


#endif		/*  DIAGS__PLATFORM_H__LOADED  */

