/*---------------------------------------------------------------------
 *        [ Copyright (c) 1999 Alpha Processor Inc.] - Unpublished Work
 *          All rights reserved
 * 
 *    This file contains source code written by Alpha Processor, Inc.
 *    It may not be used without express written permission. The
 *    expression of the information contained herein is protected under
 *    federal copyright laws as an unpublished work and all copying
 *    without permission is prohibited and may be subject to criminal
 *    and civil penalties. Alpha Processor, Inc.  assumes no
 *    responsibility for errors, omissions, or damages caused by the use
 *    of these programs or from use of the information contained herein.
 *  
 *-------------------------------------------------------------------*/
/*
 * Pre-bios diags/boot manager/fail-safe reflash utility firmware
 *
 * Basic user interface library
 */

#ifndef DIAGS__UILIB_H__LOADED
#define DIAGS__UILIB_H__LOADED


/* console dimensions */

#define NROW    24
#define NCOL    80


/*--------------------------------------------------------------------*/
/* VT-100 control codes for presenting a half-friendly interface to 
 * diags users.
 */
/*--------------------------------------------------------------------*/

/* ANSI escape sequences */
#define ESC "\x1B"

#define FG_BOLD		ESC "[1m"
#define BG_BLINK	ESC "[5m"
#define CU_NORMAL	ESC "[33;1;41m"		/* define 'normal' here */

#define FG_BLACK	ESC "[30m"
#define FG_BLUE		ESC "[34m"
#define FG_GREEN	ESC "[32m"
#define FG_CYAN		ESC "[36m"
#define FG_RED		ESC "[31m"
#define FG_MAGENTA	ESC "[35m"
#define FG_BROWN	ESC "[33m"
#define FG_LGREY	ESC "[37m"
#define FG_DGREY	ESC "[30;1m"
#define FG_LBLUE	ESC "[34;1m"
#define FG_LGREEN	ESC "[32;1m"
#define FG_LCYAN	ESC "[36;1m"
#define FG_LRED		ESC "[31;1m"
#define FG_LMAGENTA	ESC "[35;1m"
#define FG_YELLOW	ESC "[33;1m"
#define FG_WHITE	ESC "[37;1m"

#define BG_BLACK        ESC "[40m"
#define BG_BLUE         ESC "[44m"
#define BG_GREEN        ESC "[42m"
#define BG_CYAN         ESC "[46m"
#define BG_RED          ESC "[41m"
#define BG_MAGENTA      ESC "[45m"
#define BG_BROWN        ESC "[43m"
#define BG_GREY         ESC "[47m"
#define BG_DGREY	ESC "[40;1m"
#define BG_LBLUE	ESC "[44;1m"
#define BG_LGREEN	ESC "[42;1m"
#define BG_LCYAN	ESC "[46;1m"
#define BG_LRED		ESC "[41;1m"
#define BG_LMAGENTA	ESC "[45;1m"
#define BG_YELLOW	ESC "[43;1m"
#define BG_WHITE	ESC "[47;1m"

#define FANCY_ASCII	/* Define this for pretty-print characters on DOS */
#ifdef FANCY_ASCII

/* 8-bit ASCII characters */
#define BOX_BL	"\xC0"	/* ASCII chars for drawing boxes */
#define BC_BL	'\xC0'	/* ASCII chars for drawing boxes */
#define BOX_BR	"\xD9"
#define BC_BR	'\xD9'
#define BOX_TL	"\xDA"
#define BC_TL	'\xDA'
#define BOX_TR	"\xBF"
#define BC_TR	'\xBF'
#define BOX_H	"\xC4"
#define BC_H	'\xC4'
#define BOX_V	"\xB3"
#define BC_V	'\xB3'

#define BLK_HALF "\xB2"
#define BC_HALF '\xB2'
#define BLK_FULL "\xDB"
#define BC_FULL '\xDB'

#else

/* 7-bit approx to nicer 8-bit ASCII characters */
#define BOX_BL	"+" 	/* ASCII chars for drawing boxes */
#define BC_BL	'+' 	/* ASCII chars for drawing boxes */
#define BOX_BR	"+"
#define BC_BR	'+'
#define BOX_TL	"+"
#define BC_TL	'+'
#define BOX_TR	"+"
#define BC_TR	'+'
#define BOX_H	"-"
#define BC_H	'-'
#define BOX_V	"|"
#define BC_V	'|'

#define BLK_HALF "x"
#define BC_HALF 'x'
#define BLK_FULL "X"
#define BC_FULL 'X'

#endif 	/* FANCY_ASCII */


/*----------------------------------------------------------------------*/
/* Definition of global data types, particularly for user interface */

typedef enum { UI_BATCH, UI_INTERACT } UIstate;

typedef enum { 	COL_BLACK,   COL_BLUE,   COL_GREEN, COL_CYAN,  COL_RED,
		COL_MAGENTA, COL_BROWN,  COL_LGREY, COL_DGREY,
		COL_LBLUE,   COL_LGREEN, COL_LCYAN, COL_LRED,  COL_LMAGENTA,
		COL_YELLOW,  COL_WHITE } Colour;




typedef struct {
	unsigned char x, y;
} Point;


typedef struct {
	unsigned char x, y, w, h;
} Rect;

/* in this system, a callback function may be passed to a routine, and it 
 * would be periodically called to provide some measure of progress */

typedef void (*Callback_t) (void );

/* a menu can be built from a pair of arrays of these: one for a numerical
 * menu choice, a second as a vocabulary of command words */

typedef struct {
    String desc;
    String name;
    Action_t action;            /* func ptr - null implies quit */
    unsigned env_mask;          /* which devices are required to work */
} Cmd_t;





/*--------------------------------------------------------------------*/
/* User Interface Function Prototypes */

void mobo_cls(void);
void mobo_goto( Point );
void mobo_box( Rect, String );
const Cmd_t *mobo_cmdlookup( const char *S, const Cmd_t *C, const unsigned nC);
DBM_STATUS mobo_runcmd( const Cmd_t *, String );
int mobo_menu( const Cmd_t *, const unsigned, const Cmd_t *, const unsigned );
DBM_STATUS mobo_usercmd( const String );		/* run a cmd as typed by user */
void mobo_printf( const String, ... );
int mobo_key(int );	/* press any key, with timeout (in msec, if non-zero) */
int mobo_input( String, int );	/* input a whole string from user */
void mobo_zap( Rect );
UIstate mobo_uistate( UIstate );	/* control batch/interactive modes */

/* Alert an error with box title, brief (2-line) description */
char mobo_alertf( const String, const String, ... );

/* log an error in a non-interactive way */
void mobo_logf( const String, ... );

/* Degrees of severity */
#define LOG_INFO	"-- "
#define LOG_WARN	"?? "
#define LOG_CRIT	"!! "
#define LOG_DBG		"++ "


extern const String err_std;		/* Error classifications */



/*----------------------------------------------------------------------*/
/* Global Data */


#define CBUFSIZ 64
extern char cbuf[CBUFSIZ];             /* command text goes in here */ 
extern const String s_ekey;       	/* press any key: has 1000 uses... */

extern const Point beginning;		/* top left of a clear screen */
extern const Rect r_error;		/* Error region */
extern const Rect r_app, r_lrgapp;	/* application-specific area */
extern const Point p_app;		/* point inside above rectangle */
extern const Rect r_scrn;		/* entire screen */
extern const Point p_prompt, p_help;	/* help sentence and prompt string */


extern Point cursor;			/* cursor position (approx...) */
extern Point soft_cr;

extern unsigned long mem_start, mem_end;
extern BOOLEAN BootSROMPort;		/* are we using the SROM UART? */

extern const String mobo_version, compile_date, compile_time;

extern UIstate state;			/* set by mobo_uistate, don't write */

extern smp_mutex disp_lock;	/* use for control of ui between SMP CPUs */

#endif 	/* DIAGS__UILIB_H__LOADED */

