/*---------------------------------------------------------------------
 *        [ Copyright (c) 1999 Alpha Processor Inc.] - Unpublished Work
 *          All rights reserved
 * 
 *    This file contains source code written by Alpha Processor, Inc.
 *    It may not be used without express written permission. The
 *    expression of the information contained herein is protected under
 *    federal copyright laws as an unpublished work and all copying
 *    without permission is prohibited and may be subject to criminal
 *    and civil penalties. Alpha Processor, Inc.  assumes no
 *    responsibility for errors, omissions, or damages caused by the use
 *    of these programs or from use of the information contained herein.
 *  
 *-------------------------------------------------------------------*/


#include "lib.h"
#include "init.h"				/* our primordial world */
#include "memory.h"
#include "osf.h"
#include "impure.h"
#include "impure_struct.h"

typedef void (*ptrfn)( ImpureRgn_t *, volatile unsigned char *, 
			unsigned char *, unsigned char *, unsigned );


ImpureRgn_t *I;


/* As things stand at the time of writing, only the compressed Diags remains 
 * memory resident.  Information can be passed between the init image and 
 * the main kernel using flag variables.
 *
 * decompress_needed: we only attempt unpacking if this variable is TRUE.
 */
volatile unsigned char decompress_needed = TRUE;


/* entry_on_powerup: this is the first processor to enter Diags after 
 * powerup or reset.  This condition means that there will only be one CPU
 * around, until other processors are explicitly started.
 */

volatile unsigned char entry_on_powerup = TRUE;


/* The ID of the processor that did powerup initialisations.  This processor
 * remains our primary CPU throughout power up.
 */
volatile unsigned char bsp_id = 0; 		/* [bootstrap processor] */




/* This is the second stage in our multi-stage initialisation.  We arrive
 * here from the assembler in init_entry.S, and then pass up to dbm/main.c
 */

int init_main( ImpureRgn_t *impure_ptr, unsigned myid )
{
    ptrfn go_main;

    if( entry_on_powerup )
    {
	decompress_needed = TRUE;		/* defensive */
	bsp_id = myid;
	entry_on_powerup = FALSE;
    }

    /* This loop will wait for BSP to do the full setup and then we enter
     * the main routine more or less following one another */

    while ( decompress_needed && (myid != bsp_id) )
    {
	/* poll */
    }


    /* At this point, we need to determine whether initialisations need doing
     * specifically the unzipping of the main diags image.
     * This only needs doing if:
     * 1) we're the first cpu in after reset
     * 2) we're the first cpu in after halting an SMP kernel.
     *
     * Other reasons why we might enter here are:
     * 1) Secondary cpu invoked after reset.
     * 2) Any cpu that has just had a fault severe enough to re-enter console
     * 3) Any following cpu halting from an SMP kernel.
     *
     * On halting a kernel, all CPUs might halt together causing chaos...
     */

    if ( decompress_needed ) {
	I = impure_ptr;
	init_ioport();			/* bring SROM UART console online */
	init_putstr( "\n\n===========Hello World===========\x07\n" );

	init_putstr( "Uncompressing main image...\n" );
	init_unzip( &_mainimg_start, (void *)DIAGS_MAIN );
	imb();					/* sync Istream with Dstream */
	init_putstr( "done\n" );
    }

    /* now jump into the new image */
#ifdef PARANOIA
    outled( DIAGS_MAIN );
    outled( *(unsigned long *)DIAGS_MAIN );
#endif
    go_main = (ptrfn)( (void *)DIAGS_MAIN );
    init_putstr( "Entering diags main kernel\n" );
    go_main( impure_ptr, &decompress_needed, 
		&_diags_compressed_start, &_diags_compressed_end, myid );

    return 0;			/* may never reach here */
}

