#ifndef DIAGS__IRONAGATE_H__LOADED
#define DIAGS__IRONAGATE_H__LOADED
/*---------------------------------------------------------------------
 *        [ Copyright (c) 1999 Alpha Processor Inc.] - Unpublished Work
 *          All rights reserved
 * 
 *    This file contains source code written by Alpha Processor, Inc.
 *    It may not be used without express written permission. The
 *    expression of the information contained herein is protected under
 *    federal copyright laws as an unpublished work and all copying
 *    without permission is prohibited and may be subject to criminal
 *    and civil penalties. Alpha Processor, Inc.  assumes no
 *    responsibility for errors, omissions, or damages caused by the use
 *    of these programs or from use of the information contained herein.
 *  
 *-------------------------------------------------------------------*/
/* IronGate management library, (c) 1999 Alpha Processor, Inc.
 * Begun 19 January 1999 by Stig Telfer, Alpha Processor, Inc.
 */



enum ig_csr  {  IG_VENDORID,            /* AMD Vendor ID=0x1022 */
                IG_DEVICEID,            /* PCI Device ID=0x7006 */
                IG_COMMAND,             /* Command Register */
                IG_STATUS,              /* Status Register */
                IG_REVID,               /* die/stepping revision ID */
                IG_PROGIF,              /* Programming Interface */
                IG_SUBCLASS,            /* PCI subclass code */
                IG_BASECLASS,           /* PCI baseclass code */
                IG_LATENCY,             /* Latency timer in PCI bus clocks */
                IG_HEADER,              /* PCI header type */
                IG_BAR0,                /* AGP Memory Base Adddres Register */
                IG_BAR1,                /* AGP CSR Base Address Register */

		IG_BACSR0,		/* Base Address Chip Select Reg 0 */
		IG_BACSR1,		/* Base Address Chip Select Reg 1 */
		IG_BACSR2,		/* Base Address Chip Select Reg 2 */
		IG_BACSR3,		/* Base Address Chip Select Reg 3 */
		IG_BACSR4,		/* Base Address Chip Select Reg 4 */
		IG_BACSR5,		/* Base Address Chip Select Reg 5 */

                IG_ECC, 	        /* ECC Status register (offset 0x58) */
		IG_DRAM_MS,		/* DRAM Mode/Status Register */

		IG_PCI_ARB,		/* PCI Arbitration register */
                };


typedef union {
        uint8 *p8;
        uint16 *p16;
        uint32 *p32;
} reg_handle;



/*----------------------------------------------------------------------*/
/* function prototypes */

/* read */
reg_handle ig_rdcsr(enum ig_csr csr, reg_handle rval);

/* write */
int ig_wrcsr(enum ig_csr csr, reg_handle wval);

/* pretty-print to user-supplied buffer */
int ig_pcsr(enum ig_csr csr, reg_handle pval, char *buf);	

/* enable/disable Irongate ECC handling */
void ig_ecc( unsigned );
void ig_status( void );			/* print out status of IG error flags */

void igbase(void);
void igmem(void);
void igpci(void);
void igagp(void);
void iomem(void);

/*----------------------------------------------------------------------*/
/* Vendor ID - Device 0, offset 0x01-0x00 */
typedef struct {
	unsigned id : 16;
} VendorID_r;

typedef union {
	uint16 i;
	VendorID_r r;
} VendorID_t;


/*----------------------------------------------------------------------*/
/* Device ID - Device 0, offset 0x03-0x02 */
typedef struct {
	unsigned id : 16;
} DeviceID_r;

typedef union { 
	uint16 i;
	DeviceID_r r;
} DeviceID_t;


/*----------------------------------------------------------------------*/
/* Command Register - Device 0, offset 0x05-0x04 */
typedef struct {
	unsigned iospc : 1; 	/* always reads zero */
	unsigned memspc  : 1;	/* PCI memory space accesses? */
	unsigned iten : 1;		/* always 1: can be bus initiator */
	unsigned scmon : 1;		/* always 0 special cycles not chckd */
	unsigned mwic : 1;		/* always 0 - no mem write & invalid */
	unsigned vgaps : 1;		/* always 0 - palette rds not special */
	unsigned per : 1;		/* parity error resp: always 0 */
	unsigned step : 1;		/* address/data stepping : always 0 */
	unsigned serre : 1; 	/* 1 = sys err output driver enable */
	unsigned fbbce : 1;		/* fast back-back cycle : always 0 */
	unsigned zero : 6;		/* must be zero */
} Command_r;

typedef union { 
	uint16 i;
	Command_r r;
} Command_t;


/*----------------------------------------------------------------------*/
/* Status Register - Device 0, offset 0x07-0x06 */
typedef struct {
	unsigned zero : 4;		/* must be zero */
	unsigned cl : 1;		/* config space capa list: always 1 */
	unsigned pci66 : 1;		/* 66 MHz PCI support - always 0 */
	unsigned udf : 1;		/* user defined features - always 0 */
	unsigned fbbc : 1;		/* back-back transactions - always 0 */
	unsigned ppe : 1;		/* PCI parity error detected (0) */
	unsigned devsel : 2;	/* DEVSEL timing (always 01) */
	unsigned sta : 1;		/* signalled target abort (0) */
	unsigned rta : 1;		/* recvd target abort */
	unsigned ria : 1;		/* recvd initiator abort */
	unsigned serr : 1;		/* SERR has been asserted */
	unsigned dpe : 1;		/* DRAM parity error (0) */
} Status_r;

typedef union { 
	uint16 i;
	Status_r r;
} Status_t;


/*----------------------------------------------------------------------*/
/* Revision ID - Device 0, offset 0x08 */
typedef struct {
	unsigned step : 4;		/* stepping Revision ID */
	unsigned die : 4;		/* die Revision ID */
} RevID_r;

typedef union { 
	uint8 i;
	RevID_r r;
} RevID_t;


/*----------------------------------------------------------------------*/
/* Programming Interface - Device 0, offset 0x09 */
typedef struct { 
	unsigned val : 8;		/* programming interface (0x00) */
} ProgIF_r;

typedef union { 
	uint8 i;
	ProgIF_r r;
} ProgIF_t;


/*----------------------------------------------------------------------*/
/* Subclass code - Device 0, offset 0x0A */
typedef struct {
	unsigned val : 8;		/* processor bridge = 0x00 */
} Subclass_r;

typedef union {
	uint8 i;
	Subclass_r r;
} Subclass_t;


/*----------------------------------------------------------------------*/
/* Baseclass code - Device 0, offset 0x0B */
typedef struct {
	unsigned val : 8;		/* bridge baseclass = 0x06 */
} Baseclass_r;

typedef union {
	uint8 i;
	Baseclass_r r;
} Baseclass_t;


/*----------------------------------------------------------------------*/
/* Latency Timer - Device 0, offset 0x0D */
typedef struct {
	unsigned val : 8;		/* latency in PCI bus clocks */
} Latency_r;

typedef union {
	uint8 i;
	Latency_r r;
} Latency_t;


/*----------------------------------------------------------------------*/
/* PCI Header type - Device 0, offset 0x0E */
typedef struct {
	unsigned val : 8;		/* multifunction device = 0x80 */
} Header_r;

typedef union {
	uint8 i;
	Header_r r;
} Header_t;


/*----------------------------------------------------------------------*/
/* Base Address Register 0 - Device 0 offset 0x13-0x10 */
/* Used by the system BIOS memory mapping firmware to allocate virtual 
 * address space for AGP */
typedef struct {
	unsigned mem : 1;		/* Reg pts to memory (always 0) */
	unsigned type: 2;		/* 32 bit register = 0b00 */
	unsigned pref: 1;		/* graphics mem prefetchable=1 */
	unsigned baddrl : 21;	/* 32M = minimum alloc -> all zero */
	unsigned size : 6;		/* size requirements for AGP */
	unsigned zero : 1;		/* reserved=0 */
} BAR0_r;

typedef union { 
	uint32 i;
	BAR0_r r;
} BAR0_t;


/*----------------------------------------------------------------------*/
/* Base Address Register 1 - Device 0 offset 0x17-0x14 */
/* Used by the AGP driver software to set the memory location of the AGP 
 * memory mapped control registers */
typedef struct { 
	unsigned mem : 1;		/* BAR0 maps to memory -> 0 */
	unsigned type : 2;		/* BAR1 is 32-bit -> 0b00 */
	unsigned pref : 1;		/* graphics mem prefetchable=1 */
	unsigned baddrl : 8;	/* 4K alloc for AGP CSRs -> 0b00 */
	unsigned baddrh : 20;	/* base addr of AGP CSRs A[30:11] */
} BAR1_r;

typedef union { 
	uint32 i;
	BAR1_r r;
} BAR1_t;



/*----------------------------------------------------------------------*/
/* Base Address Chip Select Register 0 - Device 0 offset 0x41-0x40 */
/* Base Address Chip Select Register 1 - Device 0 offset 0x43-0x42 */
/* Base Address Chip Select Register 2 - Device 0 offset 0x45-0x44 */
/* Base Address Chip Select Register 3 - Device 0 offset 0x47-0x46 */
/* Base Address Chip Select Register 4 - Device 0 offset 0x49-0x48 */
/* Base Address Chip Select Register 5 - Device 0 offset 0x4B-0x4A */
typedef struct {
	unsigned en : 1;		/* memory bank enabled */
	unsigned mask : 6;		/* Address mask for A[28:23] */
	unsigned base : 9;		/* Bank Base Address A[31:23] */
} BACSR_r;

typedef union {
	uint16 i;
	BACSR_r r;
} BACSR_t;


/*----------------------------------------------------------------------*/
/* DRAM ECC Status Register - Device 0 offset 0x59-0x58 */
typedef struct {
	unsigned chipsel : 6;	/* failing ECC chip select */
	unsigned zero1 : 2;		/* always reads zero */
	unsigned status : 2;	/* ECC Detect logic status */
	unsigned zero2 : 6;		/* always reads zero */
} ECC_r;

typedef union {
	uint16 i;
	ECC_r r;
} ECC_t;


/*----------------------------------------------------------------------*/
/* DRAM Mode/Status Register - Device 0 offset 0x5B-0x5A */
typedef struct {
	unsigned cycles : 2;	/* cycles per refresh, see table */
	unsigned en : 1;		/* ECC enable */
	unsigned r : 1;		/* Large burst enable (=0) */
	unsigned bre : 1;		/* Burst refresh enable */
	unsigned zero1 : 2;		/* reserved = 0 */
	unsigned mwe : 1;		/* Enable writes to DRAM mode reg */
	unsigned type : 1;		/* SDRAM = 0, default */
	unsigned sdraminit : 1;	/* SDRAM init - set params first! */
	unsigned zero2 : 6;		/* reserved = 0 */
} DRAM_MS_r;

typedef union {
	uint16 i;
	DRAM_MS_r r;
} DRAM_MS_t;


/*----------------------------------------------------------------------*/
/* PCI Arbitration Control Register - Device 0 offset 0x87-0x84 */
typedef struct {
	unsigned park : 1;		/* Park PCI on last PCI master */
	unsigned ppe : 1;		/* PCI<-SDRAM prefetch enable */
	unsigned ape : 1;		/* AGP<-SDRAM prefetch enable */
	unsigned tltd : 1;		/* Target latency timer disable */
	unsigned ev6 : 1;		/* EV6 mode DMA (ie no holes) */
	unsigned m14 : 1;		/* create hole in mem from 14-15M */
	unsigned m15 : 1;		/* create hole in mem from 15-16M */
	unsigned pm : 1;		/* Power management (BAR2) access */
	unsigned sblkdis : 1;		/* SB lock disable */
	unsigned agpad : 1;		/* AGP Arbiter Pipelining disable */
	unsigned dispciep : 1;		/* Disable PCI early probe */
	unsigned disapciep : 1;		/* Disable AGP early probe */
	unsigned disrderr : 1;		/* Still report read errors on abort */
	unsigned apciwprtr : 1;		/* AGP write post retry - enable = 1 */
	unsigned pciwprtr : 1;		/* PCI write post retry - enable = 1 */
	unsigned rsrvd1 : 1;		/* reserved = 0 */
	unsigned rsrvd2 : 8;		/* reserved = 0 */
	unsigned agpbios : 8;		/* 16K VGA BIOS addr on AGP bus */
} PCI_arb_r;

typedef union {
	uint32 i;
	PCI_arb_r r;
} PCI_arb_t;

#endif 		/* DIAGS__IRONAGATE_H__LOADED */
