/*---------------------------------------------------------------------
 *        [ Copyright (c) 1999 Alpha Processor Inc.] - Unpublished Work
 *          All rights reserved
 *
 *    This file contains source code written by Alpha Processor, Inc.
 *    It may not be used without express written permission. The
 *    expression of the information contained herein is protected under
 *    federal copyright laws as an unpublished work and all copying
 *    without permission is prohibited and may be subject to criminal
 *    and civil penalties. Alpha Processor, Inc.  assumes no
 *    responsibility for errors, omissions, or damages caused by the use
 *    of these programs or from use of the information contained herein.
 *
 *-------------------------------------------------------------------*/
/* Tinosa is the Caspian chipset bring-up board */

#define TRACE_ENABLE			/* define to enable debug messages */

#include "lib.h"
#include "info.h"
#include "osf.h"
#include "mcheck.h"

#include "uilib.h"
#include "pci.h"

#include "cpu/ev6.h"

#include "specifics.h"			/* motherboard specific overrides */
#include "platform.h"			/* interface for this module */
#include "northbridge.h"		/* Generic NB access */
#include "southbridge.h"		/* Generic SB access */

#include "hwrpb.h"			/* for systype settings */

#include "tabledriver.h"



/*----------------------------------------------------------------------*/
/* Global definitions and data structures */

/* concise platform name for mfrg diagnostics prompt */
const char *Prompt = "Tinosa> ";


/* your platform bus config, defined according to the structure in pci.h */

#define ALIDESCSTR "ALI on-board"	/* should be a single variable */

static const PCISlot_t goby_compat[] = {
	{ PLAT_PCI_GOBY0,	"Caspian (PCI)" },
	{ PLAT_PCI_GOBY1,	"Caspian (LDT)" },
	{ PLAT_PCI_ALI_ISA, 	ALIDESCSTR },
	{ PLAT_PCI_ALI_PMU,	ALIDESCSTR },
	{ PLAT_PCI_ALI_USB,	ALIDESCSTR },
	{ PLAT_PCI_ALI_IDE,	ALIDESCSTR },
	{ PLAT_PCI_GOBY_SLOT0,	"Goby PCI slot" },
	{ 0, 0 }
};

static const PCISlot_t sturgeon[N_STURGEONS][SLOTS_PER_STURGEON+1] = {
    {							/* Sturgeon 0 */
	{ PLAT_PCI_ST0_SLOT1,	"PCI Slot 0" },
	{ PLAT_PCI_ST0_SLOT2,	"PCI Slot 1" },
	{ 0, 0 }
    }, {						/* Sturgeon 1 */
	{ PLAT_PCI_ST1_SLOT3,	"PCI Slot 2" },
	{ PLAT_PCI_ST1_SLOT4,	"PCI Slot 3" },
	{ 0, 0 }
    }, {						/* Sturgeon 2 */
	{ PLAT_PCI_ST2_SLOT5,	"PCI Slot 4" },
	{ PLAT_PCI_ST2_SLOT6,	"PCI Slot 5" },
	{ 0, 0 }
    }
};


/* note - ordering here is critical, it must match the bus numbering as
 * decided by the PCI device tree building algorithm */

const PCIStructure_t PCIStructure[] = {
    { VARIANT_PCI, goby_compat },	/* Goby 32-bit 33 MHz compat bus */
    { VARIANT_PCI, sturgeon[0] },	/* Sturgeon 0 */
    { VARIANT_PCI, sturgeon[1] },	/* Sturgeon 1 */
    { VARIANT_PCI, sturgeon[2] },	/* Sturgeon 2 */
};

const short plat_pci_hose_count = ARRAYLEN( PCIStructure );



/* platform number codes for HWRPB and loading linux */
const unsigned plat_sys_type = ST_API_NAUTILUS;	/* FIXME */
const unsigned plat_sys_variation = 1<<10;	/* traditional choice */


/*----------------------------------------------------------------------*/
/* Basic Interface function prototypes */
/* apply platform-specific initialisations */
DBM_STATUS plat_setup( void )
{
    return STATUS_SUCCESS;
}

DBM_STATUS plat_fixup( void )
{
    return STATUS_SUCCESS;
}

DBM_STATUS plat_post( void )
{
    /* Tinosa currently has no urgent diag tests for bootup path */
    return STATUS_SUCCESS;
}


DBM_STATUS plat_reset( int argc, char *argv[] )	/* Reset this platform */
{
    outportb( 0x92, 0x01 );		/* toggle port 92 to reset */

    sleep( 1 );
    mobo_logf( LOG_WARN "RESET: nothing happened!\n" );
    return STATUS_FAILURE;			/* reset not successful */
}


#error "Tinosa plat_infodump needs fixing"
void plat_infodump( void )	/* dump sys info to the log stream */
{
    unsigned long cpu_freq;
    unsigned mem_size;
    unsigned char srom_major, srom_minor;
    unsigned *palbase, pal_minor, pal_major;
    int bcache;
    char gobyrev[32], alirev[32];
    unsigned myid = smp_myid();

    mobo_logf(  LOG_INFO "===== API Tinosa Platform =====\n" );

    /*--------------------------------------------------------------------*/
    /* Information gathered from the SROM and PALcode */

    mem_size = primary_impure->MEM_SIZE >> 20;

    cpu_freq = 1000000000UL / primary_impure->CYCLE_CNT;        /* in kHz */
    cpu_freq = (cpu_freq + 500) / 1000;                 /* in MHz, rounded */

    /* SROM revision number has major revision as lowest byte */
    srom_major = primary_impure->SROM_REV & 0xFFU;
    srom_minor = (primary_impure->SROM_REV >> 8) & 0xFFU;

    palbase = (unsigned *)(DBM_SUPER | primary_impure->PAL_BASE);
    pal_major = (palbase[2] >> 8) & 0xFF;
    pal_minor = palbase[2] & 0xFF;

    if ( impure[myid]->BEHAV_DATA != 0)
         bcache = ( impure[myid]->BEHAV_DATA >> 8 ) & 0xFF;
    else bcache = -1;

    /*--------------------------------------------------------------------*/
    /* Information gathered from various system CSRs */

    goby_revstr( gobyrev );
    ali_revstr( alirev );

    mobo_logf(  LOG_INFO "System memory:       %d Mbytes\n"
		LOG_INFO "This processor:      %d\n"
		LOG_INFO "Primary processor:   %s\n"
		LOG_INFO "CPU Frequency:       %d MHz\n"
		LOG_INFO "Samsung Alpha Rev:   %s\n" 
		LOG_INFO "B-cache Size:        %d MB %s\n"
		LOG_INFO "API Goby Rev:        %s\n" 
		LOG_INFO "ALI Southbridge Rev: %s\n"
		LOG_INFO "SROM Firmware Rev:   %d.%d (0x%X)\n"
		LOG_INFO "PALcode Rev:         %d.%d (at 0x%08X)\n"
		LOG_INFO "Mfrg. Diags Rev:     %s (%s)\n\n" ,
		mem_size,
		nb_whami(),
		smp_primary() ? "Yes" : "No",
		cpu_freq,
		ev6_cpurev( impure[myid]->I_CTL ),
		bcache, bcache == -1 ? "(unknown)" : "",
		gobyrev,
		alirev,
		srom_major, srom_minor, primary_impure->SROM_REV,
		pal_major, pal_minor, palbase,
		MOBO_VERSION, COMPILE_DATE
		);

}


/* System status string, for printing out during memory stress test */
/* we have four lines of room here */

void plat_sysstat( String S )	/* system status, for memory test */
{
    unsigned short gobyecc;
    unsigned gobycmdstat;
    char eccbuf[2][32];
    unsigned chipsel, stat;
    unsigned sys61, sbnmi;
    unsigned ipl = swpipl( 7 );
    swpipl( ipl );                      /* find our IPL */

    gobycmdstat = pcicfgrl( 0, GOBY0_DEV, 0, GOBY0_CMD );
    gobyecc = pcicfgrw( 0, GOBY0_DEV, 0, GOBY0_ECC );

    chipsel = gobyecc & 0xF;
    stat = (gobyecc >> 6) & 0x3;
    if ( stat == 0 )		sprintf_dbm( eccbuf[0], "OK" );
    else sprintf_dbm( eccbuf[0], "%s%sCS %d",
		(stat & 0x1) ? "multi " : "", (stat & 0x2) ? "single " : "",
		chipsel );

    chipsel = (gobyecc >> 8) & 0xF;
    stat = (gobyecc >> 14) & 0x3;
    if ( stat == 0 )		sprintf_dbm( eccbuf[1], "OK" );
    else sprintf_dbm( eccbuf[1], "%s%sCS %d",
		(stat & 0x1) ? "multi " : "", (stat & 0x2) ? "single " : "",
		chipsel );


    /* bits 6,7 report NMI has occurred, bits 3,2 are pulsed high to reset */
    sys61 = inportb( 0x61 );                        /* NMI ctrl/status port */

    /* bit 0 in this register is 1 if SERR->NMI is enabled */
    sbnmi = pcicfgrb( 0, PLAT_PCI_ALI_ISA, 0, ISA_PIPM );

    sprintf_dbm( S, "Goby: system NMI is %s and %s\r"
                    "Goby: ECC on port 0: %s, port 1: %s\r"
                    "Southbridge: system NMI reporting is %s, NMI is %s\r"
                    "System interrupt level %d (0=all enabled, 7=all disabled)",
                    gobycmdstat & 0x0100 ? "enabled" : "disabled",
                    gobycmdstat & 0x40000000 ? "asserted" : "clear",
                    eccbuf[0], eccbuf[1],
                    (sbnmi & 1) ? "enabled" : "disabled",
                    (sys61 & 0xC0) ? "asserted" : "clear",
                    ipl );
}


/*----------------------------------------------------------------------*/
/* Platform-level interrupt management */

static const TblArray configure_sb_int_routings[] = {

    CFGWB( 0, PLAT_ISAID, 0, ISA_PIRT1, 0x99 ),  /* all PCI ints to IRQ 11 */
    CFGWB( 0, PLAT_ISAID, 0, ISA_PIRT2, 0x99 ),
    CFGWB( 0, PLAT_ISAID, 0, ISA_PIRT3, 0x00 ),  /* unused in nonpoll mode */
    CFGWB( 0, PLAT_ISAID, 0, ISA_PIRT4, 0x00 ),

    OP_EOT
};

/* enable/disable all system IRQs, note: doesn't change current IPL */
void plat_intsetup( int ena )	
{
    int rval;
    uint64 lir;
    unsigned irq_base;

    TRACE( "Running...\n" );
    plat_intclr();                      /* wipe the slate clean beforehand */

    if ( ena )                            /* enabling case */
    {
#if 0	/* These may come in handy later but now they're in the way */

        /* Note: IRQ 8 is disabled because the RTC is directly connected */
        /* DEBUG - here I disable IRQ 15 because it is annoying me... */
        mobo_logf( LOG_INFO "Enabling ISA interrupts...\n");
        outportb( 0x21, 0x00 );                     /* IRQs 0-7, active low */
        outportb( 0xA1, 0x81 );                     /* IRQs 8-15, active low */

        mobo_logf( LOG_INFO "Enabling PCI interrutps...\n");
        rval = pcicfgrb( 0, PLAT_ISAID,
                        0, ISA_PIPM );          /* disable polling mode */
        rval &= ~(1<<7);                            /* clr bit 7 (poll mode) */
        pcicfgwb( 0, PLAT_ISAID,
                        0, ISA_PIPM, rval );    /* see SB PIPM register... */

        TblWrite( configure_sb_int_routings );
#endif


	/* Goby's Krazy Interrupts... */
 	TRACE( "Configuring Goby Local Interrupts\n" );
	irq_base = goby_irq_base();
	lir = inmemq( irq_base + GOBY_IRQ_LIR );
	TRACE( "Local interrupts was 0x%016lX\n", lir );
	lir |= LIR_TIMER_EN | LIR_NMI_EN | LIR_LOCL_EN;	/* NB no SMI yet... */
	outmemq( irq_base + GOBY_IRQ_LIR, lir );
	TRACE( "Local interrupts now 0x%016lX\n", lir );

	/* Program logical IDs and masks for interrupt identification */
        outmemq( irq_base + GOBY_IRQ_II0,
		(0<<II_LOGM_S) | (0<<II_LOG_S) | (0<<II_PHYS_S) );
        outmemq( irq_base + GOBY_IRQ_II1,
		(0<<II_LOGM_S) | (1<<II_LOG_S) | (1<<II_PHYS_S) );
	TRACE( "Interrupt identification is: 0:%0x%016lX, 1:%016lX\n",
		inmemq( irq_base + GOBY_IRQ_II0 ),
		inmemq( irq_base + GOBY_IRQ_II1 ) );
    }
    else
    {
        /* disabling case */
        mobo_logf( LOG_INFO "Disabling ISA interrupts...\n");
        outportb( 0x21, 0xFF );                     /* IRQs 0-7, active low */
        outportb( 0xA1, 0xFF );                     /* IRQs 8-15, active low */
    }
}

void plat_intclr( void )	/* clear any pending interrupts */
{
    unsigned char iis0, iis1;
    int iters;
    int irq;
    int ipl;

    ipl = swpipl( 7 );                  /* noodling this stuff is dangerous */

#define MAX_ACKS        16

    /* until there are no more interrupts in service, send EOI signals */
    for ( iters=0; iters < MAX_ACKS; iters++)          /* 8 IRQ lines per reg */
    {
        irq = inIack();                         /* ack the int, returns IRQ */

        /* read Int in-service regs */
        outportb( 0x20, 0x0B );
        iis0 = inportb( 0x20 );
        outportb( 0xA0, 0x0B );
        iis1 = inportb( 0xA0 );

        if ( iis0 == 0 && iis0 == 0 )   break;

        if ( iis0 )      outportb( 0x20, 0x20 );                /* EOI */
        if ( iis1 )      outportb( 0xA0, 0x20 );                /* EOI */
    }

    swpipl( ipl );                      /* restore previous IPL */

    if ( iters >= MAX_ACKS )
        mobo_logf( LOG_CRIT "ERROR - recurring interrupts - not clearing\n");
}

void plat_nmiclr( void )	/* clear any pending NMIs */
{
}

void plat_mchkinterp( String interp, int scb, LogoutFrame_t *L)
{
}


/*----------------------------------------------------------------------*/
/* low-level multiprocessor support */

/* start secondary CPUs, argument is PALbase */
void plat_smpstart( unsigned long palbase )
{
    volatile unsigned long *t0 = (unsigned long *)(DBM_SUPER | 0x100UL);
    volatile unsigned long *t1 = (unsigned long *)(DBM_SUPER | 0x108UL);

    TRACE( "Starting secondary processor at palbase %x...\n", palbase );

    /* Inform all processors (two in this case) where the PALbase is */
    *t0 = palbase;
    asm("mb");
    *t1 = palbase;
    asm("mb");

    /* Fire the starting gun.  Eric defines this as clearing the MSB in 
     * Goby scratch CSR #7.  For simplicity here we clear the entire CSR
     */
    pcicfgwl( 0, GOBY0_DEV, 0, GOBY0_SCRATCH7, 0x00000000U );
}
	


/*--------------------------------------------------------------------*/
/* I2C System management bus access routines */

/* Published data */
/* A data structure enumerating and describing the I2C devices */

const I2Cbus_t plat_i2c_bus[] = {
    { I2C_NODEV, 0, 0, 0, 0, NULL }
};


DBM_STATUS plat_i2c_select( const I2Cbus_t *I )
{
    /* do nothing */
    return STATUS_SUCCESS;
}


DBM_STATUS plat_i2cinit(void )
{
    return STATUS_SUCCESS;
}



/*----------------------------------------------------------------------*/

