#ifndef DIAGS__CYPRESS_H__LOADED
#define DIAGS__CYPRESS_H__LOADED
/*---------------------------------------------------------------------
 *        [ Copyright (c) 1999 Alpha Processor Inc.] - Unpublished Work
 *          All rights reserved
 * 
 *    This file contains source code written by Alpha Processor, Inc.
 *    It may not be used without express written permission. The
 *    expression of the information contained herein is protected under
 *    federal copyright laws as an unpublished work and all copying
 *    without permission is prohibited and may be subject to criminal
 *    and civil penalties. Alpha Processor, Inc.  assumes no
 *    responsibility for errors, omissions, or damages caused by the use
 *    of these programs or from use of the information contained herein.
 *  
 *-------------------------------------------------------------------*/
/* Cypress CY82C693 Southbridge access routines */
/* Begun 29 June 1999 by Stig Telfer, API */

/* function codes for PCI CSR access */

#define CY_ISA	0
#define CY_IDE0	1
#define CY_IDE1	2
#define CY_USB	3


/* PCI to ISA bridge CSRs in PCI configuration space */

#define CY_COMMAND_REG		0x04
#define CY_INTA_ROUTE		0x40
#define CY_INTB_ROUTE		0x41
#define CY_INTC_ROUTE		0x42
#define CY_INTD_ROUTE		0x43
#define CY_CONTROL_REG		0x44
#define CY_ERR_CONTROL_REG	0x45
#define CY_BIOS_CONTROL_REG	0x47
#define CY_TOP_OF_MEM		0x48
#define CY_ATCTRL_REG1		0x49
#define CY_ATCTRL_REG2		0x4A
#define CY_IDE0_ROUTE		0x4B
#define CY_IDE1_ROUTE		0x4C
#define CY_SA_USB_CTRL		0x4D


/* IDE controller CSRs */

#define IDE_VENDORID		0x00		/* 16-bit */
#define IDE_DEVICEID		0x02		/* 16-bit */
#define IDE_COMMAND		0x04		/* 16-bit */
#define IDE_STATUS		0x06		/* 16-bit */
#define IDE_REVID		0x08		/* 8-bit */
#define IDE_CLASSCODE		0x09		/* 32-bit */
#define IDE_HTYPE		0x0E		/* 8-bit */
#define IDE_CMDADDR		0x10		/* 32-bit */
#define IDE_CTRLADDR		0x14		/* 32-bit */
#define IDE_BMADDR		0x20		/* 32-bit */
#define IDE_INTA		0x3C		/* 8-bit */
#define IDE_INTPIN		0x3D		/* 8-bit */


#endif 	/* DIAGS__CYPRESS_H__LOADED */
