#ifndef	DIAGS__PIC_H_LOADED
#define	DIAGS__PIC_H_LOADED
/*---------------------------------------------------------------------
 *        [ Copyright (c) 1999 Alpha Processor Inc.] - Unpublished Work
 *          All rights reserved
 * 
 *    This file contains source code written by Alpha Processor, Inc.
 *    It may not be used without express written permission. The
 *    expression of the information contained herein is protected under
 *    federal copyright laws as an unpublished work and all copying
 *    without permission is prohibited and may be subject to criminal
 *    and civil penalties. Alpha Processor, Inc.  assumes no
 *    responsibility for errors, omissions, or damages caused by the use
 *    of these programs or from use of the information contained herein.
 *  
 *-------------------------------------------------------------------*/
/* Programmable interrupt controller (PIC) control */

enum _irq_numbers {
 IRQ0 = 0,
 IRQ1 = 1,
 IRQ2 = 2,
 IRQ3 = 3,
 IRQ4 = 4,
 IRQ5 = 5,
 IRQ6 = 6,
 IRQ7 = 7,
 IRQ8 = 8,
 IRQ9 = 9,
 IRQ10 = 10,
 IRQ11 = 11,
 IRQ12 = 12,
 IRQ13 = 13,
 IRQ14 = 14,
 IRQ15 = 15
};

#define IRQ_ENABLE	TRUE
#define IRQ_DISABLE	FALSE

#define IRQ_EDGE	TRUE
#define IRQ_LEVEL	FALSE

/* Enable or disable a particular IRQ */
void pic_irq_ena( unsigned irq, unsigned ena );

/* Set a particular IRQ to edge or level triggering */
void pic_irq_trig( unsigned irq, unsigned trig );

/* EOI */
void pic_irq_eoi( unsigned irq );

#endif 		/* DIAGS__PIC_H_LOADED */
