/* IODev.h - define I/O device type for runtime library I/O support
 * Copyright  1997-1999 by Object Software Inc. - All Rights Reserved
 *
 * The authors hereby grant permission to use, copy, modify, distribute,
 * and license this software and its documentation for any purpose, provided
 * that existing copyright notices are retained in all copies and that this
 * notice is included verbatim in any distributions. No written agreement,
 * license, or royalty fee is required for any of the authorized uses.
 *
 * This file defines the generic structure of a simple low-level I/O driver
 * system for use in embedded systems which do not have a host operating system.
 * A simple device table is used to allow open (), close (), etc to
 * address each port by name. These routines are designed to interface with newlib.
 */

#ifndef	IODEV_H
#define	IODEV_H

#include <unistd.h>
#include <stdarg.h>

#ifdef __cplusplus
extern "C" {
#endif

typedef struct sIODev
{
	char *Name;
	int *Flags;
	int (*open) (struct sIODev *Device, int filedes, int flags, va_list args);
	int (*close) (struct sIODev *Device, int filedes);
	int (*read) (struct sIODev *Device, int filedes, void *_buf, size_t _nbyte);
	int (*write) (struct sIODev *Device, int filedes, const void *_buf, size_t _nbyte);
	long (*drivercontrol) (struct sIODev *Device, int filedes, int function, va_list args);
	void *DeviceInfo;
} tIODev;

#include <sys/IODctrl.h>

#ifdef __cplusplus
}
#endif

#endif

