package sorcererII;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;

import javax.imageio.ImageIO;
import javax.swing.JFileChooser;

public class JSorcererSnapshotControl extends JMonostableImageButton {
  
  /**
   * 
   */
  private static final long serialVersionUID = 5184346364731454400L;
  
  private final Sorcerer _sorcerer;
  private File _file = new File("snaps/");
  
  public JSorcererSnapshotControl(final Sorcerer sorcerer) throws IOException {
    super(ImageIO.read(new File("images/icon-camera-grey.png")),
          ImageIO.read(new File("images/icon-camera.png")),
          "Take a snaphot");
    _sorcerer = sorcerer;
  }
  
  @Override
  public void gotoState1() {
  }

  @Override
  public void gotoState2() {
    _sorcerer.stop();
    try
    {
      final JFileChooser fc = new JFileChooser(_file);
      final int returnVal = fc.showSaveDialog(JSorcererSnapshotControl.this);
      if (returnVal == JFileChooser.APPROVE_OPTION) {

        try {
          _file = fc.getSelectedFile();
          final OutputStream os = new  FileOutputStream(_file);
          final BufferedOutputStream bos = new BufferedOutputStream(os);
          try {
            _sorcerer.saveSNP(bos);
            bos.flush();            
          }
          finally {
            os.close();
          }
        }
        catch (final IOException ex) {
          // TODO Handle error
        }
      }    } 
    finally {
      _sorcerer.start();
    }
  }
}
