package sorcererII;

import java.io.*;

public class RomToHex
{
  private static String hexChars = "0123456789ABCDEF";

  private static String toHexString( int b )
  {
    char c1 = hexChars.charAt( b & 0xf );
    char c2 = hexChars.charAt( ( b >> 4 ) & 0xf );
    return "" + c2 + c1;
  }

  public static void main( String[] args )
  {
    if( args.length != 1 )
    {
      System.out.println( "usage: java RomToHex <romFileName>" );
    }
    else
    {
      try
      {
        String romFileName = args[ 0 ];

        System.out.println( "Reading from " + romFileName );

        InputStream _input = new FileInputStream( romFileName );

        int data = 0;
        while( data >= 0 )
        {
          for( int i = 0; i < 16; ++i )
          {
            data = _input.read();

            if( data < 0 ) break;

            System.out.print( toHexString( data ) + " " );
          }

          System.out.println( "" );
        }

      }
      catch( Exception e )
      {
        e.printStackTrace();
      }
    }

  }
}