package sorcererII;

import java.awt.image.*;

public class SorcererImageProducer implements ImageProducer
{
  private ImageConsumer _consumer;
  private int _width;
  private int _height;
  private ColorModel _cm;
  private int[] _pixels;
  private int _hints;
  private int _sfd;

  public SorcererImageProducer(int width, int height, ColorModel cm, int pixels[])
  {
    _width = width;
    _height = height;
    _cm = cm;
    _pixels = pixels;

    _hints = ImageConsumer.TOPDOWNLEFTRIGHT |
             ImageConsumer.COMPLETESCANLINES |
             ImageConsumer.SINGLEPASS |
             ImageConsumer.SINGLEFRAME;

    _sfd = ImageConsumer.SINGLEFRAMEDONE;
  }

  public void addConsumer( ImageConsumer consumer )
  {
    _consumer = consumer;
  }

  public final void startProduction( ImageConsumer consumer )
  {
    if( _consumer != consumer )
    {
      _consumer = consumer;
      _consumer.setDimensions( _width, _height );
      _consumer.setProperties( null );
      _consumer.setColorModel( _cm );
      _consumer.setHints( _hints );
    }
    consumer.setPixels( 0, 0, _width, _height, _cm, _pixels, 0, _width );
    consumer.imageComplete( _sfd );
  }


  public void update()
  {
    if( _consumer != null) startProduction( _consumer );
  }

  public final boolean isConsumer( ImageConsumer consumer )
  {
    return _consumer == consumer;
  }

  public final void requestTopDownLeftRightResend(ImageConsumer imageconsumer)
  {
  }

  public final void removeConsumer(ImageConsumer imageconsumer)
  {
  }
}
