; HP 9895A floppy disk firmware
; Partially reverse-engineered by Eric Smith <spacewar@gmail.com>
; and Craig Ruff

; Cross-assembles with Macro Assembler AS:
;   http://john.ccac.rwth-aachen.de:8000/as/

; FDD Jumper configuration (From 09895-90030 service manual):
; Jumpered: A, DD, HO, I, IU, NS, R, RI, RR, SS, S2, TS, WP, X
;       A: Gate DRIVE-SELECT with HEAD-LOAD
;       D & DL: door lock latches
;       DC: enable -DISK-CHANGE latched when not selected, resets if drive READY on deselection?
;       A: Gate HEAD-LOAD with DRIVE-SELECT to latch head load signal
;       2S: enable two sided signal
; Open:     B, C, DR, E, FS, HS, NP, OS, S, S1, S3, Y, Z

; Other I/O port defintions


data	        port	60h             ; in/out
                                        ; drive data shift register

clock	        port	61h             ; in/out
                                        ; drive clock shift register

drv_status      port	62h             ; in only
                                        ; drive status signals
                bdef    7, TWOSIDE      ; 1 = disc is two sided (drive TWO SIDED signal)
                bdef    6, OVERUN       ; 1 = data overrun error
                bdef    5, CRCERR       ; 1 = CRC error, valid after last check bit clocked into 74F401
                bdef    4, READY        ; 1 = disc has rotated at least 2 revs (index hole detected)
                bdef    3, WRPROT       ; 1 = write protected (drive WRITE PROTECT signal)
                bdef    2, TRACK0       ; 1 = at track 0
                bdef    1, DISCHNG      ; 1 = door was opened (drive DISK CHANGE signal)
                                        ;     (loss of READY - when drive is not selected)
                bdef    0, INDEX        ; 1 = index hole deteted (pulsed)

reset	        port	62h             ; out only
                                        ; latched signal resets
                bdef    3, PROGRES      ; 1 = Program reset (resets other devices except the CPU)
                bdef    1, r_OVERUN     ; 1 = reset OVERUN
                bdef    0, r_TIMEOUT    ; 1 = reset TIMEOUT

switches        port	63h             ; in only
                                        ; various switches and misc status signals
                equ     NOSW, 4
                                        ; When read as port 67h, the switches state is not sampled
                                        ; and reads as zero bits.
                bdef    7, AMDT         ; bit 7: 1 = Address Mark Detected
                bdef    6, TIMEOUT
                bdef    5, LOOP         ; Test LOOP jumper 1 = installed
                bdef    4, SELFTEST     ; 1 = self test sw pressed
                bdef    3, WRTEST       ; 1 = write test enable sw
                bfield  2, 0, ADDRESS_SW ; HP-IB Address Switches

leds	        port	63h             ; out only
                                        ; LEDs (and 09895-66506 Flexible Disc Controller Self Test Monitor)
                bfield  7, 5, SUBTEST   ; subtest number LEDs bits 2..0 (Monitor only)
                bfield  4, 1, TESTNUM   ; LEDs bits 3..0 (marked ABCD)
                bdef    0, DONE         ; LED (marked *, 1 = self test code, 0 = in use codes)

cntl	        port	64h             ; out only
                                        ; drive and other control signals
                                        ; bit 7: NC
                                        ; bit 6: NC
                bdef    5, READON
                bdef    4, CRCOUT       ; => 74175 CWE 0 = data bits in, 1 = CRC bits out
                bdef    3, WRITDRV      ; 1 = drive write mode enabled (drive WRITE GATE signal)
                bdef    2, WRITON
                bdef    1, CRCON        ; => 74175 PRESET 0 = preset, 1 = calculate
                                        ; bit 0: NC

drv	        port	65h             ; out only
                                        ; drive and other control signals
                bdef    7, HEAD1        ; bit 7: 1 = Head 1, 0 = Head 0 (drive HEAD SELECT signal)
                                        ; bit 6: NC
                                        ; bit 5: NC
                bdef    4, LOWCURR      ; bit 4: reduce write current for inner tracks (>= 43)
                bdef    3, HEADLOAD     ; bit 3: 1 = assert IN-USE (drive IN-USE signal)
                                        ;        IN-USE has multiple uses on the FDD:
                                        ;            1. turn on the LED
                                        ;            2. lock the door
                                        ;            3. load the heads
                bdef    2, MGNENA       ; bit 2: 1 = enable reduced margins for good data
                                        ;        (Also may affect the Z80 WAIT signal?)
                                        ; margin enable?? check use in read-verify
                bdef    1, MOVEIN       ; bit 1: 1 = towards center, 0 = towards edge (drive DIRECTION SELECT signal)
                bdef    0, STEP         ; bit 0: perform step (pulsed)

xv	        port	66h             ; out only
                                        ; extra signals and drive select lines
                                        ; bit 7: NC
                                        ; bit 6: NC
                bdef    5, PRECMP       ; bit 5: enable precompensation
                bdef    4, HIDEN        ; bit 4: enable high density
                bfield  3, 0, DRV_SEL   ; bits 3..0: Drive select lines
                bdef    3, DRV0         ; (drive DRIVE SELECT 1 signal)
                bdef    2, DRV1         ; (drive DRIVE SELECT 2 signal)
                bdef    1, DRV2         ; (drive DRIVE SELECT 3 signal)
                bdef    0, DRV3         ; (drive DRIVE SELECT 4 signal)

monitor_U6	port	67h             ; out: 09895-66506 Flexible Disc Controller Self Test Monitor
                                        ; in: read switches without the switch bits
                bdef    7, ERROR        ; LED
                bdef    6, HEAD         ; LED
                bfield  5, 4, UNIT      ; LEDS
                bdef    3, HPFMT        ; LED
                ;bdef   ,2              ; Feeds U8 NAND to U7 /CLK
                bfield  1, 0, SUBTEST_MSB ; subtest number bits 4..3
