/**********************************************************/
/* IBM 3278 keyboard to PS/2                              */
/*                                                        */
/* Copyright (c) 2001, Jamie Honan                        */
/*                                                        */
/* All rights reserved.                                   */
/*                                                        */
/* This program is free software; you can redistribute it */
/* and/or modify it under the terms of the GNU General    */
/* Public License as published by the Free Software       */
/* Foundation; either version 2 of the License, or        */
/* (at your option) any later version.                    */
/*                                                        */
/* This program is distributed in the hope that it will   */
/* be useful, but WITHOUT ANY WARRANTY; without even the  */
/* implied warranty of MERCHANTABILITY or FITNESS FOR A   */
/* PARTICULAR PURPOSE.  See the GNU General Public        */
/* License for more details.                              */
/*                                                        */
/* You should have received a copy of the GNU General     */
/* Public License along with this program; if not, write  */
/* to the Free Software Foundation, Inc.,                 */
/* 59 Temple Place, Suite 330, Boston, MA  02111-1307 USA */
/*                                                        */
/* Licence can be viewed at                               */
/* http://www.fsf.org/licenses/gpl.txt                    */
/*                                                        */
/**********************************************************/

// keysta defines 

#ifndef KEYSTA_H
   #define KEYSTA_H

/* Interface to the keyboard simulator interrupt routines is via
   flags byte and three routines. Interface is done this
   way to conserve data and program space */

void init_kbd(void);

/* Request to transmit a character (txchar) when possible. 
   Only call this routine when TX_BUF_EMPTY in kbd_flags is set. */
void  kbd_set_tx(unsigned char txchar);

/* This routine gets the recently received character. 
   When kbd_flags has RX_BUF_FULL set, a character has been received.
   Test if FLA_RX_BAD is set, which means a bad character was 
   received (e.g. bad parity or missing stop bit). */

unsigned char kbd_get_rx_char(void);

#define FLA_CLK_HIGH	0x01  // PS2 clock set high 
#define FLA_RX_BAD	0x02  // Bad parity or missing stop bit.
#define RX_BUF_FULL	0x04  // Received a byte from HOST. 
#define TX_BUF_EMPTY	0x08  // Tx to HOST has completed.
#define FLA_TX_OK	   0x10  // Tx ok flag 

#endif
