/*
 * UART routines (only transmit)
 */

// Some includes
#include <inttypes.h>
#include <avr/io.h>
#include <avr/pgmspace.h>
#include <avr/interrupt.h>

#include "global.h"
#include "IBM_keyboard.h"
#include "uart.h"

// Send one character to the UART.
int uart_putchar (char c) {
	if (c == '\n')
      uart_putchar('\r');  // Recursive call

	// Wait for empty tx buffer.
	loop_until_bit_is_set(UCSR0A, UDRE0);
		
	UDR0 = c;               // Send it away...
	return (0);
}


// Initialise the UART
void init_uart (void) {

	// Enable TXEN in Register UCR
	UCSR0B = (1 << TXEN0);
	UCSR0A |= (1 << U2X0);

	// Set UART divider  
	UBRR0 = (F_CPU / (UART_BAUD * 8L) - 1);
}





