static char vj_scsiHSid[]="@(#)vj_scsi.h	30.1 3/13/91 AppEng/SCCS Interphase";

/* in vi :set ts=4
 **** REVISION HISTORY:
 **   DATE     ID   VER     COMMENT
 ** 03/13/91 rbrant 30.1    New development/distribution format.
 ** 03/13/91  jdb   23.4    added structure for reading defect lists from drive
 ** 12/18/90  jdb   23.4    added support for Sony Magneto Optical drive
 ** 10/22/90  jdb   23.3    changed mode select page structures.
 ** 08/30/90  JQO   23.2    BUMPED TO NEW SBU/SCCS LEVEL.
 ** 08/15/90  JQO    3.2    Bumped SCCS version level to coincide with RCS 
 **                         version 3.2 
 **                         Added SCCS to header for id at what command.
 **                  2.2    Support HP DAT.
 **                         Mode_sense/mode_select cmd is issued on individual 
 **                         pages, not on 0x3F.
 **
 ****/

/****************     SCSI Control Description Block     ******************/

typedef struct  scsi_cdb {		/* SCSI command desc block (group code 0) */
	UBYTE	cmd;            	/* command code                           */
	UBYTE	lun       : 3;  	/* logical unit number                    */
	UBYTE	high_addr : 5;		/* High address MSB                       */
	UBYTE	mid_addr;		  	/* Logical block address                  */
	UBYTE	low_addr;		  	/* Logical block address                  */
	UBYTE	count;		    	/* block count lsb                        */
	UBYTE	vu        : 2;  	/* vendor unique (byte 5 bit 7)           */
	UBYTE   res0      : 4;  	/* reserved                               */
	UBYTE	flag      : 1;  	/* flag request (interrupt at completion) */
	UBYTE	link      : 1;  	/* link (another command follows)         */
} SCSI_CDB;

typedef struct  scsi_cdb_1 {	/* SCSI command desc block (group code 1) */
	UBYTE	cmd;            	/* command code                           */
	UBYTE	lun       : 3;  	/* logical unit number                    */
	UBYTE	res0	  : 4;		/* reserved		                          */
	UBYTE	reladr	  : 1;		/* relative address                       */
	UBYTE	blk_addr_3;		  	/* Logical block address (MSB)            */
	UBYTE	blk_addr_2;		  	/* Logical block address                  */
	UBYTE	blk_addr_1;		  	/* Logical block address                  */
	UBYTE	blk_addr_0;		  	/* Logical block address (LSB)            */
	UBYTE	res1;		    	/* reserved		                          */
	UBYTE	len_1;				/* Transfer length (MSB)				  */
	UBYTE	len_0;				/* Transfer length (LSB)				  */
	UBYTE	vu1       : 2;  	/* vendor unique				          */
	UBYTE   res4      : 4;  	/* reserved                               */
	UBYTE	flag      : 1;  	/* flag request (interrupt at completion) */
	UBYTE	link      : 1;  	/* link (another command follows)         */
} SCSI_CDB_1;

/**************** END SCSI Control Description Block     ******************/

typedef struct  scsi_sense {    /* scsi sense for error classes 0-6       */
	UBYTE	adr_val : 1;		/* sense data is valid                    */
	UBYTE	class   : 3;		/* error class (0-6)                      */
	UBYTE	code    : 4;		/* error code                             */
	UBYTE	high_addr;			/* high byte of block addr                */
	UBYTE	mid_addr;			/* middle byte of block addr              */
	UBYTE	low_addr;			/* low byte of block addr                 */
	UBYTE	extra[12];			/* pad this struct so it can hold max num */
                                /* of sense bytes we may receive          */
} SCSI_SENSE;

typedef struct  scsi_ext_sense {/* scsi extended sense for error class 7  */
	UBYTE	valid   : 1;		/* sense data is valid        (byte 0)    */
	UBYTE           : 7;		/* alway at binary 1110000    (byte 0)    */
	UBYTE	segment;			/* segment number             (byte 1)    */
	UBYTE	filmrk  : 1;    	/* file mark                  (byte 2)    */
	UBYTE	eom     : 1;    	/* end of media               (byte 2)    */
	UBYTE	ilength : 1;    	/* incorrect length indicator (byte 2)    */
	UBYTE           : 1;    	/* reserved                   (byte 2)    */
	UBYTE	key     : 4;    	/* sense key                  (byte 2)    */
	UBYTE	info0;	         	/* information                (byte 3)    */
	UBYTE	info1;	         	/* information                (byte 4)    */
	UBYTE	info2;	         	/* information                (byte 5)    */
	UBYTE	info3;	         	/* information                (byte 6)    */
	UBYTE 	add_len;       		/* number of additional bytes (byte 7)    */
	UBYTE	copy_cmp1;			/* Reserved for Copy/Compare Command      */
	UBYTE	copy_cmp2;			/* Reserved for Copy/Compare Command      */
	UBYTE	res0;				/* Reserved byte                          */
	UBYTE	res1;				/* Reserved byte                          */
	UBYTE	sense_code;			/* Additional Sense Code                  */
	UBYTE	res2;				/* Reserved byte                          */
	UBYTE	fru;				/* Field Replacement Unit                 */
	UBYTE	fpv    : 1;			/* Field pointer valid                    */
	UBYTE	c_d    : 1;			/* Command/Data                           */
	UBYTE	       : 2;			/* Reserved                               */
	UBYTE	bpv    : 1;			/* Bit pointer vaild                      */
	UBYTE	bitp   : 3;			/* Bit pointer                            */
	UBYTE	fp1;        		/* Field pointer 1                        */
	UBYTE	fp2;       			/* Field pointer 2                        */
	UBYTE	extra[10];			/* additional bytes follow, if any        */
} SCSI_EXT_SENSE;

typedef struct Inquiry {
	UBYTE	device_type;		/* Peripheral Device Type                 */
	UBYTE	rm			: 1;	/* Removeable Media                       */
	UBYTE	dtq			: 7;	/* Device Type Qualifier                  */
	UBYTE				: 2;	/* Reserved                               */
	UBYTE	ecma		: 2;	/* ECMA Version                           */
	UBYTE	ansi		: 2;	/* ANSI Version                           */
	UBYTE	res0;				/* Reserved                               */
	UBYTE	length;				/* Additional Length                      */
	UBYTE	res1;				/* Reserved                               */
	UBYTE	res2;				/* Reserved                               */
	UBYTE	res3;				/* Reserved                               */
	UBYTE	vendor_id[8];		/* Vendor ID                              */
	UBYTE	product_id[16];		/* Product ID                             */
	UBYTE	revision_level[4];	/* Product Revision Level                 */
} VJ_INQUIRY;
        
typedef struct mode_sense_hdr {
	UBYTE	sense_data_len;		/* sense data length */
	UBYTE	medium_type;		/* medium_type */
	UBYTE	WP: 1;
   	UBYTE   resv  : 6;
	UBYTE	EBC: 1;
	UBYTE	blk_desc_len;	/* block descriptor length */
} VJ_MS_HDR;

typedef struct mode_sense_blk_desc {
	UBYTE	density_code;
	UBYTE	nob_high;	/* no. of blocks */
	UBYTE	nob_mid;
	UBYTE	nob_low;
	UBYTE	resv;
	UBYTE	blk_len_high;	/* block length */
	UBYTE	blk_len_mid;
	UBYTE	blk_len_low;
} VJ_MS_BLK_DESC;

/* Read/write error recovery page */
typedef struct mode_sense_page_1 {
	UBYTE	ps			: 1;			/* page save */
    UBYTE   res0		: 1;
	UBYTE	page_code	: 6;
    UBYTE   page_length;				/* length = 0x0A */
	UBYTE	awre		: 1;			/* reallocate during write */
	UBYTE	arre		: 1;			/* reallocate during read */
	UBYTE	tb  		: 1;			/* transfer unrecoverable block */
	UBYTE	rc  		: 1;			/* recovery cause delay */
	UBYTE	eer			: 1;			/* error recovery */
	UBYTE	per 		: 1;			/* report recovered errors */
	UBYTE	dte 		: 1;			/* stop recovered error */
	UBYTE	dcr			: 1;			/* ECC correction allowed */
    UBYTE   r_retry_count;				/* read retry count */
    UBYTE   correction_span;			/* correction span */
    UBYTE   head_offset;				/* head offset count */
    UBYTE   strobe_offset;				/* data strobe offset count */
	UBYTE	res1;
    UBYTE   w_retry_count;				/* write retry count */
	UBYTE	res2;
    UBYTE   recovery_time_msb;			/* recovery time limit */
    UBYTE   recovery_time_lsb;
} VJ_MS_PAGE1;

/* Disconnect reconnect page */
typedef struct mode_sense_page_2 {
    UBYTE   res0		: 2;
	UBYTE	page_code	: 6;
    UBYTE   page_length;				/* length = 0x0E */
    UBYTE   buffer_full_ratio;			/* buffer full ratio */
    UBYTE   buffer_empty_ratio;			/* buffer empty ratio */
	UBYTE	bus_inact_limit_msb;		/* bus inactivity limit */
	UBYTE	bus_inact_limit_lsb;
	UBYTE	dis_time_limit_msb;			/* disconnect time limit */
	UBYTE	dis_time_limit_lsb;
	UBYTE	con_time_limit_msb;			/* connect time limit */
	UBYTE	con_time_limit_lsb;
	UBYTE	max_burst_size_msb;			/* maximum burst size */
	UBYTE	max_burst_size_lsb;
	UBYTE	res1		: 6;
	UBYTE	dtdc		: 2;			/* data transfer disconnect control */
    UBYTE   res2[3];
} VJ_MS_PAGE2;

/* Format device page */
typedef struct mode_sense_page_3 {
	UBYTE	ps			: 1;			/* page save */
    UBYTE   res0		: 1;
	UBYTE	page_code	: 6;
    UBYTE   page_length;				/* length = 0x16 */
    UBYTE   trk_per_zone_hi;			/* track per zone */
    UBYTE   trk_per_zone_lo;
	UBYTE	alt_sctr_per_zone_hi; 		/* alternate sectors per zone */
	UBYTE	alt_sctr_per_zone_lo;
	UBYTE	alt_trk_per_zone_hi;		/* alternate tracks per zone */
	UBYTE	alt_trk_per_zone_lo;
	UBYTE	alt_trk_per_vol_hi;			/* alternate tracks per volume */
	UBYTE	alt_trk_per_vol_lo;
	UBYTE	sctr_per_trk_hi;			/* sectors per track */
	UBYTE	sctr_per_trk_lo;
	UBYTE	byte_per_phy_sctr_hi;		/* bytes per physical sector */
	UBYTE	byte_per_phy_sctr_lo;
	UBYTE	interleave_value_hi;		/* interleave_value */
	UBYTE	interleave_value_lo;
	UBYTE	track_skew_factor_hi;		/* track skew factor */
	UBYTE	track_skew_factor_lo;
	UBYTE	cyl_skew_factor_hi;			/* cylinder skew factor */
	UBYTE	cyl_skew_factor_lo;
	UBYTE	ssec		: 1;
	UBYTE	hsec		: 1;
	UBYTE	rmb			: 1;			/* media 0 - fixed, 1 - removable */
	UBYTE	surf		: 1;			/* format 0 - cyl, 1 - surface */
	UBYTE	res1		: 4;
	UBYTE	res2[3];
} VJ_MS_PAGE3;

/* Rigid disk drive geometry page */
typedef struct mode_sense_page_4 {
	UBYTE	ps			: 1;		/* page save */
    UBYTE   res0		: 1;
	UBYTE	page_code	: 6;
    UBYTE   page_length;			/* length = 0x16 */
    UBYTE   max_no_cyl_hi;			/* max no of cylinders */
    UBYTE   max_no_cyl_mid;
    UBYTE   max_no_cyl_lo;
	UBYTE	max_no_heads; 			/* max no of heads */
	UBYTE	start_cyl_wr_pre_hi;	/* starting cyl-wr precompensation */
	UBYTE	start_cyl_wr_pre_mid;
	UBYTE	start_cyl_wr_pre_lo;
	UBYTE	start_cyl_wr_cur_hi;	/* starting cyl-reduced wr current */
	UBYTE	start_cyl_wr_cur_mid;
	UBYTE	start_cyl_wr_cur_lo;
	UBYTE	drive_step_rate_hi;		/* drive step rate */
	UBYTE	drive_step_rate_lo;
	UBYTE	land_zone_cyl_hi;		/* landing zone cylinder */
	UBYTE	land_zone_cyl_mid;
	UBYTE	land_zone_cyl_lo;
	UBYTE	res1		: 6;
	UBYTE	rpl			: 2;		/* control synchronize spindles */
	UBYTE	rot_offset;				/* rotational offset */
	UBYTE	res2;
	UWORD	med_rot_rate;			/* medium rotation rate */
    UBYTE   res3[2];
} VJ_MS_PAGE4;

/* Verify error recovery page */
typedef struct mode_sense_page_7 {
	UBYTE	ps			: 1;		/* page save */
    UBYTE   res0		: 1;
	UBYTE	page_code	: 6;
    UBYTE   page_length;			/* length = 0x0A */
    UBYTE   res1		: 4;
	UBYTE	eer			: 1;		/* error recovery */
	UBYTE	per 		: 1;		/* report recovered errors */
	UBYTE	dte 		: 1;		/* stop recovered error */
	UBYTE	dcr			: 1;		/* ECC correction allowed */
	UBYTE	verify_retry_cnt;		/* verify retry count */
	UBYTE	verify_correc_span;		/* verify correction span */
	UBYTE	res2[5];
	UBYTE	ver_rec_time_limit_hi;	/* verify recovery time limit */
	UBYTE	ver_rec_time_limit_lo;
} VJ_MS_PAGE7;

/* Caching page */
typedef struct mode_sense_page_8 {
	UBYTE	ps			: 1;		/* page save */
    UBYTE   res0		: 1;
	UBYTE	page_code	: 6;
    UBYTE   page_length;			/* length = 0x0A */
    UBYTE   res1		: 5;
	UBYTE	wce			: 1;		/* write cache enable */
	UBYTE	mf			: 1;		/* multiplication factor */
	UBYTE	rcd			: 1;		/* read cache disable */
	UBYTE	drrp		: 4;		/* demand read retention priority */
	UBYTE	wrp			: 4;		/* write retention priority */
	UBYTE	dis_pf_xfer_len[2];		/* disable pre-fetch xfer len */
	UBYTE	min_prefetch[2];		/* min pre-fetch */
	UBYTE	max_prefetch[2];		/* max pre-fetch */
	UBYTE	max_pf_ceiling[2];		/* max pre-fetch ceiling */
} VJ_MS_PAGE8;

/* Control mode page */
typedef struct mode_sense_page_ah {
    UBYTE   res0		: 2;
	UBYTE	page_code	: 6;
    UBYTE   page_length;			/* length = 0x06 */
	UBYTE	res1		: 7;
	UBYTE	rlec		: 1;		/* log exception reporting */
	UBYTE	qam			: 4;		/* queue algorithm modifier */
	UBYTE	res2		: 2;
	UBYTE	qerr		: 1;		/* continue/abort after error */
	UBYTE	dque		: 1;		/* tagged queueing */
	UBYTE	eeca		: 1;		/* extended contingent allegiance */
	UBYTE	res3		: 4;
	UBYTE	raenp		: 1;		/* AEN after initialization */
	UBYTE	uaaenp		: 1;		/* AEN for unit attention condition */
	UBYTE	eaenp		: 1;		/* AEN to report deferred errors */
	UBYTE	res4;
	UBYTE	ready_aen_h_per_hi;		/* ready AEN holdoff period */
	UBYTE	ready_aen_h_per_lo;
} VJ_MS_PAGEAH;

/* Notch page */
typedef struct mode_sense_page_ch {
	UBYTE	ps			: 1;	/* page save */
    UBYTE   res0		: 1;
	UBYTE	page_code	: 6;
    UBYTE   page_length;		/* lenght = 0x16 */
	UBYTE	nd			: 1;	/* notch */
	UBYTE	pln			: 1;	/* notch boundaries */
	UBYTE	res1		: 6;
	UWORD	max_num_notch;		/* maximum number of notches */
	UWORD	active_notch;		/* active notch */
	UWORD	start_bound_hi;		/* starting boundary */
	UWORD	start_bound_lo;
	UWORD	end_bound_hi;		/* ending boundary */
	UWORD	end_bound_lo;
	UWORD	pages_notched_hi;	/* pages notched */
	UWORD	pages_notched_midhi;
	UWORD	pages_notched_midlow;
	UWORD	pages_notched_low;
} VJ_MS_PAGECH;

/* Device configuration page */
typedef struct mode_sense_page_10h {
	UBYTE	ps			: 1;	/* page save */
    UBYTE   res0		: 1;
	UBYTE	page_code	: 6;
    UBYTE   page_length;		/* lenght = 0x0E */
    UBYTE   res1		: 1;
    UBYTE   cap			: 1;	/* change active partition */
    UBYTE   caf			: 1;	/* change active field */
	UBYTE	active_form	: 5;	/* active format */
	UBYTE	active_part;		/* active partition */
	UBYTE	wbfr;				/* write buffer full ratio */
	UBYTE	rber;				/* read buffer empty ratio */
	UWORD	wdt;				/* write delay time */
	UBYTE	dbr			: 1;	/* data buffer recovery */
	UBYTE	ris			: 1;	/* record identifiers supported */
	UBYTE	rsmk		: 1;	/* report set mark */
	UBYTE	avc			: 1;	/* automatic velocity control */
	UBYTE	socf		: 2;	/* stop on consecutive filemarks */
	UBYTE	rbo			: 1;	/* recover buffer order */
	UBYTE	rew			: 1;	/* report early warning EOM */
	UBYTE	gapsize;			/* gap size */
	UBYTE	eod			: 3;	/* eod defined */
	UBYTE	eeg			: 1;	/* enable EOD generation */
	UBYTE	sew			: 1;	/* sync at early warning */
	UBYTE	res2		: 3;
	UBYTE	bsew_hi;			/* buffer size at early warning */
	UBYTE	bsew_mid;
	UBYTE	bsew_lo;
	UBYTE	sdca;				/* select data compression algorithm */
	UBYTE	res3;
} VJ_MS_PAGE10H;

/* Medium partition page(1) */
typedef struct mode_sense_page_11h {
	UBYTE	ps			: 1;	/* page save */
    UBYTE   res0		: 1;
	UBYTE	page_code	: 6;
    UBYTE   page_length;		/* length = n - 1 */
    UBYTE   max_part;			/* maximum additional partitions */
	UBYTE	add_part;			/* additional partitions defined */
	UBYTE	fdp			: 1;	/* fixed data partitions */
	UBYTE	sdp			: 1;	/* select data partitions */
	UBYTE	idp			: 1;	/* initiator defined partitions */
	UBYTE	psum		: 2;	/* partition size unit of measure */
	UBYTE	res1		: 3;
	UBYTE	mfr;				/* medium format recognition */
	UBYTE	res2[2];
	UWORD	part_size;			/* partition size */
} VJ_MS_PAGE11H;

typedef struct mode_sense_page_32h {	/* Maxtor drive control page */
    UBYTE   res0		: 2;
	UBYTE	page_code	: 6;
    UBYTE   page_length;		/* 0x06 */
    UBYTE   res1		: 3;
    UBYTE   esdtr		: 1;	/* enable sync data transfer */
    UBYTE   fdpe		: 1;	/* format data pattern enable */
    UBYTE   cr			: 1;	/* contingent reservation */
    UBYTE   dua			: 1;	/* disable unit attention */
    UBYTE   start		: 1;	/* drive start-up bit */
    UBYTE   res2		: 2;
    UBYTE   ssid		: 1;	/* software selectable id */
    UBYTE   res3		: 2;
    UBYTE   scsiadr		: 2;	/* scsi addr */
    UBYTE   res4[4];
} VJ_MS_PAGE32H;

typedef struct mode_sense_page_20h {	/* SONY Magnito Optical format parameters */
    UBYTE   res0		: 2;
	UBYTE	page_code	: 6;
    UBYTE   page_length;
	UBYTE	fmt_mode;			/* format mode (we use 3) */
	UBYTE	type;				/* type (we use 1) */
	UWORD	res1;
	UWORD	num_of_bands;		/* number of bands (we use 1) */
	UWORD	size_spare_band;	/* size of spare band (we use 2048) */
	UWORD	res2;
} VJ_MS_PAGE20H;

typedef struct mode_sense_page_38h {	/* cache control parameters */
    UBYTE   res0		: 2;
	UBYTE	page_code	: 6;
    UBYTE   page_length;
    UBYTE   res1		: 1;
    UBYTE   wie			: 1;	/* write index enable */
    UBYTE   res2		: 1;	/* or ramd: read-ahead with mech delay */
    UBYTE   ce			: 1;	/* cache enable */
    UBYTE   ctbsz		: 3;	/* cache table size */
	UBYTE	pref_td;			/* prefetch threshold */
	UBYTE	max_pref;			/* max prefetch */
	UBYTE	max_pref_mul;		/* max prefetch multiplier */
	UBYTE	min_pref;			/* min prefetch */
	UBYTE	min_pref_mul;		/* min prefetch multiplier */
	UBYTE	res3[8];
} VJ_MS_PAGE38H;

typedef struct mode_sense {
    VJ_MS_HDR       hdr;
    VJ_MS_BLK_DESC  blk_desc;
	UBYTE			pg[64];		/* space for page code */
} VJ_MODE_SENSE;

typedef struct Capacity {			/* data format for read capacity cmd */
    UBYTE			blk_addr_3;		/* logical block address (MSB)	*/
    UBYTE			blk_addr_2;		/* logical block address		*/
    UBYTE			blk_addr_1;		/* logical block address		*/
    UBYTE			blk_addr_0;		/* logical block address (LSB)	*/
	UBYTE			blk_len_3;		/* block length (MSB)			*/
	UBYTE			blk_len_2;		/* block length					*/
	UBYTE			blk_len_1;		/* block length					*/
	UBYTE			blk_len_0;		/* block length (LSB)			*/
} VJ_CAPACITY;

typedef struct rsgnblk_dlist {		/* defect list for reassign blk cmd */
	UBYTE			rd_resv0[2];
	UBYTE			rd_len_msb;		/* defect list length in bytes		*/
	UBYTE			rd_len_lsb;
	UBYTE			rd_blk_addr_3;	/* defect log block addr(MSB)		*/
	UBYTE			rd_blk_addr_2;
	UBYTE			rd_blk_addr_1;
	UBYTE			rd_blk_addr_0;	/* defect log block addr(LSB)		*/
} VJ_RSGNBLK;

/* maximum number of defects that can be read */
#define MAX_DEF_ENTRY	255

/* defect list structure */
typedef struct defect_list {
    UBYTE   cyl_hi;			/* cylinder of defect */
    UBYTE   cyl_mid;
    UBYTE   cyl_lo;
	UBYTE	head;			/* head of defect */
	UBYTE	defsec_1;		/* sector of defect */
	UBYTE	defsec_2;
	UBYTE	defsec_3;
	UBYTE	defsec_4;
} VJ_DEFECT;

/* defect data received from 0x37 (read defect) command */
typedef struct defect_head {
	UBYTE	res0;
	UBYTE	res1	: 3;
	UBYTE	Plist	: 1;	/* P-list bit */
	UBYTE	Glist	: 1;	/* G-list bit */
	UBYTE	dlform	: 3;	/* defect format = 101b */
	UWORD	length;			/* total length defects in bytes */
	VJ_DEFECT		def_list[MAX_DEF_ENTRY];	/* scsi defects list */
} VJ_DEFLIST;

/* 
 * Sense key values for extended sense.
 */
#define SCSI_NO_SENSE             0x0
#define SCSI_RECOVERABLE_ERROR    0x1
#define SCSI_NOT_READY            0x2
#define SCSI_MEDIUM_ERROR         0x3
#define SCSI_HARDWARE_ERROR       0x4
#define SCSI_ILLEGAL_REQUEST      0x5
#define SCSI_UNIT_ATTENTION       0x6
#define SCSI_DATA_PROTECT         0x7
#define SCSI_BLANK_CHECK          0x8
#define SCSI_VENDOR_UNIQUE        0x9
#define SCSI_COPY_ABORTED         0xa
#define SCSI_ABORT_COMMAND        0xb
#define SCSI_EQUAL                0xc
#define SCSI_VOLUME_OVERFLOW      0xd
#define SCSI_MISCOMPARE           0xe
#define SCSI_RESERVED             0xf

/*
 * SCSI Operation codes. 
 */
#define SCSI_FORMAT_UNIT		  0x04
#define SCSI_INQUIRY			  0x12
#define SCSI_MODE_SELECT		  0x15
#define SCSI_MODE_SENSE	          0x1A
#define SCSI_READ				  0x08
#define SCSI_REASSIGN_BLOCK		  0x07
#define SCSI_RECEIVE_DIAG_RESULTS 0x1C
#define SCSI_RELEASE_UNIT		  0x17
#define SCSI_REQUEST_SENSE		  0x03
#define SCSI_RESERVE_UNIT		  0x16
#define SCSI_REZERO_UNIT		  0x01
#define SCSI_SEEK				  0x0B
#define SCSI_SEND_DIAG			  0x1D
#define SCSI_START_STOP_UNIT	  0x1B
#define SCSI_TEST_UNIT_READY	  0x00
#define SCSI_WRITE				  0x0A
#define SCSI_COMPARE			  0x39
#define SCSI_COPY_VERIFY		  0x3A
#define SCSI_READ_BUFFER		  0x3C
#define SCSI_READ_CAPACITY		  0x25
#define SCSI_READ_DEFECT_DATA	  0x37
#define SCSI_READ_EXTENDED		  0x28
#define SCSI_SEEK_EXTENDED		  0x2B
#define SCSI_VERIFY				  0x2F
#define SCSI_WRITE_BUFFER		  0x3B
#define SCSI_WRITE_EXTENDED		  0x2A
#define SCSI_WRITE_VERIFY		  0x2E
#define SCSI_FORMAT_TRACK		  0xE4
#define SCSI_READ_LONG			  0xE8
#define SCSI_WRITE_LONG			  0xEA
#define SCSI_REWIND				  0x01
#define SCSI_ERASE				  0x19
#define SCSI_WRITE_FILE_MARKS	  0x10
#define SCSI_SPACE				  0x11
#define SCSI_LOAD				  0x1B
#define SCSI_LOCK				  0x1E
#define	SCSI_LOG_SENSE			  0x4D
#define SCSI_LIST				  0x37

/*
 * Messages that SCSI can send.
 */
#define SCSI_COMMAND_COMPLETE     0x00
#define SCSI_SAVE_DATA_PTR        0x02
#define SCSI_RESTORE_PTRS         0x03
#define SCSI_DISCONNECT           0x04
#define SCSI_IDENTIFY             0x80
#define SCSI_DR_IDENTIFY          0xc0

#define MORE_STATUS 0x80        /* More status flag */
#define STATUS_LEN  3           /* Max status len for SCSI */

#define CDB_ADDR(cdb, addr)     \
	{ \
		(cdb)->high_addr = ((addr) >> 16) & 0xFF;\
		(cdb)->mid_addr = ((addr) >> 8) & 0xFF;\
		(cdb)->low_addr = (addr) & 0xFF; \
	}
#define CDB_ADDR_1(cdb, addr)     \
	{ \
		(cdb)->blk_addr_3 = ((addr) >> 24) & 0xFF;\
		(cdb)->blk_addr_2 = ((addr) >> 16) & 0xFF;\
		(cdb)->blk_addr_1 = ((addr) >> 8) & 0xFF;\
		(cdb)->blk_addr_0 = (addr) & 0xFF; \
	}

#define ADDR_CDB(cdb)     \
	( ((cdb)->high_addr << 16 ) + ((cdb)->mid_addr << 8) + (cdb)->low_addr)
/* for group code 1 commands */
#define ADDR_CDB_1(cdb)     \
	( ((cdb)->blk_addr_3 << 24) + ((cdb)->blk_addr_2 << 16) + ((cdb)->blk_addr_1 << 8) + (cdb)->blk_addr_0)

#define CDB_XFER_LEN(cdb, length)     \
	{ \
		(cdb)->mid_addr = ((length) >> 16) & 0xFF;\
		(cdb)->low_addr = ((length) >> 8) & 0xFF;\
		(cdb)->count = (length) & 0xFF; \
	}
#define CDB_XFER_LEN_1(cdb, length)     \
	{ \
		(cdb)->len_1 = ((length) >> 8) & 0xFF;\
		(cdb)->len_0 = (length) & 0xFF; \
	}
