static char vjutilCSid[]="@(#)vjutil.c	30.1 3/13/91 SH00024-A00 AppEng/SCCS Interphase";

/* in vi :set ts=4
 	On SunOS3.x:	cc -O -o vjutil vjutil.c -ltermlib
 	On SunOS4.x:	cc -DOS4 -O -o vjutil vjutil.c -ltermlib

REVISION HISTORY:
DATE     ID       VER   COMMENT
03/13/91 rbrant   30.1  A00:New development/distribution format.
03/13/91 ron      22.5  added reassign block
         jdb            added scanning
         jdb            added display P-list and G-list defects
12/27/90 jdb      22.4  added support for Sony Magneto Optical drive
                        changed disk label display and entry from number
                        of MB's to number of cylinders
*/

#include 	<stdio.h>
#include	<sys/ioctl.h>
#include	<sys/file.h>
#include	<errno.h>
#include	<sys/types.h>
#include	<sys/stat.h>
#include	<sun/dkio.h>
#include	<sys/buf.h>
#include	<sys/signal.h>
#include	</sys/sundev/IPtypes.h>
#include	</sys/sundev/vj_struct.h>
#include	</sys/sundev/vj_scsi.h>
#include	</sys/sundev/vj_reg.h>
#include	"vjutil.h"

extern int errno;
char *sys_errlist[];

struct dk_label		Dklabel;
int nos_cyl;	/* no of sectors per cyl */
/* disk partition starting cylinder */
unsigned dkl_Cyl[8] = {0, 0, 0, 0, 0, 0, 0, 0};
/* no of cylinders disk partitions possess */
unsigned dkl_noCyl[8] = {0, 0, 0, 0, 0, 0, 0, 0}; /* partition a..h */

int junk;
VJ_MODE_SENSE	scsi_mode_sense_03;
VJ_MODE_SENSE	scsi_mode_sense_04;
VJ_CAPACITY		scsi_capacity;

int	Ifd;
struct stat filestat;
char	*Pname, *Fname;
char *Aborted = "Aborted";

VJ_CSB Csb;
char Pvar[4], Kram[4];
VJ_INQUIRY scsi_inq;
char vendor_id[9], product_id[17], revision_level[5];
VJ_DRIVER sun_driver;
static VJ_RSGNBLK scsi_rsgnblk;
static VJ_MODE_SENSE scsi_select;
static VJ_DEFLIST scsi_list;

/* number of sectors per scan */
/* this value must be greater than 1 */
#define SCAN_SEC  112   /* will do 112 * 512 = 57344 bytes per scan iteration */
/* scan variables for user entering ^C */
int abort_status = 0;
int abort_flag = 0;
/* scan write buffer */
char scanwbuf[SCAN_SEC * 512];
/* scan read buffer */
char scanrbuf[SCAN_SEC * 512];
/* scan save buffer */
char scansavebuf[SCAN_SEC * 512];
/* scan test patterns */
long testpatterns[] = {
        0x71C71C71, 0xB6DB6DB6, 0x83E83E83,
        0x1C71C71C, 0x6DB6DB6D, 0x3E83E83E,
        0xC71C71C7, 0xDB6DB6DB, 0xE83E83E8,
        0x33333333, 0x66666666, 0xCCCCCCCC,
        0x55555555, 0xAAAAAAAA,
        0x0FF00FF0, 0xF00FF00F,
        0xA5A5A5A5, 0x5A5A5A5A,
        0xEC6DEC6D, 0x6DEC6DEC,
		0x00000000
};

PDATA Idata[] = {
	{ 8, 01, "Firmware Revision: ", (char *)Csb.csb_PCODE, 3,
	 AT_NORMAL, GA_FILL|GA_PROT},
	{ 8, 23, "-", (char *)Pvar, 1,
	 AT_NORMAL, GA_FILL|GA_PROT},
	{ 8, 25, "-", (char *)&Csb.csb_FREV[0], 3,
	 AT_NORMAL, GA_FILL|GA_PROT},
	{ 9, 01, "         Date: ", (char *)Csb.csb_FDATE, 8,
	 AT_NORMAL, GA_FILL|GA_PROT},
	{ 10, 01, "         Buffer Size in Kbytes: ", Kram, 4,
	 AT_NORMAL, GA_FILL|GA_PROT},

	{ 13, 01, "Disk Vendor: ", (char *)vendor_id, 8,
	 AT_NORMAL, GA_FILL|GA_PROT},
	{ 14, 01, "     Product ID: ", (char *)product_id, 16,
	 AT_NORMAL, GA_FILL|GA_PROT},
	{ 15, 01, "     Revision: ", (char *)revision_level, 4,
	 AT_NORMAL, GA_FILL|GA_PROT},

	{ 18, 01, "Driver Revision: ", (char *)sun_driver.dr_revision, 20,
	 AT_NORMAL, GA_FILL|GA_PROT},
	{ 0, 0, 0, 0, 0, 0, 0}
};

PDATA Olpdata[] = {
	{ 4, 1, "Ascii Label: ", &Dklabel.dkl_asciilabel[0], 63,
	 AT_NORMAL, GA_FILL},
	{ 6, 1, "Interleave Factor: ", (char*)&Dklabel.dkl_intrlv, 2,
	 AT_NORMAL, GA_SINT|GA_FILL|GA_PROT},
	{ 8, 1, "No of Heads: ", (char*)&Dklabel.dkl_nhead, 2,
	 AT_NORMAL, GA_SINT|GA_FILL|GA_PROT},
	{ 10, 1, "No of Data Cylinders: ", (char*)&Dklabel.dkl_ncyl, 4,
	 AT_NORMAL, GA_SINT|GA_FILL|GA_PROT},
	{ 12, 1, "No of Sectors Per Track: ", (char*)&Dklabel.dkl_nsect, 2,
	 AT_NORMAL, GA_SINT|GA_FILL|GA_PROT},
	{ 14, 1, "No of Sectors Per Cylinder: ", (char*)&nos_cyl, 4,
	 AT_NORMAL, GA_INT|GA_FILL|GA_PROT},

	{ 6, 38, "Part. A  start Cyl:    ", (char*)&dkl_Cyl[0], 6,
	 AT_NORMAL, GA_INT|GA_FILL},
	{  7, 38, "         no of Cyls: ", (char*)&dkl_noCyl[0], 8,
	 AT_NORMAL, GA_INT|GA_FILL},
	{ 8, 38, "Part. B  start Cyl:    ", (char*)&dkl_Cyl[1], 6,
	 AT_NORMAL, GA_INT|GA_FILL},
	{  9, 38, "         no of Cyls: ", (char*)&dkl_noCyl[1], 8,
	 AT_NORMAL, GA_INT|GA_FILL},
	{ 10, 38, "Part. C  start Cyl:    ",(char*)&dkl_Cyl[2], 6,
	 AT_NORMAL, GA_INT|GA_FILL},
	{ 11, 38, "         no of Cyls: ", (char*)&dkl_noCyl[2], 8,
	 AT_NORMAL, GA_INT|GA_FILL},
	{ 12, 38, "Part. D  start Cyl:    ",(char*)&dkl_Cyl[3], 6,
	 AT_NORMAL, GA_INT|GA_FILL},
	{  13, 38, "         no of Cyls: ", (char*)&dkl_noCyl[3], 8,
	 AT_NORMAL, GA_INT|GA_FILL},
	{ 14, 38, "Part. E  start Cyl:    ",(char*)&dkl_Cyl[4], 6,
	 AT_NORMAL, GA_INT|GA_FILL},
	{  15, 38, "         no of Cyls: ", (char*)&dkl_noCyl[4], 8,
	 AT_NORMAL, GA_INT|GA_FILL},
	{ 16, 38, "Part. F  start Cyl:    ",(char*)&dkl_Cyl[5], 6,
	 AT_NORMAL, GA_INT|GA_FILL},
	{  17, 38, "         no of Cyls: ", (char*)&dkl_noCyl[5], 8,
	 AT_NORMAL, GA_INT|GA_FILL},
	{ 18, 38, "Part. G  start Cyl:    ",(char*)&dkl_Cyl[6], 6,
	 AT_NORMAL, GA_INT|GA_FILL},
	{  19, 38, "         no of Cyls: ", (char*)&dkl_noCyl[6], 8,
	 AT_NORMAL, GA_INT|GA_FILL},
	{ 20, 38, "Part. H  start Cyl:    ",(char*)&dkl_Cyl[7], 6,
	 AT_NORMAL, GA_INT|GA_FILL},
	{  21, 38, "         no of Cyls: ", (char*)&dkl_noCyl[7], 8,
	 AT_NORMAL, GA_INT|GA_FILL},
	{ 0, 0, 0, 0, 0, 0, 0}
};

int toggle(), emlabel(), format(), dlist(), scan(), info(), rsgnblk();
MDATA Mdata[] = {
	{ "\033", "MAIN SELECTIONS", "DESCRIPTION",
	 "vjutil.hlp", 0, 0},
/*	{ "T", "Toggle Messages", "Enable/Dissable Messages",
	 "itoggle.hlp", toggle,  0}, */
	{ "E", "Examine/Modify Label", "Create/Modify Sun's Disk Label",
	 "ilabel.hlp", emlabel,  0},
	{ "F", "Format Disk", "Format the Entire Disk",
	 "iformat.hlp", format,  0},
	{ "U", "Unit Information", "Controller/Driver/Disk Info",
	 "sel.hlp", info,  0},
	{ "R", "Reassign Block", "Reassign a Defective Disk Block",
	 "sel.hlp", rsgnblk,  0},
	{ "S", "Surface Analysis", "Scan Disk for Defects",
	 "surf.hlp", scan,  0}, 
	{ "D", "Show Defect List", "Show Disk G and P List",
	 "surf.hlp", dlist,  0}, 
	{ 0, 0, 0, 0, 0, 0}
};

/*
 *	This version is for UNIX systems and only supports attributes:
 *			AT_NORMAL
 *			AT_INVERSE
 *
 *	This routine will handle the window system calls the best
 *	it can.
 */

char *tgoto();
char *tgetstr();
char *getenv();
int outc();

#define	OUTC_SIZ	512	/* size of private output buff	*/

char	ocbuf[OUTC_SIZ];	/* private output buffer		*/
int	outcnt = 0;		/* counts chars in ocbuf		*/

WBLOCK	Popattr;		/* Pop up attribute			*/
WBLOCK	Ipopattr;		/* Inverse Popup attribute		*/

char	Ulchr = '*';		/* Upper left corner of border		*/
char	Urchr = '*';		/* Upper right corner of border		*/
char	Blchr = '*';		/* Lower right corner of border		*/
char	Brchr = '*';		/* Lower left corner of border		*/
char	Vchr  = '|';		/* Vertical character of border		*/
char	Hchr  = '-';		/* Horiz. character of border		*/

WBLOCK	*Mblock; 		/* Window buffer			*/

char	*Clstr = {0};		/* Used to clear screen and home cursor	*/
char	*Sestr = {0};		/* Used to turn off outstanding mode	*/
char	*Sostr = {0};		/* Used to turn on outstanding mode	*/
char	*Cmstr = {0};		/* Cursor motion string			*/
char	Libarea[512] = {0};	/* Will hold the termlib strings	*/
char	Tcbuf[1024] = {0};	/* Will hold the termcap entry		*/

int	Winrows = 24;		/* Assume Normal screen for now		*/
int	Wincols = 80;

char	*Rtermname = {0};	/* Name of UNIX terminal type		*/

checkabort()
{
	if (abort_status)
		abort_flag = 1;
}

wrblock(buf, loc_row, loc_col, siz_rows, siz_cols) /* returns -1 if err */
register WBLOCK *buf;
register int loc_row;
int loc_col, siz_rows, siz_cols;
{
register WATTRIB lastattr;
register WATTRIB curattr;
register int col, lines;
register char *cmov;

	lines = siz_rows;

#ifdef NOT_DEF
	cmov = tgoto(Cmstr, loc_col, loc_row);
	tputs(cmov, 1, outc);
#endif


	lastattr = (WATTRIB)(0xff); /* Must cause a mismatch	*/

	for( ; lines; lines--, loc_row++)
	{
#ifdef SGI_WBUG
	if(loc_col > 1)
	{
		at_mode(AT_NORMAL);
		cmov = tgoto(Cmstr, loc_col, loc_row);
		tputs(cmov, 1, outc);
		outc(' ');
		outc(CTL('H'));
		lastattr = (WATTRIB)(0xff);
	}
#endif

		cmov = tgoto(Cmstr, loc_col, loc_row);
		tputs(cmov, 1, outc);
		for(col = siz_cols; col > 0 ; )
		{
			curattr = buf->wattrib;	 /* look at attrib */
			if(curattr != lastattr)
			{
				at_mode(curattr);
				lastattr = curattr;
			}
			while(curattr == buf->wattrib && col--)
			{
				outc(buf->wdata);
				buf++;		/* on to next pair */
			}
		}
	}
	at_mode(AT_NORMAL);	/* some terminals are just so stupid	*/
	return(0);		/* always works for now			*/
}

/*
 *              winwrite
 *      This routine will allow the writing of strings at any position
 *      on the screen and allow them to be any attribute.
 *
 *      NOTE: if column is < 0 this means center the string on the line
 *
 */
 
winwrite(str, loc_row, loc_col, attr)
register char *str;
int loc_row, loc_col;
WATTRIB attr;
{
WBLOCK	 wbuf[200];
register int x;
register int len;
register WBLOCK *wptr;
 
	len = strlen(str);              /* must know length */
	if(loc_col < 0)             /* Does he want centering? */
		loc_col = (Wincols - len) / 2;
	for(x = len, wptr = &wbuf[0];x; x--)
	{
		wptr->wattrib = attr;
		wptr->wdata = *str++;
		wptr++;
	}
	wrblock(&wbuf[0], loc_row, loc_col, 1, len);
}
spotcur(row, col)
int row, col;
{
char *cmov;
	cmov = tgoto(Cmstr, col, row);
	tputs(cmov, 1, outc);
	fl_buf();
}

/*
 *      at_mode: routine to set video attributes
 */
 
at_mode(mode)
register int mode;
{
 
	if(mode == AT_INVERSE)
		tputs(Sostr, 1, outc); 	/* force inverse */
	else
		tputs(Sestr, 1, outc); 	/* force normal */
	fl_buf();			/* make sure it gets out        */
}
/*
 * curs_off     routine to turn the cursor off
 *              cursor will remain off until a curs_on
 *              call is made.
 */
 
curs_off()
{
	spotcur(Winrows-1, Wincols-1);		/* best we can do	*/
}
/*
 * curs_on      routine to turn the cursor on
 *              cursor will remain on until a curs_off
 *              call is made.
 */
 
curs_on()
{
}

/*
 *	This routine is used to initialize the window information
 *	It will look for the existence of window support in the Kernel
 *	first. If the system does not support windows, it will use
 *	the termcap libraries. (Termcap routines will always be used on
 *	async terminals regardless)
 *
 *	This routine will reserve a window buffer of Blksize.
 *
 *	NOTE:	The value of Blksize MUST initialized before this routine is
 *		called. It consists of the number of rows & cols.
 *
 *	RETURNS:	0	if all goes well
 *			-1	if an error occurs
 *
 *		If all goes well three pointers will be generated that
 *		will point to the window buffers, Block, Pblock, & Savblock
 *
 */

setwin()
{
char	*ap = Libarea;		/* Where Termcap strings will be put	*/
int terr = 0;				/* set if termcap error					*/
int num;

/* set up default attributes					*/
/* For dumb tubes these can be anything as long as they	differ	*/

	Popattr.wattrib = AT_INVERSE;		/* use inverse spaces	*/
	Popattr.wdata = ' ';			/* use inverse spaces	*/
	Ipopattr.wattrib = AT_NORMAL; 	/* normal spaces for inverse popup */
	Ipopattr.wdata = ' '; 		/* normal spaces for inverse popup */

	if ( !(Rtermname = getenv("TERM")) )
	{
		terr++;
		printf("$TERM variable not found\n");
	}
	else if ( tgetent(Tcbuf, Rtermname) != 1 )
	{
		terr++;
	}
	else if ( !(Cmstr = tgetstr("cm", &ap)) )
	{
		terr++;
		printf("Terminal requires cursor addressablity\n");
	}
	else if ( !(Clstr = tgetstr("cl", &ap)) )
		Clstr = "";	/* Poor sole can't clear his screen */
	else if ( !(Sostr = tgetstr("so", &ap))
		|| !(Sestr = tgetstr("se", &ap)) )
	{
			Sostr = "";	/* We will just ignore	*/
			Sestr = "";	/* these sequences	*/
	}

	if(terr)
		return(-1);
	if ( (num = tgetnum("li", &ap)) > 0 )
		Winrows = num;
	if ( (num = tgetnum("co", &ap)) > 0 )
		Wincols = num;

   Mblock = (WBLOCK *)( malloc(sizeof(WBLOCK) * Winrows * Wincols) );

	if ( !Mblock )
	{
		printf("\nNot enough memory for screen buffers\n");

/* The current implemention requires that these buffers exist!	*/

		return(-1);
		
	}

	return(0);	/* all went well	*/

}

/*
 *	outc	Private Buffered write routine
 *
 *	This routine will buffer up characters until the buffer fills
 *	and write the characters to stdout.
 *
 */

outc(c)
char c;
{
	if(outcnt >= (OUTC_SIZ - 1))	/* see if we need to flush	*/
		fl_buf();
	ocbuf[outcnt++] = c;
}
fl_buf()
{
	if(outcnt)
		write(1, ocbuf, outcnt);

	outcnt = 0;
}

/*
 *	cls		Clear the screen routine
 */

cls()
{
		tputs(Sestr, 1, outc);		/* Normal text	*/
		tputs(Clstr, 24, outc);		/* Clear, Home	*/
		fl_buf();
}

/*----------------------------------------------------------------------*
 *                                                                      *
 *	Routines to deal with the serial port			*
 *									*
 *----------------------------------------------------------------------*/

#define	io_set(a, b)	ioctl(a, TIOCSETN, b)
#define	io_get(a, b)	ioctl(a, TIOCGETP, b)
#define	io_flush(a)	ioctl(a, TIOCFLUSH, 0)
#define	io_break(a)	ioctl(a, TIOCSBRK, 0)

struct	sgttyb	savp_tty = {0};		/* save original keyboard data here */
struct	sgttyb	wrkp_tty = {0};		/* working set for keyboard */


static int inraw = 0;

tty_init()
{

	/*
	 * make a copy of the original parameters
	 */

	if ( io_get(0, &savp_tty ) )
	{
		return(-1);
	}


	/*
	 * now make a few spare working copies 
	 *
	 * Note: I'm assuming that if the first ioctl()
	 * succeeded, the rest probably will too. So,
	 * we only check for an error after all have been done.
	 */
	io_get(0, &wrkp_tty);

	/*
	 * init Keyboard device
	 */
	wrkp_tty.sg_flags |= (RAW | TANDEM);
	wrkp_tty.sg_flags &= ~(CRMOD | ECHO);

	if ( io_set(0, &wrkp_tty) )
		return(-1);
	else
		inraw++;

	io_flush(0);
	return(0);
}


/*
 * reset the terminal and comm port
 */
int	tty_restore()
{
	io_set(0, &savp_tty);
}

/* scan routine to enable ^C interupt */
scan_init()
{
	io_get(0, &wrkp_tty);
	wrkp_tty.sg_flags &= ~RAW;
	io_set(0, &wrkp_tty);
}

/* scan routine to disable ^C interupt */
int scan_restore()
{
	io_get(0, &wrkp_tty);
	wrkp_tty.sg_flags |= RAW;
	io_set(0, &wrkp_tty);
}

/*
 * put the input into raw mode
 */
to_raw()
{
	if(inraw)		/* don't go to raw again	*/
		return(0);
	io_set(0, &wrkp_tty);
	inraw++;
	return (0);
}

/*
 * restore the input to cooked mode
 */
to_cooked()
{
	if(!inraw)		/* make sure we are in raw mode	*/
		return(0);
	io_set(0, &savp_tty);
	inraw = 0;
	return (0);
}
/*
 * disable signals in input
 */
tty_noints()
{
}
/*
 * enable signals in input
 */
tty_ints()
{
}
flow_on()
{
}
flow_off()
{
}
w_getkey()
{
char c;
	to_raw();
	read(0, &c, 1);
	return(c);
}

/*
 *	Various Utility routines
 *
 *	Some of the 'CTYPE' functions are in here because
 *	so many of the vendors SCREW-UP their macros for
 *	toupper & tolower. (Some people were just not meant to program)
 */

w_tolower(c)
char c;
{
	if(c >= 'A' && c <= 'Z')
        	return( (c)-'A'+'a' );
	else
		return(c);
}
w_toupper(c)
char c;
{
	if(c <= 'z' && c >= 'a')
		return( (c)-'a'+'A' );
	else
		return(c);
}
w_isdigit(c)
char c;
{
	if(c <= '9' && c >= '0')
		return(1);
	else
		return(0);
}

w_isxdigit(c)
char c;
{
	c = w_toupper(c);
	if(w_isdigit(c) || (c <= 'F' && c >= 'A') )
		return(1);
	else
		return(0);
}
/*
 * w_htoi: hex to integer.
 *
 * Decode a hexadecimal value from a string.
 */
int
w_htoi(s)
register char *s;
{
        register int val = 0;

        w_xlc( s );
        if (s[1] == 'x')
                s += 2;

        while ( *s)
        {
                if (*s >= '0' && *s <= '9')
                        val = (val << 4) + (*s - '0');
                else if (*s >= 'a' && *s <= 'f')
                        val = (val << 4) + (*s - 'a' + 0x0a);
                else
                        break;
                s++;
        }
        return(val);
}
w_xlc(p)
 register char *p;
{
    while (*p && w_isxdigit(*p) )
                *p++ = w_tolower(*p);
}

/*--------------------------------------------------------------------
 *
 *      This module will line input with field control
 *      It only supports reading strings.
 *
 *
 *
 *      Usage:
 *
 *      ret = getln(row, col, ibuf, num, gattr);
 *            int row, col;             row & col of input field
 *            char *ibuf;               buffer for input field
 *            int num;                  number of chars of input
 *            int gattr;                field input attributes
 *
 *
 *      RETURNS:
 *              number of chars input
 *              0       if empty field. (cr/nl hit)
 *              -1      if aborted
 *              -2      if backtab hit
 *              -3      if End hit
 *
 *      NOTE:
 *              The same attributes that can be used on winwrite
 *              are available on input field. To get underlines
 *              in the field instead of spaces use AT_ULINE.
 *
 *
 *      WARNINGS:
 *              Buffer MUST be one character bigger than the number of
 *              input chars & MUST be null terminated if previous input
 *              data is to be displayed.
 *
 *      BUGS:
 *              Screen wrapping on input is NOT handled.
 *
 *--------------------------------------------------------------------*/
 
#define KBKTAB  0x0c
#define KEND    0x05
 
getln(row, col, buf, num, gattr)
int row, col;
BYTE *buf;
int num, gattr;
{
register int x;
int echo, numer;
BYTE c;
int dot = 0;            /* keeps track of a dot in int mode */
int hex;
 

	if(gattr & GA_NECHO)
		echo = 0;       /* we will not echo chars   */
	else
		echo = 1;

	if(gattr & (GA_SINT|GA_INT|GA_CINT)) /* Numeric? */
	{
		if(gattr & (GA_SINT|GA_INT|GA_CINT))
			dot++;              /* no dots in int  & cint mode  */
		numer = 1;
	}
	else
	{
		numer = 0;
	}

	if(gattr & (GA_IHEX|GA_BHEX|GA_SHEX))
		hex = 1;
	else
		hex = 0;
 
	if(gattr & GA_FILL)     /* has he passed us data?       */
		x = strlen(buf); /* skip over input data */
	else
		x = 0;          /* else start at begining of buf*/
 
	for(; x < num; x++)     /* blank out rest of input buf  */
		buf[x] = ' ';
 
	buf[num] = NULL;        /* null terminate the buffer    */
	winwrite(buf, row, col, gattr); /* put out field stuff  */
	spotcur(row, col);      /* spot cursor to input col     */
 
	for(x = 0; x < num;)
	{
		c = w_getkey();             /* read a char */
		switch(c)
		{
			case CTL('H'):          /* backspace?           */
				if(x > 0)       /* make sure we can     */
				{
					if(echo) /* erase chr on scrn? */
						write(1, "\b \b", 3);
					x--;    /* move back buffer index  */
					if(numer && !(gattr & GA_INT|GA_CINT))
						if(buf[x] == '.')
							dot--;
					buf[x] = ' ';   /* erase character */
				}
				break;
			case CTL('I'):          /* TAB?             */
			case CTL('F'):          /* TAB?             */
			case CTL('M'):          /* carriage return? */
			case CTL('J'):          /* Line feed?       */
				at_mode(AT_NORMAL); /* force normal text */
				return(x);
 
			case  '\033':                   /* <esc> abort  */
				at_mode(AT_NORMAL);     /* force normal */
				return(-1);
			case  KBKTAB:                   /* back tab abrt*/
			case  CTL('Z'):                 /* back tab abrt*/
			case  CTL('B'):                 /* back tab abrt*/
				at_mode(AT_NORMAL);     /* force normal */
				return(-2);
			case KEND:                      /* END abort    */
			case CTL('A'):                      /* END abort    */
				at_mode(AT_NORMAL);     /* force normal */
				return(-3);
			default:
				if(c < 0x20 || c > 0x7f)
					break;   /* only allow chars */

				if(numer)     /* does he want digits? */
				{
					if(c < '0' || c > '9')
					{
						if(c == '-')
						{
						    if(x)
							    break;
						}
						else if(c == '.')
						{
							if(dot)
								break;
							else
								dot++;
						}
						else
							break;
					}
				}
				else if( hex)	/* does he want hex?	*/
				{
					c = w_toupper(c);
					if(!w_isxdigit(c))
						break;
				}
				else
				{
					if(gattr & GA_BOOL) /* Y or N input? */
					{
						c = w_toupper(c);
						if(c != 'Y' && c != 'N')
							break;
					}
				}
				if(echo)
					write(1, &c, 1);
				else
					write(1, " ", 1); /* space to mv cur */
				buf[x] = c;     /* put in char */
				x++;            /* buffer index */
				buf[x] = NULL;  /* put in NULL */
				if(x == num)    /* see if we are done */
				{
					at_mode(AT_NORMAL);
					return(x);
				}
		}
	}
}

/*--------------------------------------------------------------------
 *
 *      This function will perform page input with field control
 *
 *      Usage:
 *
 *      ret = get_pg(pdata);
 *            PDATA *pdata;             page data structure
 *
 *      NOTE:   If the field length is 1, the input buffer
 *              will be treated as a single char and not a string.
 *
 *
 *      RETURNS:
 *              >= 0       if fields input as requested
 *              -1         if aborted
 *
 *      WARNINGS:
 *              NO field should be longer than 63 characters.
 *
 *
 *--------------------------------------------------------------------*/
 
get_pg(pdata)
PDATA *pdata;
{
register PDATA *pptr;
BYTE buf[64];
int ret = 0;
register int finished = 0;
 
/* first we must put out all the desired prompts and input fields       */
 
	for(pptr = pdata; pptr->p_prmpt; pptr++)
	{
	    winwrite(pptr->p_prmpt, pptr->p_row, pptr->p_col, pptr->p_pattr);
		if(pptr->p_gattr & GA_FILL)     /* passed us data?       */
		{                       /* YES,                          */
			put_fld(pptr, buf);
		}
		else
		{
				sprintf(buf, "%*s", pptr->p_len, "");
		}
		winwrite(buf, pptr->p_row, (pptr->p_col +
		  strlen(pptr->p_prmpt)), pptr->p_gattr);
	}
 
/* Now    go field by field getting input data                  */
 
	for(pptr = pdata; !finished && pptr->p_prmpt; )
	{
		if(pptr->p_gattr & GA_FILL)     /* passed us data?       */
		{                       /* YES, fill it in...            */
			put_fld(pptr, buf);
		}
		if(!(pptr->p_gattr & GA_PROT) && pptr->p_len)
		{    /* make sure not protected and we have a length */
		     ret = getln(pptr->p_row, (pptr->p_col + strlen(pptr->p_prmpt)),
				 buf, pptr->p_len, pptr->p_gattr);
		}
		else
		{
			pptr++;         /* on to next field */
			continue;
		}
 
/* ret = -3 is END which is a strange case, for now I will kind of simulate */
/* an abort. This is not very pretty but time is pressing.                  */
 
		if( ret == -3)  /* End key pressed? */
		{
			ret = 1; /* make it look like a normal enter */
			finished++; /* we are all done */
		}
		if(ret < 0)
		{
			if(ret == -1)   /* ABORT? */
			{
				finished++;     /* we are done */
				continue;
			}
			else
			{
pf:
			    if(pptr > pdata)
			    {       /* echo current back to user  */
				    if(!(pptr->p_gattr & GA_NECHO))
				    {
				      put_fld(pptr, buf);
				      winwrite(buf, pptr->p_row, (pptr->p_col +
				      strlen(pptr->p_prmpt)), pptr->p_gattr);
				    }
				    pptr--;    /* previous field */
				    if(pptr->p_gattr & GA_PROT)
					goto pf;
			    }
			}
		}
		else            /* normal end of field  */
		{
			if( ret == 0)   /* no input data assume old */
			{
				goto nxtfld;    /* on to the next */
			}
			else if( pptr->p_gattr & GA_INT)     /* want an int? */
			{
				*((int*)(pptr->p_buf)) = atoi(buf);
			}
			else if( pptr->p_gattr & GA_SINT)     /* want SHORT? */
			{
				*((USHORT*)(pptr->p_buf)) = atoi(buf);
			}
			else if( pptr->p_gattr & GA_IHEX)     /* want an int? */
			{
				*((int*)(pptr->p_buf)) = w_htoi(buf);
			}
			else if( pptr->p_gattr & GA_SHEX)    /* want a short? */
			{
				*((USHORT*)(pptr->p_buf)) =
				 (USHORT)(w_htoi(buf) & 0x0ffff);
			}
			else if( pptr->p_gattr & GA_BHEX)    /* want a BYTE? */
			{
				*((BYTE*)(pptr->p_buf)) =
				 (BYTE)(w_htoi(buf) & 0x00ff);
			}
			else if( pptr->p_gattr & GA_CINT)  /* char/int?    */
			{
			    *((BYTE*)(pptr->p_buf)) = (BYTE)(atoi(buf) & 0x0ff);
			}
			else
			{
				if(pptr->p_len > 1)
					strcpy(pptr->p_buf, buf);
				else
					*pptr->p_buf = buf[0];
			}
nxtfld:
			if(!(pptr->p_gattr & GA_NECHO))
			{
				put_fld(pptr, buf);
				winwrite(buf, pptr->p_row, (pptr->p_col +
				 strlen(pptr->p_prmpt)), pptr->p_gattr);
			}
			pptr++;                         /* on to next field */
		}
	}
	return(ret);
}
/*
 * put_fld  routine to put a field of a PDATA structure into a buffer
 */
put_fld(pptr, buf)
register PDATA *pptr;
register char *buf;
{
 
	if(pptr->p_gattr & GA_INT)  /* was it an int?    */
	{
		sprintf(buf, "%*d", pptr->p_len, *((int*)(pptr->p_buf)));
	}
	else if(pptr->p_gattr & GA_SINT)  /* was it a short int?    */
	{
		sprintf(buf, "%*d", pptr->p_len, *((USHORT*)(pptr->p_buf)));
	}
	else if(pptr->p_gattr & GA_IHEX)  	/* was it int hex  */
	{
		sprintf(buf, "%*.*X", pptr->p_len, pptr->p_len, 
                 *((int*)(pptr->p_buf)));
	}
	else if(pptr->p_gattr & GA_SHEX)  	/* was it short hex  */
	{
		sprintf(buf, "%*.*X", pptr->p_len, pptr->p_len, 
                 (int)(*((USHORT*)(pptr->p_buf)) & 0x0ffff) );
	}
	else if(pptr->p_gattr & GA_BHEX)  	/* was it BYTE hex  */
	{
		sprintf(buf, "%*.*X", pptr->p_len, pptr->p_len, 
                 (int)(*((BYTE*)(pptr->p_buf)) & 0x00ff) );
	}
	else if(pptr->p_gattr & GA_CINT)  /* was it a char/int?    */
	{
		sprintf(buf, "%*d", pptr->p_len,
		 (int)( *((char*)(pptr->p_buf)) & 0x00ff) );
	}
	else
	{
		if(pptr->p_len > 1)  /* 1 is special */
		{
			sprintf(buf, "%-*s", pptr->p_len, pptr->p_buf);
		}
		else
		{
			buf[0] = *pptr->p_buf;
			buf[1] = NULL;
		}
	}
}
/*
 * get_fld
 *              This routine will allow the user to get a field
 *              of data from the screen without having to maintain
 *              a page data structure for get_pg.
 *              This routine will build it for you.
 */
 
get_fld(p_row, p_col, p_prmpt, p_buf, p_len, p_pattr, p_gattr)
char p_row, p_col, *p_prmpt, *p_buf;
int p_pattr, p_gattr;
{
static PDATA gfp[2] = {
			{ NULL, NULL, NULLPTR, NULLPTR, NULL, 0, 0},
			{ NULL, NULL, NULLPTR, NULLPTR, NULL, 0, 0}
		      };
 
/*      FIRST: fill in struct for get_pg                        */
 
	gfp[0].p_row = p_row;
	gfp[0].p_col = p_col;
	gfp[0].p_prmpt = p_prmpt;
	gfp[0].p_buf = p_buf;
	gfp[0].p_len = p_len;
	gfp[0].p_pattr = p_pattr;
	gfp[0].p_gattr = p_gattr;
 
	return(get_pg(gfp));
}

/*--------------------------------------------------------------------
 *                      more
 *
 *      This function will display a file on the user screen either
 *      a page at a time or a single line a time.
 *
 *
 *      Usage:
 *
 *      more(file, rows, ab)
 *      char *name;             name of file to be displayed
 *      int  rows;              number of rows on the screen
 *      char ab;                abort key (prematurely ends)
 *
 *
 *
 *      RETURNS:
 *
 *              0       if successful and entire file 'mored'.
 *              1       if successful and 'more' aborted.
 *              -1      if file not found/ i/o error.
 *
 *      WARNINGS:
 *
 *              Do not use this function on files with lines that have
 *              a longer length than the length of the physical screen.
 *
 *      BUGS:
 *
 *
 *
 *--------------------------------------------------------------------*/
 
more(name, rows, ab)
char *name;
int rows;
char ab;
{
int line;
int finished = 0;
FILE *file;
char c, lbuf[82];

	/*strcpy(lbuf, HLPDIR);	<== */
	/*strcat(lbuf, "/");	<== */
	strcat(lbuf, name);
	if( (file = fopen(lbuf, "r")) == 0)
		return(-1);
	rows--;                  /* don't count 'more' line */
	line = 1;
	while( fgets(lbuf, sizeof(lbuf), file) && !finished)
	{
		to_cooked();
		printf("%s", lbuf);
		line++;
		if(line > rows)
		{
			printf("-- MORE --");
			fflush(stdout);
			c = w_getkey();
			printf("\r          \r");
			switch(c)
			{
				case ' ':
					cls();
					line = 1;
					break;
				default:
					if(c == ab || c == '\033' || c == 'q')
					{
						fclose(file);
						return(1);      /* aborted */
					}
					line--;
					break;
			}
		}
	}
	fclose(file);   /* close the file       */
	return(0);      /* all file displayed   */
}

/*
 * popup menu response system
 *
 * passed:
 * 
 *              mbuf    Menu buffer. Same buffer that could be sent
 *                      to wr_block()
 *              siz     Size of Menu buffer. (rows, cols)
 *              feloc   First row and col to be highlighted in menu choices.
 *                      (0 = top line)
 *                      (col is relative to left side of menu)
 *              entries Number of entry choices in this menu.
 *              mdata   Pointer to a MDATA struct (for descriptions)
 *              
 * returns      the number of the selection (1 - n) or (0) if aborted.
 *              If aborted (character typed will be stored in c)
 *              -1 if an error occurred.
 *
 * NOTE:        This routine ASSUMES that the menu block that it is passed
 *              will be outlined with some border character.
 *
 *              This routine can ONLY deal with a single column menu block!
 *              Line is highlighted from selected col to border char.
 *
 *
 */

#define         KUP     'k'
#define         KDN     'j'
#define		WKDN	'\n'		/* Wyse down */
#define		WKUP	CTL('Z')	/* Wyse UP */

#define		EICHAR	'<'	/* end inverse (simulator)	*/

/* The assumes below are for centering the menu blocks  */


int     outc();

int mselect(mbuf, siz_rows, siz_cols, feloc_row, feloc_col, entries, mdata,
 mloc_row, mloc_col)
char    *mbuf; /*WARNING do not change this to a WBLOCK! */
int     siz_rows, siz_cols, feloc_row, feloc_col;
int     entries;
MDATA *mdata;
int     mloc_row, mloc_col;	/* where menu block will go             */
{
register WBLOCK     *ptr;
register int noinverse = 0;
int     hloc_row, hloc_col;	/* where highlighted part will be       */
int     hsiz_rows, hsiz_cols;	/* size of highlighted block            */
int     dloc_row, dloc_col;	/* where description will be            */
int     finished = 0;
int     cnt = 0;
int     ftime = 1;      /* tracks first time through loop       */
BYTE    buf[78];
register WBLOCK     *hptr;
MDATA   *tmdata;
register int     x;
char  sv_echar;		/* to hold stomped on char (simulator */


/*	See if we have a Stupid terminal without inverse video	*/

	if(!strlen(Sostr))	/* assume if Sostr then Sestr	*/
		noinverse++;

/* figure out where to put menu so it is centered in the screen */
/* if the user didn't pick a place for it	*/


/* Assume that menu has a border character, so length will be 1 less than */
/* the number columns specified in siz and we also want 1 blank space   */

	hsiz_rows = 1;                    /* highlight 1 line     */
	hsiz_cols = siz_cols - feloc_col -2;

	tmdata = mdata + 1;        /* skip over title entry        */

	/*
	 * write help menu block
	 * (This will be simulated on dumb tubes)
	 */

	dloc_col = hloc_col = mloc_col + feloc_col;
	dloc_row = mloc_row + siz_rows - 2;
 
	curs_off();             /* turn off the cursor */
 
	do
	{
		hloc_row = mloc_row + feloc_row + cnt;
		
		hptr = ptr = (WBLOCK*)(mbuf + ( (((feloc_row + cnt) *
			 siz_cols) + feloc_col ) * (sizeof(WBLOCK))));
		for(x = hsiz_cols; x; x--)
		{
			if(noinverse)	/* for really stupid terminals */
			{
				if(x == 1)
				{
					sv_echar = ptr->wdata;
					ptr->wdata = EICHAR;
				}
			}
				/* Menu highlight */
			ptr->wattrib = Ipopattr.wattrib;
			ptr++;          /* next pair    */
		}
/* The ftime flag will make slow screens not blink so much  */
		if(!ftime)      /* don't do it on first time in */
		{
			wrblock (hptr, hloc_row, hloc_col, 
			 hsiz_rows, hsiz_cols);
		}
 
/* Now we need to print out the description line        */
 
 
		/* blank out current line */
	    bputfill(mbuf, siz_rows, siz_cols, siz_rows -2, 1, 1, siz_cols -2,
			Popattr.wattrib, Popattr.wdata);
 
		if(tmdata->desc)         /* see if there is a desc */
		{
			strcpy(buf, "[ ");
			strcat(buf, tmdata->desc);
			strcat(buf, " ]");
 
			x = (siz_cols - strlen(buf)) / 2; /* to center */
			bputstr(mbuf, siz_rows, siz_cols, siz_rows -2, x, buf);
		}
		ptr = (WBLOCK*)(mbuf + ((siz_rows -2) * siz_cols ) *
		 sizeof(WBLOCK) + (3 * sizeof(WBLOCK)));
 
/* The ftime flag will make slow screens not blink so much  */
		if(!ftime)      /* don't do it on first time in */
		{
			wrblock(ptr, dloc_row, dloc_col, hsiz_rows, hsiz_cols);
		}
		else
		{       /* this will throw the whole menu in one shot */
			ftime--;        /* clear first time flag */
			wrblock (mbuf, mloc_row, mloc_col, siz_rows, siz_cols);
		}
		
		curs_off();             /* turn off the cursor */
		buf[0] = w_getkey();
		ptr = hptr;     /* hptr still in tact from above */
		for(x = hsiz_cols; x; x--)
		{
			if(noinverse)	/* for really stupid terminals */
			{
				if(x == 1)
				{
					ptr->wdata = sv_echar;
				}
			}
			/* Normal */
			ptr->wattrib = Popattr.wattrib;
			ptr++;          /* next pair    */
		}
		/* wrblock will be done later if needed */

		switch ( buf[0] & 0xff )
		{
			case '\r' :
				finished++;
				break;

			case KUP :
			case WKUP :
				cnt--;
				tmdata--;
				if ( cnt < 0 )
				{
					cnt = entries - 1;
					tmdata += entries;
				}
				break;

			case KDN :
			case WKDN:
			case ' ':
				cnt++;
				tmdata++;
				if ( cnt >= entries )
				{
					cnt = 0;
					tmdata -= entries;  /* to start */
				}
				break;
			case '*':
			case '?':
				cls();
				to_cooked();
				if(buf[0] == '*')
				{
					if(more(tmdata->hfile, Winrows,
					      mdata->sel) < 0)
					{
				printf("No help on %s available.\n",
				  tmdata->prmpt);
					}
				}
				else
				{
					if(more(mdata->hfile, Winrows,
					      mdata->sel) < 0)
					{
				printf("No help on %s available.\n",
				  mdata->prmpt);
					}
				}
				printf("\r<Press any key to continue>");
				fflush(stdout);
				w_getkey();
				cls();
				return(1);

			default :
				buf[0] = w_toupper(buf[0]);
				/* First look for the abort key */
				if( buf[0] == *mdata->sel)
				{
					finished++;
					cnt = -1;
					break;
				}
				/* Now scan through the table and look  */
				/* for the specific slection keys       */
				for(x = 0, tmdata = mdata; x < entries; x++)
				{
				    tmdata++;
				    if( buf[0] == *tmdata->sel)
				    {
					finished++;
 
					if(x == cnt)  /* already there? */
						break; /* yes, skip rest */
					cnt = x;
 
					/* First, unhighlight the slection  */
					wrblock (hptr, hloc_row, hloc_col,
					 hsiz_rows, hsiz_cols);
 
			hptr = ptr = (WBLOCK*)(mbuf + ( (((feloc_row + cnt) *
			 siz_cols) + feloc_col ) * 2));
 
					for(x = hsiz_cols; x; x--)
					{
						if(noinverse)
						    if(x == 1)
							ptr->wdata = EICHAR;
						/* Normal */
					       ptr->wattrib = Ipopattr.wattrib;
					       ptr++;    /* next pair    */
					}
					/* Highlight new selection */
					hloc_row = mloc_row +
					 feloc_row + cnt;
					wrblock (hptr, hloc_row, hloc_col,
					 hsiz_rows, hsiz_cols);
					break;
				    }
				}
				if(!finished)    /* see if no match */
				{
					cnt = 0; /* no match goes to top */
					tmdata = mdata + 1;
				}
		}
		if(!finished)   /* if we are not done, erase highlight */
			wrblock (hptr, hloc_row, hloc_col,
			 hsiz_rows, hsiz_cols);
	} while ( !finished );

	curs_on();              /* turn the cursor back on */
 
	if (cnt >= 0)
	{
		spotcur(0, 0);          /* home cursor */
		finished = 0;
		return((*(tmdata->func))(tmdata->arg));  /* do the function */
	}
	return (-1);       /* returns -1 on abort       */
}

/*
 * this function places a list of strings into
 * a block and then puts the block onto the screen
 */
 
int Popped;

popup(ulhc_row, ulhc_col, siz_rows, siz_cols, prompts, loc_row, loc_col)
int     ulhc_row, ulhc_col;		/* upper left hand corner of the menu */
register int     siz_rows, siz_cols;	/* size of the window */
char    *prompts[];                     /* what to write into the window */
int     loc_row, loc_col;		/* location in the window for prompts */
{
register int     i = 0;

	if ( Popped )
		popdown();

	bputfill(Mblock, siz_rows, siz_cols, 0, 0, 
		siz_rows, siz_cols, Popattr.wattrib, Popattr.wdata);
	border(Mblock, siz_rows, siz_cols);

	for (i = 0; prompts[i]; i++ )
	{
		bputstr(Mblock, siz_rows, siz_cols, loc_row, loc_col,
		 prompts[i]);

		loc_row++;
	}

	if ( wrblock(Mblock, ulhc_row, ulhc_col, siz_rows, siz_cols) < 0 )
		return (-1);

	curs_off();
	Popped = 1;
	return (0);

}

/*
 * restores the last save block operation
 */
popdown()
{
	if ( Popped )
	{
		cls();
		Popped = 0;
	}
}


/*
 * bputfill
 *
 * puts an attribute and a char at the desired locations in the block 
 * that will be written to the window.
 */

bputfill (blkbuff, siz_rows, siz_cols, ulhc_row, ulhc_col, rows, cols,
 wattr, wdata)
WBLOCK     *blkbuff;	/* the window block buffer - chars in low bytes,
			   attributes in high bytes */
int     siz_rows, siz_cols;
int     ulhc_row;       /* row of upper left hand corner to start with */
int     ulhc_col;       /* col of upper left hand corner to start with */
int     rows;           /* number of rows to put the attribute in */
int     cols;           /* number of cols to put the attribute in */
register WATTRIB wattr;  	/* attribute to put */
register WDATA	 wdata;		/* data to put */
{
register WBLOCK     *buffptr;
int     i;

	buffptr = (blkbuff + (ulhc_row * siz_cols) + ulhc_col);
	while (rows--)
	{
		for (i = 0; i < cols; i++)
		{
			buffptr->wattrib = wattr;
			buffptr->wdata = wdata;
			buffptr++;
		}
	}
}


/*
 * bputstr
 *
 * puts a string at the desired location in the block that will be
 * written to the window. The string will be truncated if it goes
 * outside of the block boundary - no wrapping will be done.
 *
 */

bputstr (blkbuff, siz_rows, siz_cols, ulhc_row, ulhc_col, str)
WBLOCK     *blkbuff;	/* the window block buffer */
int     siz_rows, siz_cols;
int     ulhc_row;    	/* row of upper left hand corner to start with */
register int     ulhc_col; /* col of upper left hand corner to start with */
register char    *str;  /* string to put */
{
register WBLOCK     *buffptr;
register int     len;

	len = siz_cols;
	buffptr = (blkbuff + (ulhc_row * len) + ulhc_col);
	while (*str && ulhc_col++ < len)
		(buffptr++)->wdata = *str++;
}

/*
 * border puts a single line border around the pop up menu
 */

border(blkbuf, siz_rows, siz_cols)
WBLOCK     *blkbuf;
int     siz_rows, siz_cols;
{
register    WBLOCK     *ptr;
register    int     i;

	ptr = blkbuf + ((siz_rows - 1) * siz_cols);
	for ( i = 1; i < siz_cols; i++)
	{
		(blkbuf + i)->wdata = Hchr;
		(ptr + i)->wdata = Hchr;
	}

	for ( i = 1; i < siz_rows; i++)
	{
		ptr = blkbuf + (i * siz_cols);
		ptr->wdata = Vchr;
		(ptr + (siz_cols - 1))->wdata = Vchr;
	}

	ptr = blkbuf;
	ptr->wdata = Ulchr;
	(ptr + (siz_cols - 1))->wdata = Urchr;
	ptr += ((siz_rows - 1) * siz_cols);
	ptr->wdata = Blchr;
	(ptr + (siz_cols - 1))->wdata = Brchr;
}
/*
 *      msg     Routine to popup a 1 line message
 */
 
msg(str)
char *str;
{
char *prmpt[2];
int siz_rows, siz_cols, loc_row, loc_col, ulhc_row, ulhc_col;
 
	prmpt[0] = str;
	prmpt[1] = NULLPTR;
	siz_rows = 3;        /* 5 rows: Top, blnk, str, blnk, Bot */
	siz_cols = strlen(str) + 4;   /* str + blnk on each side & brdr */
	loc_col = 2;        /* skip over bdr & first space */
	loc_row = 1;        /* skip over bdr & first line */
	ulhc_col = (Wincols - siz_cols) / 2;
	ulhc_row = (Winrows - siz_rows) / 2;
	Popped = 0;
	popup(ulhc_row, ulhc_col, siz_rows, siz_cols,  prmpt,
	 loc_row, loc_col);
	w_getkey();
	return(0);
}

/*
 * popup menu response system
 *
 * passed       An array of menu Prompts
 * returns      the number of the selection or (-1) if aborted
 */
 
int select(m, mloc_row, mloc_col)
MDATA   *m;
int mloc_row, mloc_col;
{
int     loc_row, loc_col;
int     siz_rows, siz_cols;

int     cnt;
register int entries;
int     len;
register int     i, row;
register MDATA   *tm = m;


	/*
	 * determine the number of prompts and the length
	 * of the longest prompt or description
	 */
 
/* REMEMBER: The first MDATA member is different, it only contains a    */
/* title in the prompt field                                            */
/* NOTE: although we only compare true lengths of prompts & descripts,  */
/* since both lines will have an additional 4 chars we will not have    */
/* to perform the add until the end. It is recommend that the same #    */
/* of chars be added to the description as to the prompt to make this   */
/* search faster.                                                       */

	for ( len = 0, entries = 0; tm->prmpt; tm++, entries++)
	{
		cnt = strlen(tm->prmpt);
		if ( cnt > len )
			len = cnt;
		if(tm->desc)
		{
			cnt = strlen(tm->desc);
			if ( cnt > len )
				len = cnt;
		}
	}
	len += 4;    /* add in amount of extra chars '[ ]' */
	entries--;      /* don't count the 0th entry, it is the title */
 
	/*
	 * Create the menu block
	 *  (adjust sizes to give room for space and borders)
	 */

	siz_rows = entries + 6;		/* height of menu block */
	siz_cols = len + 6;		/* width of menu block  */
	loc_row = 3;
	loc_col = 3;

	/* First, Fill in the menu with Inverse <SPACES>        */

	bputfill(Mblock, siz_rows, siz_cols, 0, 0, siz_rows,
		siz_cols, Popattr.wattrib, Popattr.wdata);

	border(Mblock, siz_rows, siz_cols);	/* put border around it     */

/* First, Put in the menu header (title)        */
/* Center title in menu block on line 1         */
 
	i = (siz_cols - strlen(m->prmpt)) / 2;
	bputstr(Mblock, siz_rows, siz_cols, 1, i, m->prmpt);
 
	
/*              Now actually put the prompts in the menu buffer         */
/*              and also put in the selection keys                      */
 
	tm = m;
	tm++;           /* skip over heading */
	for(  i = 1, row = loc_row; i <= entries ; i++, row++, tm++)
	{
		bputstr(Mblock, siz_rows, siz_cols, row, (loc_col + 4),
		 tm->prmpt);

		bputstr(Mblock, siz_rows, siz_cols, row, loc_col, "[ ]");
		bputstr(Mblock, siz_rows, siz_cols, row, (loc_col + 1),
		 tm->sel);
	}
		
	
	/* Throw out the menu block and highlight choices       */

	if(mloc_col < 0)
		mloc_col = (Wincols - siz_cols) / 2;

	if(mloc_row < 0)
		mloc_row = (Winrows - siz_rows) /2;


	return(mselect(Mblock, siz_rows, siz_cols, loc_row, loc_col,
	 entries, m, mloc_row, mloc_col));
}


main(argc, argv)
int argc;
char *argv[];
{

	printf("%s\n", vjutilCSid);

	/*if(chdir(OURDIR))
		perror(argv[0]); <== */
	if(setwin() < 0)
	{
		printf("setwin failed\n");
		exit(-1);
	}

	Pname = argv[0];

	if(argc != 2)
		usage();	/* does not return	*/

	Fname = argv[1];

	if( (Ifd = open(Fname, O_RDWR)) <  0 )
	{
		printf("%s: Error opening %s\n", Pname, Fname);
		exit(-1);
	}
	if( fstat(Ifd, &filestat) < 0)
	{
		printf("%s: Error in fstat %s\n", Pname, Fname);
		exit(-1);
	}
	else
	{
		if ((filestat.st_mode & S_IFMT) != S_IFCHR)
			usage();
	}

	/* for scan to allow ^C interrupt */
	signal(SIGINT,checkabort); 
	signal(SIGQUIT,checkabort);

	tty_init();
	cls();
	do
	{
		ipdheader();
		winwrite("< Press '?' for Help, <ESC> to exit >", STATLINE, -1, AT_NORMAL);
	} while(select(Mdata, -1, -1) >= 0);
	cls();
	close(Ifd);
	tty_restore();
}
usage()
{
	printf("Usage: %s raw-dev-name\n", Pname);
	exit(-1);
}
toggle()
{
	notdone();
}

/* Get P-list of defects from drive and print */
/* Get G-list of defects from drive and print */
dlist()
{
char line[81];
char s[2];
int cyl;	/* defect entry cylinder number */
long sec;	/* defect entry sector number */
int count;	/* screen row counter */
int x;
caddr_t defectbuff;

	/* GET AND DISPLAY P-LIST */

	cls();

	/* store scsi_list pointer into defectbuff */
	defectbuff = (caddr_t)&scsi_list;

	/* get P-list defects */
	if(ioctl(Ifd, VJIOGETPDEF, &defectbuff) < 0)
	{
		sprintf(line, "    ERROR in reading P-list cmd: %s", sys_errlist[errno]);
		emsg(line);
		return;
	}

	winwrite("P-list defects", 1, -1, AT_NORMAL);
	sprintf(line, "Total number of P-list defects = %d",(scsi_list.length / 8));
	winwrite(line, 3, -1, AT_NORMAL);
	winwrite("Defect Number     Cylinder     Head     Sector", 4, -1, AT_NORMAL);
	count = 6;
	for (x = 0; ((x < (scsi_list.length / 8)) && (x < MAX_DEF_ENTRY)); x++)
	{
		cyl = ((scsi_list.def_list[x].cyl_hi & 0xff) << 16)
			+ ((scsi_list.def_list[x].cyl_mid & 0xff) << 8)
			+ (scsi_list.def_list[x].cyl_lo &0xff);
		sec = ((scsi_list.def_list[x].defsec_1 & 0xff) << 24)
			+ ((scsi_list.def_list[x].defsec_2 & 0xff) << 16)
			+ ((scsi_list.def_list[x].defsec_3 & 0xff) << 8)
			+ (scsi_list.def_list[x].defsec_4 &0xff);
		sprintf(line, "%10d  %10d  %10d  %10d",
			(x+1),cyl,scsi_list.def_list[x].head,sec);
		winwrite(line, count, -1, AT_NORMAL);
		if (count == (STATLINE - 2))
		{
			winwrite("Press any key to continue <ESC> for G-list", STATLINE, -1, AT_NORMAL);
        	winwrite(" ", STATLINE, 1, AT_NORMAL);
        	s[0] = w_getkey();
			if (s[0] == 0x1b)
				break;
			cls();
			winwrite("P-list defects", 1, -1, AT_NORMAL);
			sprintf(line, "Total number of P-list defects = %d",(scsi_list.length / 8));
			winwrite(line, 3, -1, AT_NORMAL);
			winwrite("Defect Number     Cylinder     Head     Sector", 4, -1, AT_NORMAL);
			count = 6;
		}
		else count++;
	}
	winwrite("End of P-list Press any key for G-list <ESC> to ABORT", STATLINE, -1, AT_NORMAL);
   	winwrite(" ", STATLINE, 1, AT_NORMAL);
	if (s[0] != 0x1b)
	{
	   	s[0] = w_getkey();
		if (s[0] == 0x1b)
		{
			emsg(Aborted);
			return;
		}
	}

	/* GET AND DISPLAY G-LIST */

	cls();

	/* store scsi_list pointer into defectbuff */
	defectbuff = (caddr_t)&scsi_list;

	/* get G-list defects */
	if(ioctl(Ifd, VJIOGETGDEF, &defectbuff) < 0)
	{
		sprintf(line, "    ERROR in reading G-list cmd: %s", sys_errlist[errno]);
		emsg(line);
		return;
	}

	winwrite("G-list defects", 1, -1, AT_NORMAL);
	sprintf(line, "Total number of G-list defects = %d",(scsi_list.length / 8));
	winwrite(line, 3, -1, AT_NORMAL);
	winwrite("Defect Number     Cylinder     Head     Sector", 4, -1, AT_NORMAL);
	count = 6;
	for (x = 0; ((x < (scsi_list.length / 8)) && (x < MAX_DEF_ENTRY)); x++)
	{
		cyl = ((scsi_list.def_list[x].cyl_hi & 0xff) << 16)
			+ ((scsi_list.def_list[x].cyl_mid & 0xff) << 8)
			+ (scsi_list.def_list[x].cyl_lo &0xff);
		sec = ((scsi_list.def_list[x].defsec_1 & 0xff) << 24)
			+ ((scsi_list.def_list[x].defsec_2 & 0xff) << 16)
			+ ((scsi_list.def_list[x].defsec_3 & 0xff) << 8)
			+ (scsi_list.def_list[x].defsec_4 &0xff);
		sprintf(line, "%10d  %10d  %10d  %10d",
			(x+1),cyl,scsi_list.def_list[x].head,sec);
		winwrite(line, count, -1, AT_NORMAL);
		if (count == (STATLINE - 2))
		{
			winwrite("Press any key to continue <ESC> to ABORT", STATLINE, -1, AT_NORMAL);
   			winwrite(" ", STATLINE, 1, AT_NORMAL);
   			s[0] = w_getkey();
			if (s[0] == 0x1b)
			{
				emsg(Aborted);
				return;
			}
			cls();
			winwrite("G-list defects", 1, -1, AT_NORMAL);
			sprintf(line, "Total number of G-list defects = %d",(scsi_list.length / 8));
			winwrite(line, 3, -1, AT_NORMAL);
			winwrite("Defect Number     Cylinder     Head     Sector", 4, -1, AT_NORMAL);
			count = 6;
		}
		else count++;
	}
	winwrite("End of G-list Press any key for Main Menu", STATLINE, -1, AT_NORMAL);
   	winwrite(" ", STATLINE, 1, AT_NORMAL);
	s[0] = w_getkey();
}

/* scan funtion */
scan()
{
struct dk_conf diskconf;
int no_pass;        /* number of passes */
int start_sec;      /* starting sector for scan */
int end_sec;        /* ending sector for scan */
int pass;           /* print for pass number being done */
int sec_num;        /* sector number presently being scaned */
int patcnt = 0;     /* test pattern index */
int bad_cnt = 0;    /* number of bad sectors found */
int x;              /* counter */
int port, id;       /* device to scan */
int scanrow;        /* row counter to print scan error */
int nondist = 0;    /* flag for destructive of non-destructive scan mode */
int flag;           /* flag for one sector test */
long start;         /* sector to lseek to */
char line[81], s[81];   /* print buffers */

    /* print header */
    strcpy(line, "Scan Disk for Defects: ");
    strcat(line, Fname);
    cls();
    winwrite(line, 1, -1, AT_NORMAL);
    winwrite("< Press <ESC> to ABORT >", STATLINE, -1, AT_NORMAL);

    /* print device name */
    strcpy(line, "Jaguar SCSI Port: ");
    port = diskconf.dkc_slave & M_UNIT_BUS ? 1 : 0;
    itoa(port, s);
    strcat(line, s);
    strcat(line, "   SCSI Id: ");
    id = (diskconf.dkc_slave >> 3) & 07;
    itoa(id, s);
    strcat(line, s);
    winwrite(line, 3, -1, AT_NORMAL);
 
    /* verify partition exists */
    if(ioctl(Ifd, DKIOCGCONF, &diskconf) < 0)
    {
        sprintf(line, "Error in disk scanning: %s", sys_errlist[errno]);
		emsg(line);
		return;
    }

    /* read label from disk */
    lseek(Ifd, 0, 0);
    if( read(Ifd, &Dklabel, sizeof(struct dk_label) ) <  0)
    {
        sprintf(line, "%s: Error reading %s\n", Pname, Fname);
		emsg(line);
		return;
    }

    /* verify this is partition 'c' */
    for (x = 0; Fname[x] != '\0'; x++);
    if (Fname[x - 1] != 'c')
    {
        sprintf (line, "Error must use partition 'c' for device");
		emsg(line);
		return;
    }

    /* check for valid label */
    if (Dklabel.dkl_magic != DKL_MAGIC)
    {
        sprintf (line, "Error illegal label");
		emsg(line);
		return;
    }

    /* verify partition 'c' starts at cyl 0 */
    if (Dklabel.dkl_map[2].dkl_cylno != 0 )
    {
        sprintf (line, "Error partition 'c' must start at cyl 0");
		emsg(line);
		return;
    }

    /* non-destructive testing or destructive testing */
    s[0] = 'Y';
    if(get_fld(6, 20, "Non-Destructive test? ", s, 1, AT_NORMAL, GA_BOOL|GA_FILL) < 0)
    {
		emsg(Aborted);
		return;
    }
    if(s[0] == 'Y')
        nondist = 1;

    /* find out which partition to scan a - h*/
    sprintf (line, "Enter partition to scan? (a - h) c");
    do {
        winwrite(line, 8, 20, AT_NORMAL);
        winwrite(" ", 8, 52, AT_NORMAL);
        s[0] = w_getkey();
        if (s[0] == '\r')
            s[0] = 'c';
        if (s[0] == 0x1b)
		{
			emsg(Aborted);
			return;
		}
        s[0] = w_toupper(s[0]);
    } while ((s[0] < 'A') || (s[0] > 'H'));
    x = ((int)s[0]) - 0x41; 
    /* convert to lower case */
    s[0] = s[0] + 0x20;
    s[1] = '\0';
    winwrite(s, 8, 53, AT_NORMAL);

    /* set up staring sector and ending sector variables */
    start_sec = Dklabel.dkl_map[x].dkl_cylno * Dklabel.dkl_nhead * Dklabel.dkl_nsect;
    end_sec = start_sec + (Dklabel.dkl_map[x].dkl_nblk - 1);

    /* get number of passes */
    do {
        x = 1;
        if(get_fld(10, 20, "Enter number of passes? (0 - 1000)    ", (char *)&x, 4, AT_NORMAL,
GA_INT|GA_FILL) < 0)
        {
			emsg(Aborted);
			return;
        }
    } while ((x < 0) || (x > 1000));
    no_pass = x;

    /* find out what the user wants to scan */
    sprintf(s, "Scan all of Partition? ");
    line[0] = 'Y';
    if(get_fld(12, 20, s, line, 1, AT_NORMAL, GA_BOOL|GA_FILL) < 0)
    {
		emsg(Aborted);
		return;
    }

    /* the user wants to scan only part of disk */
    if(line[0] != 'Y')
    {
        /* get starting sector to scan */
        sprintf (s, "Starting Sector Number? (%d - %d) ",start_sec,end_sec);
        do {
            x = start_sec;
            if(get_fld(14, 20, s, (char *)&x, 8, AT_NORMAL, GA_INT|GA_FILL) < 0)
            {
				emsg(Aborted);
				return;
            }
        } while ((x < start_sec) || (x > end_sec -1));
        start_sec = x;

        /* get ending sector to scan */
        sprintf (s, "Ending Sector Number?   (%d - %d) ",start_sec,end_sec);
        do {
            x = end_sec;
            if(get_fld(16, 20, s, (char *)&x, 8, AT_NORMAL, GA_INT|GA_FILL) < 0)
            {
				emsg(Aborted);
				return;
            }
        } while ((x < start_sec) || (x > end_sec));
        end_sec = x;
    }

    /* set variables to allow ^C exit */
    abort_status = 1;
    abort_flag = 0;

    /* clear sg_flags RAW to allow ^C */
    scan_init();

    /* beginning of pass loop */
    /* will loop until all passes are completed or ^C is hit */
    for (pass = 1; pass <= no_pass; pass++)
    {
        /* fill the write buffer with the test pattern */
        for (x = 0; x < (SCAN_SEC * 512); x++)
        {
            scanwbuf[x++] = (testpatterns[patcnt] >> 24) & 0xff;
            scanwbuf[x++] = (testpatterns[patcnt] >> 16) & 0xff;
            scanwbuf[x++] = (testpatterns[patcnt] >> 8) & 0xff;
            scanwbuf[x] = testpatterns[patcnt] & 0xff;
        }

        /* print type of scan and device*/
        if (nondist)
                strcpy(line, "Non-Destructive Scan: ");
        else    strcpy(line, "Destructive Scan: ");
        strcat(line, Fname);
        cls();
        winwrite(line, 1, -1, AT_NORMAL);
        sprintf(line, "Pass number: %d of %d",pass,no_pass);
        winwrite(line, 2, -1, AT_NORMAL);
        sprintf(line, "Test pattern: 0x%x",testpatterns[patcnt]);
        winwrite(line, 3, -1, AT_NORMAL);
        winwrite("< Hit <^C> to ABORT >", STATLINE, -1, AT_NORMAL);

        /* set starting row to place errors */
        scanrow = 0;

        /* display sector number */
        sprintf(line, "Completed sector %d of %d",start_sec,end_sec);
        winwrite(line, 6, -1, AT_NORMAL);

        /* seek to first sector to scan */
        lseek(Ifd, 0L, 0);
        start = start_sec * 512;
        lseek(Ifd, start, L_SET);

        /* set flag */
        flag = 0;

        /* beginning of scan loop */
        /* will loop until all sectors are scaned or ^C is hit */
        for (sec_num = start_sec; (sec_num + SCAN_SEC -1) <= end_sec; sec_num += SCAN_SEC)
        {
            scansec (0, sec_num, (sec_num + SCAN_SEC -1), 
                    (SCAN_SEC * 512), nondist, &scanrow, &bad_cnt);

            /* display sector number */
            if (((sec_num - start_sec) % (SCAN_SEC * 20)) == 0)
            {
                sprintf(line, "Completed sector %d of %d",sec_num,end_sec);
                winwrite(line, 6, -1, AT_NORMAL);
            }

            /* check if ^C has been hit */
            if (abort_flag)
                break;
        } /* end of scan loop */
        
        /* finish off scan */
        if (!abort_flag)
        {
            if ((sec_num -1) != end_sec)
                scansec (1, sec_num, end_sec, 512, nondist, &scanrow, &bad_cnt);
            /* display sector number */
            sprintf(line, "Completed sector %d of %d",end_sec,end_sec);
            winwrite(line, 6, -1, AT_NORMAL);
        }

        /* set up next test pattern */
        patcnt++;
        /* if last test pattern set to first pattern */
        if (testpatterns[patcnt] == 0x00000000)
            patcnt = 0;

        /* check if ^C has been hit */
        if (abort_flag)
            break;
    } /* end of pass loop */

    /* clear variables to not allow ^C exit */
    abort_status = 0;
    abort_flag = 0;

    /* set sg_flags RAW to not allow ^C */
    scan_restore();

    /* print finished with scan and number of bad sectors found */
    sprintf(line, "Scanning completed, found %d bad sectors",bad_cnt);
	emsg(line);
	return;
}

/* scan sector's */
/* type      = 0 - scan multiple sectors at a time */
/*             1 - scan one sector at a time */
/*             2 - scan one sector at a time but use old save buffer */

/* start_sec = starting sector for scan */
/* end_sec   = ending sector for scan */
/* length    = length to lseek */
/* nondist   = flag for destructive of non-destructive scan mode */
/* scanrow   = row counter to print scan error */
/* bad_cnt   = number of bad sectors found */

scansec(type, start_sec, end_sec, length, nondist, scanrow, bad_cnt)
int type;
int start_sec;
int end_sec;
long length;
int nondist;
int *scanrow;
int *bad_cnt;
{
int sec_num;        /* sector number presently being scaned */
int flag;           /* flag for read error when non-destructive in mode */
int no_sec;         /* number of sectors per scan */
int x;
char line[81];      /* print buffer */

    /* set number of sectors per scan */
    no_sec = length / 512;

    /* seek to first sector to scan */
    if (type)
    {
        lseek(Ifd, 0L, 0);
        lseek(Ifd, (start_sec * 512), L_SET);
    }

    /* beginning of scan loop */
    /* will loop until all sectors are scaned or ^C is hit */
    for (sec_num = start_sec; sec_num <= end_sec; sec_num += no_sec)
    {
        /* clear one byte in each read buffer */
        for (x = 0; x < no_sec; x++) 
            scanrbuf[(x * 512) + 100] = 0;

        /* if non-distructive scan save sector to scansavebuf */
        if (nondist && (type != 2))
        {
            /* set flag to no read buffer error */
            flag = 1;
            if (read(Ifd, scansavebuf, length) <  0)
            {
                if (type == 0)
                    return (scansec (1, start_sec, end_sec, 512, nondist, scanrow, bad_cnt)); 
                scanerror (1, scanrow, sec_num);
                flag = 0;
            }
            else lseek (Ifd, -(length), L_INCR);
        }

        /* write test buffer to sector */
        if (write(Ifd, scanwbuf, length) <  0)
        {
            if (type == 0)
                return (scansec (2, start_sec, end_sec, 512, nondist, scanrow, bad_cnt)); 
            scanerror (2, scanrow, sec_num);
            *bad_cnt += 1;
            goto scanerr;
        }

        /* read test buffer from sector */
        lseek (Ifd, -(length), L_INCR);
        if (read(Ifd, scanrbuf,  length) <  0)
        {
            if (type == 0)
                return (scansec (2, start_sec, end_sec, 512, nondist, scanrow, bad_cnt)); 
            scanerror (3, scanrow, sec_num);
            *bad_cnt += 1;
            goto scanerr;
        }

        /* compare read and write buffers */
        if (memcmp(&scanwbuf[0], &scanrbuf[0], length))
        {
            /* seek to first sector to compare */
            lseek (Ifd, 0L, 0);
            lseek (Ifd, (start_sec * 512), L_SET);

            for (x = 0; x < no_sec; x++)
            {
                if (memcmp(&scanwbuf[x * 512], &scanrbuf[x * 512], 512))
                {
                    scanerror (4, scanrow, (sec_num + x));
        			*bad_cnt += 1;
                }
                if (nondist)
                    if (write(Ifd, &scansavebuf[x * 512], 512) <  0)
                        scanerror (5, scanrow, (sec_num + x));
    			/* check if ^C has been hit */
				if (abort_flag)
					break;
			}
            goto scanerrend;
        }

scanerr:

        /* if non-distructive scan restore sector from scansavebuf */
        if (nondist)
        {
            lseek (Ifd, -(length), L_INCR);
            if (type != 2)
            {
                if (flag)
				{
                    if (write(Ifd, scansavebuf, length) <  0)
                    {
                        lseek (Ifd, 0L, 0);
                        lseek (Ifd, (sec_num * 512), L_SET);
						/* try again */
                    	if (write(Ifd, scansavebuf, length) <  0)
						{
                        	scanerror (5, scanrow, sec_num);
                        	lseek (Ifd, 0L, 0);
                        	lseek (Ifd, ((sec_num * 512) + length), L_SET);
						}
                    }
				}
				else lseek (Ifd, length, L_INCR);
            }
            else {
                if (write(Ifd, &scansavebuf[(sec_num - start_sec) * 512], length) <  0) 
                    scanerror (5, scanrow, sec_num);
            }
        }

scanerrend:

        /* check if ^C has been hit */
        if (abort_flag)
            break;
    } /* end of scan loop */
}

/* scan error funtion */
/* type = 1 - save sector read error */
/*        2 - write test pattern to sector error */
/*        3 - read test pattern from sector error */
/*        4 - compare test pattern (scanwbuf - scanrbuf) error */
/*        5 - restore sector write error */ 
/* x = row to print error */
/* sec = sector number for lseek */

scanerror (type, x, sec)
int type;
int *x;
int sec;
{
char line[81];

    /* clear line */
    if (*x == 16)
        *x = 0;
    sprintf(line,"                                                                      ");
    winwrite(line, (*x + 8), 1, AT_NORMAL);

    /* print error message */
    switch (type) {
        case 1 :
                sprintf(line, "ERROR could not read and save sector %d: %s", sec,
sys_errlist[errno]);
                break;
        case 2 :
                sprintf(line, "WRITE ERROR in sector %d: %s", sec, sys_errlist[errno]);
                break;
        case 3 :
                sprintf(line, "READ ERROR in sector %d: %s", sec, sys_errlist[errno]);
                break;
        case 4 :
                sprintf(line, "COMPARE ERROR in sector %d", sec);
                break;
        case 5 :
                sprintf(line, "ERROR could not write saved sector %d: %s", sec, sys_errlist[errno]);
        default :
                break;
    }
    winwrite(line, (*x + 8), 1, AT_NORMAL);
    *x += 1;

    /* reasign bad block */
    switch (type) {
        case 2 :
        case 3 :
        case 4 :
                /* clear line */
                if (*x == 16)
                    *x = 0;
                sprintf(line,"                                                                     ");
                winwrite(line, (*x + 8), 1, AT_NORMAL);
                /* set block to reasign */
                scsi_rsgnblk.rd_len_msb = 0;
                scsi_rsgnblk.rd_len_lsb = 4;    /* only 1 defect blk */
                scsi_rsgnblk.rd_blk_addr_3 = (sec >> 24) & 0xff;
                scsi_rsgnblk.rd_blk_addr_2 = (sec >> 16) & 0xff;
                scsi_rsgnblk.rd_blk_addr_1 = (sec >> 8) & 0xff;
                scsi_rsgnblk.rd_blk_addr_0 = sec & 0xff;

                /* reasign block */
	            if(ioctl(Ifd, VJIORSGNBLK, (char *)&scsi_rsgnblk) < 0)
                    sprintf(line, "    ERROR in reassign blk cmd: %s", sys_errlist[errno]);
                else sprintf(line, "    Completed Reassigning Disk Block %d", sec); 
                winwrite(line, (*x + 8), 1, AT_NORMAL);
                *x += 1;
        default :
                break;
    }

    /* lseek to proper spot */
    switch (type) {
        case 1 :
                lseek (Ifd, 0L, 0);
                lseek (Ifd, (sec * 512), L_SET);
                break;
        case 2 :
        case 3 :
        case 5 :
                lseek (Ifd, 0L, 0);
                lseek (Ifd, ((sec + 1) * 512), L_SET);
        default :
                break;
    }
}

format()
{
struct dk_conf diskconf;
char line[81], s[32];
int x, port, id;
int flag = 0;

	strcpy(line, "Formating Disk Device: ");
	strcat(line, Fname);
	cls();
	winwrite(line, 1, -1, AT_NORMAL);
	winwrite("< Press <ESC> to ABORT >", STATLINE, -1, AT_NORMAL);
	if(ioctl(Ifd, DKIOCGCONF, &diskconf) < 0)
		goto err;
	strcpy(line, "Jaguar SCSI Port: ");
	port = diskconf.dkc_slave & M_UNIT_BUS ? 1 : 0;
	itoa(port, s);
	strcat(line, s);
	strcat(line, "   SCSI Id: ");
	id = (diskconf.dkc_slave >> 3) & 07;
	itoa(id, s);
	strcat(line, s);
	winwrite(line, 3, -1, AT_NORMAL);

    line[0] = 'Y';
    if(get_fld(7, 20, "Use Grown Defect List? ", line, 1, AT_NORMAL, GA_BOOL|GA_FILL) < 0)
    {
		emsg(Aborted);
		return;
    }
    if(line[0] != 'Y')
        flag = 1;
 
    if ( flag )
    {
        strcpy(line, " * Only Primary Defect list will be used     ");
        winwrite(line, 9, -1, AT_NORMAL);
    }
    else
    {
        strcpy(line, " * Primary & Grown Defect lists will be used ");
        winwrite(line, 9, -1, AT_NORMAL);
    }
	strcpy(line, " * Initiator defect list will NOT be supplied");
	winwrite(line, 10, -1, AT_NORMAL);
	strcpy(line, " * Defect list format is in block format     ");
	winwrite(line, 11, -1, AT_NORMAL);
	strcpy(line, " * Use default format data pattern           ");
	winwrite(line, 12, -1, AT_NORMAL);
	strcpy(line, " * Use default interleave factor             ");
	winwrite(line, 13, -1, AT_NORMAL);
	strcpy(line, "*** WARNING: ABOUT TO DESTROY DISK DATA ***!! ");
	winwrite(line, 15, -1, AT_NORMAL);

	line[0] = 'Y';
	if(get_fld(17, 20, "Ready to Format Disk? ", line, 1, AT_NORMAL, GA_BOOL|GA_FILL) < 0)
	{
		return(emsg(Aborted));
	}
	if(line[0] != 'Y')
	{
		return(emsg(Aborted));
	}

    /* Sony Magneto Optical drive */
	/* Set mode select parameters for Sony drive specific page 0x20. */
	scsi_select.hdr.sense_data_len = 0;			/* reserved */
	scsi_select.hdr.medium_type = 0;			/* medium type */
	scsi_select.hdr.WP = 0;						/* reserved */
	scsi_select.hdr.resv = 0;					/* reserved */
	scsi_select.hdr.EBC = 0;					/* reserved */
	scsi_select.hdr.blk_desc_len = 0;			/* block descriptor length */
	scsi_select.blk_desc.density_code = 0x20;	/* page code (page 0x20) */
	scsi_select.blk_desc.nob_high = 0x0a;		/* page length */
	scsi_select.blk_desc.nob_mid = 3;			/* format mode (ISO defect managment) */
	scsi_select.blk_desc.nob_low = 1;			/* type */
	scsi_select.blk_desc.resv = 0;				/* reserved */
	scsi_select.blk_desc.blk_len_high = 0;		/* reserved */
	scsi_select.blk_desc.blk_len_mid = 0;		/* number of bands (MSB) */
	scsi_select.blk_desc.blk_len_low = 1;		/* number of bands (LSB) */
  	scsi_select.pg[0] = 8;						/* size of spare band (MSB) */
  	scsi_select.pg[1] = 0;						/* size of spare band (LSB) */
  	scsi_select.pg[2] = 0;						/* reserved */
  	scsi_select.pg[3] = 0;						/* reserved */

    /* Sony Magneto Optical drive */
	/* If the device is not a Sony Magneto Optical drive, then the 
       mode select command will not be executed and a good status 
       will be returned. */ 
	if(ioctl(Ifd, VJIOMSELECT, (char *)&scsi_select) < 0)
	{
		sprintf(line, "***ERROR*** in mode sense command format: %s\n", sys_errlist[errno]);
		return(emsg(line));
	}

	if(ioctl(Ifd, VJIOFORMAT, 0) < 0)
		goto err;
	return(emsg("Format Completed"));

err:
	sprintf(line, "***ERROR*** in disk formatting: %s", sys_errlist[errno]);
	return(emsg(line));
}
info()
{
char line[81];

	ipdheader();		/* throw disk utility header	*/
	if(ioctl(Ifd, VJIOCONF, (char *)&Csb) < 0)
	{
		sprintf(line, "***ERROR*** in reading ctlr config: %s\n", sys_errlist[errno]);
		return(emsg(line));
	}
	sprintf(Pvar, "%c", Csb.csb_PVAR);
	itoa(Csb.csb_BSIZE, Kram);

	if(ioctl(Ifd, VJIOINQ, (char *)&scsi_inq) < 0)
	{
		sprintf(line, "***ERROR*** in inquiry cmd: %s\n", sys_errlist[errno]);
		return(emsg(line));
	}
	strncpy(vendor_id, scsi_inq.vendor_id, 8);
	strncpy(product_id, scsi_inq.product_id, 16);
	strncpy(revision_level, scsi_inq.revision_level, 4);

	if(ioctl(Ifd, VJIODRIVER, (char *)&sun_driver) < 0)
	{
		sprintf(line, "***ERROR*** in reading driver revision: %s\n", sys_errlist[errno]);
		return(emsg(line));
	}

	get_pg(Idata);
	winwrite("< Press any key to continue >", STATLINE, -1, AT_NORMAL);
	w_getkey();
}

emlabel()					/* examine/modify label	*/
{
char line[81], s[32];
register short *sp;
short sum = 0;
short count = sizeof(struct dk_label)/sizeof(short);
int capacity;
unsigned short phy_cyl;	/* # phy cyl */
VJ_MS_PAGE3 *ms_p3 = (VJ_MS_PAGE3 *)scsi_mode_sense_03.pg;
VJ_MS_PAGE4 *ms_p4 = (VJ_MS_PAGE4 *)scsi_mode_sense_04.pg;

	lseek(Ifd, 0, 0);		/* back to begining	*/

	if( read(Ifd, &Dklabel, sizeof(struct dk_label) ) <  0)
	{
		sprintf(line, "%s: Error reading %s\n", Pname, Fname);
		return(emsg(line));
	}

	strcpy(line, "Disk Label for Device: ");
	strcat(line, Fname);
	cls();
	winwrite(line, 1, -1, AT_NORMAL);
	winwrite("< Press <ESC> to ABORT >", STATLINE, -1, AT_NORMAL);

	if (Dklabel.dkl_magic != DKL_MAGIC)
	{
		line[0] = 'Y';
		if(get_fld(10, 20, "***ILLEGAL LABEL***  Use default label? ", line, 1, AT_NORMAL, GA_BOOL|GA_FILL) < 0)
		{
			return(emsg(Aborted));
		}
		if(line[0] != 'Y')
		{
			return(emsg(Aborted));
		}

mklabel:
		strcpy(line, "Disk Label for Device: ");
		strcat(line, Fname);
		cls();
		winwrite(line, 1, -1, AT_NORMAL);
		winwrite("< Press <ESC> to ABORT >", STATLINE, -1, AT_NORMAL);

		/*
		 * Get detail disk device data
		 */
		if(ioctl(Ifd, VJIOMSENSE03, (char *)&scsi_mode_sense_03) < 0)
		{
			sprintf(line, "***ERROR*** in mode sense command label: %s\n", sys_errlist[errno]);
			return(emsg(line));
		}
		if(ioctl(Ifd, VJIOMSENSE04, (char *)&scsi_mode_sense_04) < 0)
		{
			sprintf(line, "***ERROR*** in mode sense command label: %s\n", sys_errlist[errno]);
			return(emsg(line));
		} 

		/*
		 *  Create a disk label
		 */
		if(ioctl(Ifd, VJIOCAP, (char *)&scsi_capacity) < 0)
		{
			sprintf(line, "***ERROR*** in reading disk capacity: %s\n", sys_errlist[errno]);
			return(emsg(line));
		}
		capacity = ((scsi_capacity.blk_addr_3 & 0xff) << 24)
					+ ((scsi_capacity.blk_addr_2 & 0xff) << 16)
					+ ((scsi_capacity.blk_addr_1 & 0xff) << 8)
					+ (scsi_capacity.blk_addr_0 &0xff);
		if (capacity <= 0)
		{
			sprintf(line, "***ERROR*** in disk capacity\n");
			return(emsg(line));
		}

    	/* Sony Magneto Optical drive */
		/* If Sony drive then the cylinder value will be equal to 0.
		   Set the correct value by using the capacity. */
		if ((ms_p4->max_no_cyl_hi == 0) && (ms_p4->max_no_cyl_mid == 0) &&
			(ms_p4->max_no_cyl_lo == 0))
		{
			ms_p4->max_no_cyl_hi = (((capacity / ms_p4->max_no_heads) / ms_p3->sctr_per_trk_lo) >> 16);
			ms_p4->max_no_cyl_mid = (((capacity / ms_p4->max_no_heads) / ms_p3->sctr_per_trk_lo) >> 8);
			ms_p4->max_no_cyl_lo = ((capacity / ms_p4->max_no_heads) / ms_p3->sctr_per_trk_lo);
		}

		bzero((char *)&Dklabel, sizeof(struct dk_label));
		strcpy(Dklabel.dkl_asciilabel, "Interphase Jaguar Default disk label");
#ifdef OS4
		Dklabel.dkl_rpm = 3600;
#endif
		Dklabel.dkl_nhead = ms_p4->max_no_heads;
		Dklabel.dkl_apc = ((ms_p3->trk_per_zone_hi << 8)
							+ ms_p3->trk_per_zone_lo)
							* Dklabel.dkl_nhead;
		Dklabel.dkl_acyl = ((ms_p3->alt_trk_per_vol_hi << 8)
							+ ms_p3->alt_trk_per_vol_lo)
							/ Dklabel.dkl_nhead;
		phy_cyl = (ms_p4->max_no_cyl_hi << 16)
				 + (ms_p4->max_no_cyl_mid << 8)
				 + ms_p4->max_no_cyl_lo;
#ifdef OS4
		Dklabel.dkl_pcyl = phy_cyl;
#endif
		Dklabel.dkl_ncyl = phy_cyl - Dklabel.dkl_acyl;
		Dklabel.dkl_intrlv = (ms_p3->interleave_value_hi << 8)
							+ ms_p3->interleave_value_lo;
		Dklabel.dkl_nsect = (ms_p3->sctr_per_trk_hi << 8)
						   + ms_p3->sctr_per_trk_lo;

		/* no of sec per cylinder */
		nos_cyl = Dklabel.dkl_nhead * Dklabel.dkl_nsect;
		if (Dklabel.dkl_nsect <= 0)
		{
			sprintf(line, "***ERROR*** in dkl_nsect\n");
			return(emsg(line));
		}
		if (Dklabel.dkl_nhead <= 0)
		{
			sprintf(line, "***ERROR*** in dkl_nhead\n");
			return(emsg(line));
		}
		if (nos_cyl <= 0)
		{
			sprintf(line, "***ERROR*** in no. of sec per cyl\n");
			return(emsg(line));
		}
/*
#define MB_TO_CYL(mb)		( (((mb)+1)*0x100000)/(512*nos_cyl) )
#define MB_TO_BLK(mb)		( (mb)*0x100000/512 )
#define CYL_TO_MB(cy)		( ((cy)*nos_cyl*512)/0x100000 )
#define BLK_TO_MB(blk)		( ((blk)*512)/0x100000 )
*/

#define CYL_TO_BLK(cy)		( (cy)*Dklabel.dkl_nhead*Dklabel.dkl_nsect )
#define BLK_TO_CYL(blk)		( ((blk)/Dklabel.dkl_nhead)/Dklabel.dkl_nsect )

		/* Partition a: ~20MB */
		dkl_Cyl[0] = 0;
		dkl_noCyl[0] = BLK_TO_CYL(39063) + 1;

		/* Partition b: ~30 MB */
		dkl_Cyl[1] = dkl_noCyl[0];
		dkl_noCyl[1] = BLK_TO_CYL(58594) + 1;

		/* Partition c: all avail cyls */
		dkl_Cyl[2] = 0;
		dkl_noCyl[2] = (capacity/nos_cyl) - 2;

		/* Partition g: all left-over cyls */
		dkl_Cyl[6] = dkl_Cyl[1] + dkl_noCyl[1];
		dkl_noCyl[6] = dkl_noCyl[2] - (dkl_noCyl[0] + dkl_noCyl[1]);

	}
	else	/* Existing label */
	{
		/*
		 * Check the checksum of the label
		 */
		sp = (short *)(&Dklabel);
		while (count--) 
			sum ^= *sp++;

		if(sum)
		{
			strcpy(line, Fname);
			strcat(line, " has invalid label checksum");
			emsg(line);
			line[0] = 'Y';
			if(get_fld(10, 20, "***INVALID LABEL CHECKSUM***  Use default label? ", line, 1, AT_NORMAL, GA_BOOL|GA_FILL) < 0)
			{
				return(emsg(Aborted));
			}
			if(line[0] == 'Y')
				goto mklabel;
		}
		nos_cyl = Dklabel.dkl_nhead * Dklabel.dkl_nsect;
		if (nos_cyl > 0)
		{
			dkl_Cyl[0] = Dklabel.dkl_map[0].dkl_cylno;
			dkl_Cyl[1] = Dklabel.dkl_map[1].dkl_cylno;
			dkl_Cyl[2] = Dklabel.dkl_map[2].dkl_cylno;
			dkl_Cyl[3] = Dklabel.dkl_map[3].dkl_cylno;
			dkl_Cyl[4] = Dklabel.dkl_map[4].dkl_cylno;
			dkl_Cyl[5] = Dklabel.dkl_map[5].dkl_cylno;
			dkl_Cyl[6] = Dklabel.dkl_map[6].dkl_cylno;
			dkl_Cyl[7] = Dklabel.dkl_map[7].dkl_cylno;
			dkl_noCyl[0] = BLK_TO_CYL(Dklabel.dkl_map[0].dkl_nblk);
			dkl_noCyl[1] = BLK_TO_CYL(Dklabel.dkl_map[1].dkl_nblk);
			dkl_noCyl[2] = BLK_TO_CYL(Dklabel.dkl_map[2].dkl_nblk);
			dkl_noCyl[3] = BLK_TO_CYL(Dklabel.dkl_map[3].dkl_nblk);
			dkl_noCyl[4] = BLK_TO_CYL(Dklabel.dkl_map[4].dkl_nblk);
			dkl_noCyl[5] = BLK_TO_CYL(Dklabel.dkl_map[5].dkl_nblk);
			dkl_noCyl[6] = BLK_TO_CYL(Dklabel.dkl_map[6].dkl_nblk);
			dkl_noCyl[7] = BLK_TO_CYL(Dklabel.dkl_map[7].dkl_nblk);
		}
		else
		{
			sprintf(line, "***ZERO Number of sectors per cyl!!!***\n");
			emsg(line);
			goto mklabel;
		}
	}

	if (get_pg(Olpdata) < 0)
		return(emsg(Aborted));
	/* update dkl_map */
	Dklabel.dkl_map[0].dkl_cylno = dkl_Cyl[0];
	Dklabel.dkl_map[1].dkl_cylno = dkl_Cyl[1];
	Dklabel.dkl_map[2].dkl_cylno = dkl_Cyl[2];
	Dklabel.dkl_map[3].dkl_cylno = dkl_Cyl[3];
	Dklabel.dkl_map[4].dkl_cylno = dkl_Cyl[4];
	Dklabel.dkl_map[5].dkl_cylno = dkl_Cyl[5];
	Dklabel.dkl_map[6].dkl_cylno = dkl_Cyl[6];
	Dklabel.dkl_map[7].dkl_cylno = dkl_Cyl[7];
	Dklabel.dkl_map[0].dkl_nblk = CYL_TO_BLK(dkl_noCyl[0]);
	Dklabel.dkl_map[1].dkl_nblk = CYL_TO_BLK(dkl_noCyl[1]);
	Dklabel.dkl_map[2].dkl_nblk = CYL_TO_BLK(dkl_noCyl[2]);
	Dklabel.dkl_map[3].dkl_nblk = CYL_TO_BLK(dkl_noCyl[3]);
	Dklabel.dkl_map[4].dkl_nblk = CYL_TO_BLK(dkl_noCyl[4]);
	Dklabel.dkl_map[5].dkl_nblk = CYL_TO_BLK(dkl_noCyl[5]);
	Dklabel.dkl_map[6].dkl_nblk = CYL_TO_BLK(dkl_noCyl[6]);
	Dklabel.dkl_map[7].dkl_nblk = CYL_TO_BLK(dkl_noCyl[7]);

	line[0] = 'N';

	if(get_fld(20, 12, "Write New Label?: ", line, 1, AT_NORMAL, GA_BOOL|GA_FILL) < 0)
	{
		return(emsg(Aborted));
	}
	if(line[0] != 'Y')
	{
		return(emsg(Aborted));
	}

	lseek(Ifd, 0, 0);			/* back to begining	*/
	Dklabel.dkl_magic = DKL_MAGIC;		/* Force MAGIC	*/
	count = sizeof(struct dk_label)/sizeof(short);

	/*
	 * Generate the checksum of the label
	 */

	sp = (short *)(&Dklabel);
	sum = 0;
	while (--count) 
		sum ^= *sp++;

	*sp = sum;

	if( write(Ifd, &Dklabel, sizeof(struct dk_label) ) <  0)
	{
		sprintf(line, "***ERROR in writing disk label: %s\n", sys_errlist[errno]);
		return(emsg(line));
	}

	lseek(Ifd, 0, 0);		/* back to begining	*/
	if(ioctl(Ifd, VJIOSLABEL, 0) < 0)
	{
		sprintf(line, "***ERROR: Illegal disk label: %s\n", sys_errlist[errno]);
		return(emsg(line));
	}

	return(emsg("New Label Installed"));
}

rsgnblk()
{
struct dk_conf diskconf;
char line[81], s[81];
int x, port, id;
int flag = 1;
long start;

	strcpy(line, "Reassign a Disk Defective Block on Device: ");
	strcat(line, Fname);
	cls();
	winwrite(line, 1, -1, AT_NORMAL);
	winwrite("< Press <ESC> to ABORT >", STATLINE, -1, AT_NORMAL);
	if(ioctl(Ifd, DKIOCGCONF, &diskconf) < 0)
	{
        sprintf(line, "***ERROR*** in disk block reassigning: %s", sys_errlist[errno]);
		emsg(line);
		return;
	}
	strcpy(line, "Jaguar SCSI Port: ");
	port = diskconf.dkc_slave & M_UNIT_BUS ? 1 : 0;
	itoa(port, s);
	strcat(line, s);
	strcat(line, "   SCSI Id: ");
	id = (diskconf.dkc_slave >> 3) & 07;
	itoa(id, s);
	strcat(line, s);
	winwrite(line, 3, -1, AT_NORMAL);

	x = 0;
	if(get_fld(6, 20, "Defective Block Number? ", (char *)&x, 8, AT_NORMAL, GA_INT|GA_FILL) < 0)
	{
		emsg(Aborted);
		return;
	}

	start = x * 512;
	lseek (Ifd, 0L, 0);
	lseek (Ifd, start, L_SET);
	if( read(Ifd, scansavebuf, 512 ) <  0)
	{
		sprintf(s, "Cannot save defective block data");
		winwrite(s, 8, 20, AT_NORMAL);
		flag = 0;
	}

	sprintf(s, "Reassign Defective Block %d? ", x);
	line[0] = 'Y';
	if(get_fld(10, 20, s, line, 1, AT_NORMAL, GA_BOOL|GA_FILL) < 0)
	{
		emsg(Aborted);
		return;
	}
	if(line[0] != 'Y')
	{
		emsg(Aborted);
		return;
	}
	scsi_rsgnblk.rd_len_msb = 0;
	scsi_rsgnblk.rd_len_lsb = 4;	/* only 1 defect blk */
	scsi_rsgnblk.rd_blk_addr_3 = (x >> 24) & 0xff;
	scsi_rsgnblk.rd_blk_addr_2 = (x >> 16) & 0xff;
	scsi_rsgnblk.rd_blk_addr_1 = (x >> 8) & 0xff;
	scsi_rsgnblk.rd_blk_addr_0 = x & 0xff;
	if(ioctl(Ifd, VJIORSGNBLK, (char *)&scsi_rsgnblk) < 0)
	{
		sprintf(line, "***ERROR*** in reassign blk cmd: %s\n", sys_errlist[errno]);
		emsg(line);
		return;
	}

	lseek (Ifd, 0L, 0);
	lseek (Ifd, start, L_SET);
	if (flag)
	{
		if( write(Ifd, scansavebuf, 512 ) <  0)
		{
			sprintf(s, "Cannot restore defective block data");
			winwrite(s, 12, 20, AT_NORMAL);
		}
	}

	sprintf(line, "Completed Reassigning Disk Block %7d   ", x);
	emsg(line);
	return;
}

emsg(arg)
char *arg;
{
	msg(arg);
	Popped = 0;
}
notdone()
{
	return(emsg("This function is not implemented yet"));
}
ipdheader()
{
	cls();
	winwrite("Interphase Corporation V4210 Jaguar Disk Utility V1.1", 1,
	 -1, AT_NORMAL);
	winwrite("Copyright(C) 1988", 2, -1, AT_NORMAL);
}

/*
 *	The followings are from K&R pp. 59-60
 */
reverse(s)	/* reverse string s in place */
char s[];
{
	int c, i, j;

	for (i=0, j=strlen(s)-1; i<j; i++, j--)
	{
		c = s[i];
		s[i] = s[j];
		s[j] = c;
	}
}
itoa(n, s)	/* convert n to characters in s */
char s[];
int n;
{
	int i, sign;

	if ((sign = n) < 0)
		n = -n;
	i = 0;
	do
	{
		s[i++] = n % 10 + '0';
	} while ((n /= 10) > 0);
	if (sign < 0)
		s[i++] = '-';
	s[i] = '\0';
	reverse(s);
}
