
                    		// G06A.BCPL - GRAPHICS SYSTEM 06

			//** Translated roughly from BCPL by bcpl2c.pl, 9/27/2005

                    		// Modified August 14, 1979

                 		// BLDR/U/L/V YOURS/S G06AC/I YOURS G06A G06B G06C G06D I01 I02


#include "G06DEFS.H"
#include "IOX.H"
#include "FREEDEFS.H"


			word FIELDMODE = BOTHFIELDS;

            VALTRANS *VALTRANSTAB = NULL;

            word AREAYMAX = PMYTOP;
            word AREAYMIN = PMYBOT;
            word AREAXMAX = PMXRIGHT;
            word AREAXMIN = PMXLEFT;
            WIN *PMWINDOW = NULL;



	 	    G06A_PROG() { }


                       		// ---- PICTURE MEMORY ROUTINES

                       		// RUNTABSTOPM: WRITE PM FROM RUN TABLES
                       		// 1/18/75

            void RUNTABSTOPM(N,WN,RUNTABS,NUMTABS,MODE,XTAB,UPXTAB)
				WIN WN; RUNCODE *RUNTABS; word *XTAB;
             {/*R*/ 
              word X = WN.XORIG-WN.XOFF;
              word Y = WN.YORIG-WN.YOFF;
              word W = WN.W;
              word H = WN.H, OLDH=H, OLDYOFF=WN.YOFF, D, I, J, XST, R, XND;
			  RUNCODE *CLIPTAB; word *XTBLK, *NEWXTAB;

              if ((H == 0 || W == 0)) return; 

              		// OUTSIDE SCREEN WIN
              if ((Y > AREAYMAX) || (X > AREAXMAX)
              || ((Y+H) <= AREAYMIN) || ((X+W) <= AREAXMIN))
                 return; 

              CLIPTAB = GETBLOCKX(H);
              switch (N) {
              case 3: MODE = BOTHQ;
              case 4: XTAB = GETBLOCKX(H);
                 STUFFVEC(2,XTAB,H);
                 break;
              case 5: UPXTAB = FALSE;
              case 6:
               if (!UPXTAB) { 
	   			 NEWXTAB = GETBLOCKX(H);
                 for (I=0; I<=H-1; I++) NEWXTAB[I] = XTAB[I];
                 XTAB = NEWXTAB; 
				}
                 break;
              default: ERROR(2,"RUNTABSTOPM",0); };
              XTBLK = XTAB;

              		// CLIP AT TOP & BOTTOM OF SCREEN WIN
              if ((Y < AREAYMIN)) {
                   D = AREAYMIN-Y;
                   H = H-D;
                   Y = AREAYMIN;
                   WN.YOFF = WN.YOFF-D;
                   XTAB = XTAB+D;
                   RUNTABS = RUNTABS+D; 
			 }
               if (!((Y+H-1) <= AREAYMAX)) H = AREAYMAX-Y+1;
               WN.H = H;


               SETWRRUNS(WN,MODE);
               		//LEFT AND RIGHT CLIPPING
               XST=NULL; R=NULL; XND=NULL;

               for (I=0; I<=NUMTABS-1; I++)
                 {/*FRAME*/ 
				   for (J=0; J<=H-1; J++) {
                     XST = X + XTAB[J];
                     R = RUNTABS[J].RUN;
                     if (R < 1) { CLIPTAB[J] = RUNTABS[J]; continue; }
                     XND = XST+R-1;
                     if ((XST > AREAXMAX) || (XND < AREAXMIN))
                          { XTAB[J] = XTAB[J] + R; CLIPTAB[J].RUN = 0; continue; }
                     else CLIPTAB[J] = RUNTABS[J];
                     if (XST < AREAXMIN)
                          { XTAB[J] = AREAXMIN-X;
                          XST = AREAXMIN;
                          CLIPTAB[J].RUN = XND-AREAXMIN +1; }
                     if (!(XND <= AREAXMAX))
                          CLIPTAB[J].RUN = AREAXMAX-XST+1;
                        }
                   if (!(FIELDMODE == FIELD0ONLY)) WRITERUNS(XTAB,CLIPTAB,1);
                   if (!(FIELDMODE == FIELD1ONLY)) WRITERUNS(XTAB,CLIPTAB,0);
                   RUNTABS=RUNTABS+OLDH;   }/*FRAME*/ 

               WN.YOFF = OLDYOFF;
               WN.H = OLDH;
               if ((N <= 4) || (!UPXTAB)) PUTBLOCK(XTBLK);
               PUTBLOCK(CLIPTAB);
               }/*R*/ 


                          		// PMTORUNTABS: READ PM TO RUN TABLES
                          		// RESULT IS NUMBER OF TABLES READ
                          		// 1/18/75

         word PMTORUNTABS(N,WN,RUNTABS,NUMTABS,MODE,XTAB,UPXTAB)
 				WIN WN; RUNCODE *RUNTABS; word *XTAB;
             {/*PM*/ 
               word BUSY0=0,BUSY1=0,NTREAD=0;
               word XOFF = WN.XOFF;
               word YOFF = WN.YOFF;
               word X = WN.XORIG-XOFF;
               word Y = WN.YORIG-YOFF;
               word H = WN.H;
               word W = WN.W;
               word OLDH = H, D, I;
			   word *XTBLK, *NEWXTAB; 
			   WIN NUWIN;
               if ((H == 0) || (W == 0)) return (0);

               		//OUTSIDE SCREEN WIN
               if ((Y > AREAYMAX) || (X > AREAXMAX)
               || ((Y + H) <= AREAYMIN) || ((X + W) <= AREAXMIN))
                   return (0);

               switch (N) {
               case 3: MODE = BOTHQ;
               case 4: XTAB = GETBLOCKX(H);
                   STUFFVEC(2,XTAB,H);
                   break;
               case 5: UPXTAB = FALSE;
               case 6:
                if (!UPXTAB)
                 { NEWXTAB = GETBLOCKX(H);
                   for (I=0; I<=H-1; I++) NEWXTAB[I] = XTAB[I];
				   XTAB = NEWXTAB; }
				   break;
   default: ERROR(2,"PMTORUNTABS",0); };
   XTBLK = XTAB;

   		//CLIP AT TOP & BOTTOM OF SCREEN WINDOW
   for (I=0; I<=NUMTABS*H-1; I++) RUNTABS[I].RUN = 0;
   if (Y < AREAYMIN) {
      D = AREAYMIN-Y;
      H = H-D;
      Y = AREAYMIN;
      YOFF = YOFF-D;
      XTAB = XTAB+D;
      RUNTABS = RUNTABS+D; }
   if (!((Y+H-1) <= AREAYMAX)) H = AREAYMAX-Y+1;

   		//CLIP AT LEFT SIDE OF SCREEN WIN
   if (X < AREAXMIN) {
      D = AREAXMIN-X;
      for (I=0; I<=H-1; I++) XTAB[I] = XTAB[I]+D;
      W = W-D;
      X = AREAXMIN;
      XOFF = XOFF-D;
             }
   		//CLIP AT RIGHT SIDE OF SCREEN WIN
   if ((X+W-1) > AREAXMAX) W = AREAXMAX-X+1;
   FILLWIN(7,&NUWIN,X + XOFF,Y + YOFF,W,H,XOFF,YOFF);
   SETWRRUNS(NUWIN,MODE);

   for (I=0; I<=NUMTABS-1; I++)
     {/*FRAME*/ 
      BUSY1 = READRUNS(XTAB,RUNTABS,1);
      BUSY0 = READRUNS(XTAB,RUNTABS,0);
      if (!(BUSY1 || BUSY0)) break;
      NTREAD = NTREAD+1;
      RUNTABS = RUNTABS + OLDH; 
		 }/*FRAME*/ 

   if ((N <= 4) || (!UPXTAB)) PUTBLOCK(XTBLK);	// ?? 9/05 rgs
   return (NTREAD);
                       }/*PM*/ 


             		//FILL XREL TABLE FROM RUN TABLES
             		//  3/6/74

void FILLXTAB(WN,RUNTABS,NUMTABS,XTAB)
	 WIN *WN; RUNCODE *RUNTABS; word *XTAB;
 {/*FILL*/ 
   word H = WN->H, I, J, K, L, L2, S;

   for (I=0; I<=H-1; I++) {
      XTAB[I]=0;
      K=0; J=I;
      do { if (VALTRANSTAB[RUNTABS[J].VALUE].ISNULL)
         XTAB[I] = XTAB[I] + (RUNTABS[J].RUN);
         else break;
      K=K+1; J=J+H; } while (K < NUMTABS);
      S=H*K; L2=I;
      if (K > 0) for (L=1; L<=NUMTABS; L++) {
		 if (L <= (NUMTABS-K)) RUNTABS[L2] = RUNTABS[L2+S];
		 else RUNTABS[L2].RUN = 0;
         L2=L2+H; }
      }
   }/*FILL*/ 


void PMLINE(VALUE,OLDPOS,NEWPOS,MODE)
		POS OLDPOS, NEWPOS;
			{
               word X1 = OLDPOS.X, Y1 = OLDPOS.Y;
               word X2 = NEWPOS.X, Y2 = NEWPOS.Y;
		       word X,Y,DY,DX,*XT,T,I;
			   WIN W; RUNCODE *RT;

			   if (X1==X2 && Y1==Y2) return;
               if (Y1 > Y2)
                { Y = Y1; Y1 = Y2; Y2 = Y;
                  X = X1; X1 = X2; X2 = X; }

               DY = Y2-Y1; DX = X2-X1;
               FLDI(3,((DX == 0) ? 0:((DX > 0) ? DX+1:DX-1)));
               FLDI(4,((DY == 0) ? 0:((DY > 0) ? DY+1:DY-1)));
               if (DY != 0) FDV(3,4);
               DX = ABSVAL(DX);
               FLDI(2,((X2 > X1) ? 0:DX));

               RT = GETBLOCKX(DY+2);
               XT = GETBLOCKX(DY+2);
               FILLWIN(7,&W,MIN(X1,X2),Y1,DX+2,DY+2,0,0);

               for (I=0; I<=DY; I++) {
                  T = FTR(2); FAD(2,3); XT[I] = MIN(T,FTR(2));
				  if (XT[I]<0) XT[I] = 0;				// 9/05 rgs
                  RT[I].RUN = ABSVAL(FTR(2)-T)+1;
                  RT[I].VALUE = VALUE;
			 }
               RUNTABSTOPM(5,W,RT,1,MODE,XT);
               PUTBLOCK(RT);
               PUTBLOCK(XT);
                          }

                          		// READ BEGINNING OF POINT ARRAY FILE

          word READBEGPAF(N,pF,pW,LVFORMAT,LVNTABS,COLORTAB,LVNUMVALS,ALTCMAP,LVNUMALTVALS,LVANMODE,LVANSPEED,LVNUMFRAMES,CHAN,CHANTABS)
				FILE *pF; WIN *pW; COLOR *COLORTAB, *ALTCMAP; 
				word *LVFORMAT, *LVNTABS; void *CHAN, *CHANTABS; 
				word *LVNUMVALS, *LVNUMALTVALS, *LVANMODE, *LVANSPEED, *LVNUMFRAMES;
            {/*RB*/ 
               PAFH FH; word T=0,NV,NAV,I,NR;

               SETPOS(pF,0);
               NR = READSEQ(pF,(char*)&FH,2*PAFHLEN); 	// FILE OPENED BY CALLER
			   swapbytes(&FH,PAFHLEN);

               if (FH.FID != PAFID) {
                  if ((((word*)&FH)[0] <= 640) && (((word*)&FH)[1] <= 808))
                     {                          		// FLEGAL SMALLTALK FORMAT:
                                                        		// WIDTH,HEIGHT,BITSI
                          FILLWIN(7,pW,PMXMID,PMYMID,((char*)&FH)[0],((char*)&FH)[1],((char*)&FH)[0]/2,((char*)&FH)[1]/2);
                          if (N >= 3) *LVFORMAT=9;
                          if (N >= 6) *LVNUMVALS=0;
                          SETPOS(pF,4);
                          return (Q1); }
                     else ERROR(2,"READBEGPAF",1);
				}
               SETPOS(pF,2*FH.WINDOW);
               NR = READSEQ(pF,pW,2*WINLEN);
			   swapbytes(pW,WINLEN);
               if (FH.VINTAGE < 2) {
                  T = pW->YORIG; pW->YORIG = pW->XORIG; pW->XORIG = T;
                  T = pW->H; pW->H = pW->W; pW->W = T;
                  T = pW->YOFF; pW->YOFF = pW->XOFF; pW->XOFF = T;
                  }
               if ((N > 4) && (COLORTAB != NULL)) {
                  SETPOS(pF,2*FH.COLORTABPTR);
                  NV = FH.NUMVALS;
                  NR = READSEQ(pF,(char*)COLORTAB,2*NV*COLORLEN);
				  swapbytes(COLORTAB,NV*COLORLEN);
                  *LVNUMVALS = NV;
                  if (FH.VINTAGE < 1) {
					  for (I=0; I<=NV*COLORLEN-1; I++) {
						 if ((I & 3) != 0) ((word*)COLORTAB)[I] = ((word*)COLORTAB)[I] >> 2; } }
                  for (I=0; I<=NV*COLORLEN-1; I++) 
									((word*)COLORTAB)[I] = ((word*)COLORTAB)[I] & COLORPRIMASK;
                                           }
               if ((N > 6) && (ALTCMAP != NULL)) {
                  SETPOS(pF,2*FH.ALTCTABPTR);
                  NAV = FH.NUMALTVALS;
                  READSEQ(pF,(char*)ALTCMAP,2*NAV*COLORLEN);
				  swapbytes(ALTCMAP,NAV*COLORLEN);
                  *LVNUMALTVALS = NAV;
                  if (FH.VINTAGE < 1) {
					  for (I=0; I<=NAV*COLORLEN-1; I++) {
					     if (!(I & 3) == 0) ((word*)ALTCMAP)[I] = ((word*)ALTCMAP)[I] >> 2; } }
                  for (I=0; I<=NAV*COLORLEN-1; I++) 
									((word*)COLORTAB)[I] = ((word*)COLORTAB)[I] & COLORPRIMASK;
                                         }
               if (N >= 10) {
                  *LVANMODE = 0;
                  *LVANSPEED = 0;
                  if (FH.VINTAGE > 2) {
                     *LVANMODE = FH.ANMODE;
                     *LVANSPEED = FH.ANSPEED;
                                  }
                               }

               if ((N >= 13) && (FH.VINTAGE > 2)) {
                  SETPOS(pF,2*FH.CHANPTR);
                  READSEQ(pF,CHAN,2*(FH.NUMFRAMES+1));
				  swapbytes(CHAN,FH.NUMFRAMES+1);
                  SETPOS(pF,2*FH.CHANTABPTR);
                  READSEQ(pF,CHANTABS,1024*(FH.NUMFRAMES+1));  		// 2*256*2
				  swapbytes(CHANTABS,512*(FH.NUMFRAMES+1));
                  *LVNUMFRAMES = FH.NUMFRAMES;
                                     }
               if (N > 3) *LVNTABS = FH.NUMTABS;

               if (N > 2) *LVFORMAT = FH.FORMAT;

               SETPOS(pF,2*FH.DATAPTR);
               return (FH.MODE);
                           }/*RB*/ 


       void WRBEGPAF(N,pF,W,FORMAT,ANMODE,ANSPEED,NUMFRAMES,CHAN,CHANTABS)
				FILE *pF; WIN W; void *CHAN, *CHANTABS;
              {/*WR*/ 
               PAFH FH; word P;

               STUFFVEC(2,&FH,PAFHLEN);
               FH.FID = PAFID;
               FH.WINDOW = PAFHLEN;
               FH.COLORTABPTR = PAFHLEN + WINLEN;
               FH.NUMVALS = 0;
               FH.ALTCTABPTR = PAFHLEN + WINLEN + 128*COLORLEN;
               FH.NUMALTVALS = 0;
               FH.VINTAGE = CURPAFHVINTAGE;
               FH.FORMAT = FORMAT;
               if (N >= 5) {
                  FH.ANMODE = ANMODE;
                  FH.ANSPEED = ANSPEED;
					 }
               P = PAFHLEN + WINLEN + 256*COLORLEN;
               if ((N >= 8) && (NUMFRAMES > 0)) {
                  FH.NUMFRAMES = NUMFRAMES;
                  FH.CHANPTR = P;
                  FH.CHANTABPTR = P+NUMFRAMES+1;
                  P = P+NUMFRAMES+1+512*(NUMFRAMES+1);   		// 256*2
                               }
               FH.DATAPTR = P;

               SETPOS(pF,0);
			   swapbytes(&FH,PAFHLEN);
               WRITESEQ(pF,(char*)&FH,2*PAFHLEN);
			   swapbytes(&FH,PAFHLEN);

			   swapbytes(&W,WINLEN);
               WRITESEQ(pF,(char*)&W,2*WINLEN);
			   swapbytes(&W,WINLEN);

               if ((N >= 8) && (NUMFRAMES > 0)) {
                  SETPOS(pF,2*FH.CHANPTR);
			      swapbytes(CHAN,NUMFRAMES+1);
                  WRITESEQ(pF,CHAN,2*(NUMFRAMES+1));
			      swapbytes(CHAN,NUMFRAMES+1);
			      swapbytes(CHANTABS,512*(NUMFRAMES+1));
                  WRITESEQ(pF,CHANTABS,1024*(NUMFRAMES+1)); 	// 2*256*2
			      swapbytes(CHANTABS,512*(NUMFRAMES+1));
                           }
               SETPOS(pF,2*FH.DATAPTR);
                        }/*WR*/ 



 word READENDPAF(pF)
	 FILE *pF;
 {/*R*/ 
   word N = 0;
   SETPOS(pF,offsetof(PAFH,NUMTABS));
   READSEQ(pF,(char*)&N,2);
   swapbytes(&N,1);
   return (N);
 }/*R*/ 


void WRENDPAF(N,pF,MODE,NUMTABS,COLORTAB,NUMVALS,ALTCMAP,NUMALTVALS)
	 FILE *pF; COLOR *COLORTAB, *ALTCMAP;
 {/*WR*/ 
   SETPOS(pF,offsetof(PAFH,MODE));
   swapbytes(&MODE,1);
   WRITESEQ(pF,(char*)&MODE,2);
   swapbytes(&MODE,1);

   SETPOS(pF,offsetof(PAFH,NUMVALS));   
   swapbytes(&NUMVALS,1);
   WRITESEQ(pF,(char*)&NUMVALS,2);
   swapbytes(&NUMVALS,1);

   if ((N > 5) && (ALTCMAP != NULL))
   { SETPOS(pF,offsetof(PAFH,NUMALTVALS));
   swapbytes(&NUMALTVALS,1);
   WRITESEQ(pF,(char*)&NUMALTVALS,2);
   swapbytes(&NUMALTVALS,1); }

   SETPOS(pF,offsetof(PAFH,NUMTABS));
   swapbytes(&NUMTABS,1);
   WRITESEQ(pF,(char*)&NUMTABS,2);
   swapbytes(&NUMTABS,1);

   if (NUMVALS > 0)
   { SETPOS(pF,2*(PAFHLEN + WINLEN));
   swapbytes(COLORTAB,NUMVALS*COLORLEN);
   WRITESEQ(pF,COLORTAB,2*NUMVALS*COLORLEN);
   swapbytes(COLORTAB,NUMVALS*COLORLEN); }

   if ((N > 5) && (ALTCMAP > 0))
   { SETPOS(pF,2*(PAFHLEN+WINLEN+128*COLORLEN));
   swapbytes(ALTCMAP,NUMALTVALS*COLORLEN);
   WRITESEQ(pF,ALTCMAP,2*NUMALTVALS*COLORLEN);
   swapbytes(ALTCMAP,NUMALTVALS*COLORLEN); }
                  }/*WR*/ 


 void RUNTABSTOPAF(pF,W,RUNTABS,NUMTABS)
	 FILE *pF; WIN W; RUNCODE *RUNTABS;
 { 
	WRITESEQ(pF,RUNTABS,2*NUMTABS*W.H); 
 }

 word PAFTORUNTABS(pF,W,RUNTABS,NUMTABS)
	 FILE *pF; WIN W; RUNCODE *RUNTABS;
 { 
	word N;
	N = READSEQ(pF,RUNTABS,2*NUMTABS*W.H);
	return (N/(2*W.H));
 }

 void PTSTOPAF(pF,W,TAB,NTABS,FORMAT)
	FILE *pF; WIN W; void *TAB;
 {
	word n;
	switch (FORMAT) {
         case 2: n=(W.H+3)/4;
         case 3: n=(W.H+1)/2;
         default: n=0;        }
      WRITESEQ(pF,TAB,2*NTABS*n);
               }

 void PAFTOPTS(pF,W,TAB,NTABS,FORMAT)
	FILE *pF; WIN W; void *TAB;
 {
	word n;
	switch (FORMAT) {
         case 2: n=(W.H+3)/4;
         case 3: n=(W.H+1)/2;
         default: n=0;        }
      READSEQ(pF,TAB,2*NTABS*n);
               }

 word READPAF(pF,B,NWORDS) 
	FILE *pF; void *B;
 {
	word N;
    N = READSEQ(pF,B,2*NWORDS);
	swapbytes(B,NWORDS);
	return (N/2);
               }


