
		/* G06 & SP tests */


#include <windows.h>
#include "G06DEFS.H"
#include "IOX.H"
#include "MyDefs.h"

void MyTests() {
	WIN W; RUNCODE Rt[256]; COLOR Ct[256];
	int x,y,i; 
	word Xt[256]; 
	
//	WrFBPix(BOTHQ,0,0,2);					/* pixel in LL corner */
//	WrFBPix(BOTHQ,PMWIDTH-1,0,2);			/* pixel in LR corner */
//	WrFBPix(BOTHQ,0,PMHEIGHT-1,2);			/* pixel in UL corner */
//	WrFBPix(BOTHQ,PMWIDTH-1,PMHEIGHT-1,2);	/* pixel in UR corner */


	FILLWIN(7,&W,200,100,256,256,0,0);
	SETWRRUNS(W, BOTHQ);
#define ns 4
#define sz 64
	for (i=0; i<ns*sz; i++) Xt[i] = 0;

	for (x=0; x<ns; x++) {
		for (y=0; y<ns; y++) {
			for (i=0; i<sz; i++) {
				Rt[y*sz+i].VALUE = y*ns+x; Rt[y*sz+i].RUN = sz;
			}
		}
		WRITERUNS(Xt, Rt, -1);
	}

#if 1
#define nc 16
	for (i=0; i<nc; i++) { 
		Ct[i].VALUE = i; 
		Ct[i].RED = i<<4 & 0x80; 
		Ct[i].GREEN = i<<5 & 0x80; 
		Ct[i].BLUE = i<<6 & 0xc0;
	}
	SETCOLORMAP(Ct, nc);
#else
#define nc 256
	for (i=0; i<nc; i++) { 
		Ct[i].VALUE = i; 
		Ct[i].RED = i; 
		Ct[i].GREEN = i; 
		Ct[i].BLUE = i;
	}
	SETCOLORMAP(Ct, nc);
#endif

	if (SPMode==3 || strstr(CmdLine,"/G")) 
		G06U_PROG(1,TRUE); 		// getpic, repeat
	else 
		SPA_PROG();				// main program

}


void CyColors() {		/* test CMap by cycling colors */
	RGBQUAD t; int i;

	t = MyCMap[0];
	for (i=0; i<nMColors-1; i++) MyCMap[i] = MyCMap[i+1];
	MyCMap[nMColors-1] = t;
}

void RampPix() {		/* test FB with ramp of pixels */
	int x, y;

	for (y=0; y<FBHeight; y++) 
	for (x=0; x<FBWidth; x++) {
		MyPix[y][x] = (x&0xf<<4) | (y&0xf);
	}
}

void RampColors() {		/* test CMap with ramp of colors */
	int i;

	for (i=0; i<nMColors; i++) {
		MyCMap[i].rgbBlue = i;
		MyCMap[i].rgbGreen = i;
		MyCMap[i].rgbRed = i;
	}
}


void fixitworks() {		/* fix the 'itworks' picture */
	int x,y; word v,vo,vl,v0,v1,v2,vmax=0;
#define xs FBWidth
#define ys FBHeight
#define L0 MyPix[y+2]
#define L1 MyPix[y+1]
#define L2 MyPix[y]

	for (y=ys-3; y>=0; y--) {
		vo= -16; vl=L2[0];
		for (x=0; x<xs; x++) {
			v=L2[x];

			if (vo==0)
				{
				if ((vl&0xf)>0xb && v-vl>16 ||
					(vl&0xf)<0x4 && v-vl>10) vo= -16;
				}
			else 
				{
				if ((vl&0xf)<0x4 && vl-v>16 ||
					(vl&0xf)>0xb && vl-v>10) vo=0;
				}

			if (0 && (y&0xff)==0) 
				printf("%x %x : %x %x    %d %d : %d %d %d\n",
					x,y,v,v+vo,x,y,v,v+vo,vo);
			L2[x]=v+vo; 
			vl=v; if (v+vo>vmax) vmax = v+vo;

#if 1
							/* vert filter prev line */
			v0=L0[x]; v1=L1[x]; v2=L2[x];
			if (abs(v1-v0)>10 && abs(v0-v2)<6) 
				{ v=v0+v2>>1; L1[x]=v; }
#endif
		}
	MyUpdate(CanvFB);
	}

	for (y=0; y<ys; y++) {		// contrast stretch
		for (x=0; x<xs; x++) { 
			v = MyPix[y][x]; 
			MyPix[y][x] = min(2*v,255);
		}
	MyUpdate(CanvFB);
	}

}

