
                         		// SPC.BCPL - SUPERPAINT C

			//** Translated roughly from BCPL by bcpl2c.pl, 10/4/2005
                            		// 1/21/75 RGS
                            		// modified August 15, 1979

#include "G06DEFS.H"
#include "IOX.H"
#include "FREEDEFS.H"
#include "SPDEFS.H"

void BRUSHSTROKE();
int  NEXTCYNUM();
void INTERPCOLOR();
void COLORFIX();


void SPC_PROG() { }



            void MAKEBRUSH() 
              {
			   WIN W; POS P1,P2; FILE *CH; int I;

               WRITEFORM(1,0,"NEW BRUSH");
               WRITEFORM(1,0,"SPECIFY A WINDOW AROUND YOUR BRUSH");
               TABGRID = 0;
               if (!GETWINDOW(2,&W,OVQ1)) return;
               DELETEFILE("$$$TEMP");
               CREATEFILE("$$$TEMP");
               CH = OPEN("$$$TEMP");
               PMTOPAF(3,CH,W,Q1);
               CLOSE(CH);
               SETPIC(0);
               WRITEFORM(1,0,"SPECIFY WHICH BRUSH TO REPLACE");
               TABLETSTROKE(4,&P1,&P2,OVQ0,OVQ0);

               switch (FINDMENU(P1,BRUSHWIN,1)) {
                 case 0: I = (P1.X-BRUSHWIN->XORIG)/BRUSHW;
                     break;
                  default: WRITEFORM(1,0,"NO BRUSH REPLACED");
                     return; }

               CLEARPM(3,TRANSPARENT,*BRWIN[I],Q0);
               PUTBLOCK(BRWIN[I]);
               PUTBLOCK(BRRUNTABS[I]);
               PUTBLOCK(BRXTABS[I]);
               GETBRUSH("$$$TEMP",I);
               DELETEFILE("$$$TEMP");
               CLEARPM(3,TRANSPARENT,*BRUSHWIN,Q0);
               DISPBRUSHES();
               BR = I;
               SETBRUSHSEL();
                         }


            void TYPECOLOR() 
              {
				POS P, P1; COLOR C;

               WRITEFORM(1,0," X,Y  VALUE  RED,GREEN,BLUE");
               TABGRID = GRID;

			   do { TABLETSTROKE(4,&P,&P1,OVQ1 ,OVQ1);
                  switch (FINDMENU(P,DEFMENU,DEFMENULEN)) 
                   { default:
                     case 0:
                     case 1: return;
                     case 2: break; }
                  C.VALUE = RPMPOINT(P,Q1);
                  READCOLORMAP(&C,1);
                  WRITEFORM(4,10,P.X,0,",",10,P.Y,0," ");
                  WRITEFORM(-2,10,C.VALUE,0,"  ");
                  WRITEFORM(-7,0,"  ",10,C.RED,0,",",10,C.GREEN,0,",",10,C.BLUE,0,"");
			 } while (1);
					  }


            void DRAWLINE() 
              {/*DR*/ 
				POS P1, P2; PENSTAT S; int BEG=TRUE;

               WRITEFORM(1,0,"DRAW LINES");
               TABGRID = GRID;

			   do {/*L*/ 
                   TABLETTRACK(4,&P2,&S,OVQ1,OVQ1);
                   if (!S.PROX) BEG = TRUE;
                   else
                         switch (FINDMENU(P2,DEFMENU,DEFMENULEN)) {/*C*/ 
                            default:
                            case 0:
                            case 1: if (S.PUSH) return;
                                    BEG = TRUE; continue;
                            case 2: if (S.PUSH)
                               { if (BEG) BEG = FALSE;
                                 else BRUSHSTROKE(PAINTVAL,P1,P2,Q1);
                                 P1.Y = P2.Y;
                                 P1.X = P2.X; }
							  else if (!BEG) PMLINE(PAINTVAL,P1,P2,OVQ1);
                                 break;           }/*C*/ 
                               }/*L*/ while (1);
            }/*DR*/ 


            void BRUSHSTROKE(PAINTVAL,P1,P2,MODE) 
				POS P1, P2;
			{
               word DX=P2.X-P1.X, DY=P2.Y-P1.Y, D=0, DF=0; WIN *BW;
               word YINC=(DY==0 ? 0:(DY>0 ? 1:-1)), XINC=(DX==0 ? 0:(DX>0 ? 1:-1));

               SETVALTRANSTAB(2,TRANSPARENT,-1);
               SETVALTRANSTAB(2,BRUSHVAL,PAINTVAL);
               BW = BRWIN[BR];
               BW->YORIG = P1.Y; BW->XORIG = P1.X;
               FLDI(1,ABSVAL(DX)+1); FLDI(2,ABSVAL(DY)+1); FLDI(3,0x1000);

               if (!(DX == 0 && DY == 0)) {/*G*/ 
               if (FCM(1,2) >= 0)
                   { FDV(2,1); FML(2,3);
                      DF = FTR(2);
                      do {/*L*/ 
					  RUNTABSTOPM(5,*BW,BRRUNTABS[BR],BRNUMTABS[BR],MODE,BRXTABS[BR]);
                      BW->XORIG = BW->XORIG+XINC;
                      DX = P2.X-BW->XORIG;
                      D = D+DF;
                      if ((D & 0x1000) != 0) {
                         D = D & ~0xf000;
                         BW->YORIG = BW->YORIG+YINC;
                         DY = P2.Y-BW->YORIG; }
                               }/*L*/ while (DX != 0 || DY != 0);
					}
               else 
					{ FDV(1,2); FML(1,3); DF = FTR(1);
                      do {/*L*/ 
					  RUNTABSTOPM(5,*BW,BRRUNTABS[BR],BRNUMTABS[BR],MODE,BRXTABS[BR]);
                      BW->YORIG = BW->YORIG+YINC;
                      DY = P2.Y-BW->YORIG;
                      D = D+DF;
                      if ((D & 0x1000) != 0) {
                         D = D & ~0xf000;
                         BW->XORIG = BW->XORIG+XINC;
                         DX = P2.X-BW->XORIG; }
                               }/*L*/ while (DX != 0 || DY != 0);
					}
				 }/*G*/ 
               SETVALTRANSTAB(1,TRANSPARENT);
               SETVALTRANSTAB(2,BRUSHVAL,BRUSHVAL);
                      }


            void CYCOLORS(MODE) {/*CY*/ 
				POS P; PENSTAT S; COLOR C[16]; int I;

               WRITEFORM(1,0,"CYCLE COLORS");
               if (CYRUNSW)
                   { CYRUNSW= FALSE; CYMODE=0; WRITEFORM(1,0," OFF"); }
               else {/*N*/ 
					  WRITEFORM(1,0,"SET SPEED WITH TABLET X POSITION");
                      WRITEFORM(3,0,"CYCLE SPEED = ",10,CYSPEED/2,0,"...");
                      CYRUNSW = FALSE; CYMODE = MODE; INITCY();

                     READCOLORMAP(MCMAP,16);
                     for (I=0; I<=63; I++) ((word*)MCMAP)[I] = ((word*)MCMAP)[I] & COLORPRIMASK;
                     READCOLORMAP(&C,16);
                     TABGRID = 0;
                     do READTABLET(&P,&S); while (S.DOWN);

					 do {/*L1*/ if (S.PUSH) {
                          switch (FINDMENU(P,DEFMENU,DEFMENULEN)) 
                           { default:
                             case 0: goto L2; 
                             case 1: CYRUNSW = !CYRUNSW; break;
                             case 2: CYSPEED = (CHECKMINMAX(P.X-32,8,512)>>2 & 07776)-CYSPEEDMAX;
                                    if (!CYRUNSW) INITCY();
                                    CYRUNSW = TRUE;
                                    break;  }
                          WRITEFORM(2,10,CYSPEED/2,0,"..."); }

                          if (CYRUNSW) CYMAP(&C);
                          PMVIWAIT(2);
                          SETCOLORMAP(&C,16);
                          READTABLET(&P,&S);
                                }/*L1*/ while (1);
                                    }/*N*/ 
			L2:
              SETCOLORMAP(MCMAP,16);
              INITCY();
              if (SWITCHES[14] != 0) COLORFIX();
              SETPALSEL();
                             }/*CY*/ 


           void INITCY() {
              CYCOUNT = 0; CYNUM = (CYSPEED >= 0) ? 7:14;
                 }


           void ALTCOLORS() {/*AL*/ 
              COLOR C[16]; int CYMAX,I,J;

              for (I=0; I<=15; I++) C[I].VALUE = I;
              CYMAX = CYSPEEDMAX-ABSVAL(CYSPEED);

              switch (CYMODE) {
                 default:
                 case 0:  WRITEFORM(1,0,"ALTERNATE COLORS");
                          READCOLORMAP(MCMAP,16);
                          READCOLORMAP(ALTCMAP,6);
            		//    SETCOLORMAP(ALTCMAP,16)
                          for (I=CYMAX; I>=0; I--) {
                             for (J=15; J>=6; J--) 
                                INTERPCOLOR(&C[J],MCMAP+J,ALTCMAP+J,I,CYMAX);
                             PMVIWAIT(2);
                             SETCOLORMAP(&C[6],10);
                          }
                          CYRUNSW = 0; CYMODE = -1;
                          if (SWITCHES[14] != 0) COLORFIX();
                          SETPALSEL(); break;
                 case -1: READCOLORMAP(ALTCMAP,16);
                          for (I=0; I<=63; I++) ((word*)ALTCMAP)[I] = ((word*)ALTCMAP)[I] & COLORPRIMASK;
                    //    SETCOLORMAP(MCMAP,16);
                          for (I=CYMAX; I>=0; I--) {
                             for (J=15; J>=6; J--)
                                INTERPCOLOR(&C[J],ALTCMAP+J,MCMAP+J,I,CYMAX);
                             PMVIWAIT(2);
                             SETCOLORMAP(&C[6],10);
						  }
                          WRITEFORM(1,0,"RESTORED MAIN COLORS");
                          CYRUNSW=0; CYMODE=0;
                          if (SWITCHES[14] != 0) COLORFIX();
                          SETPALSEL(); break;
              }
            }/*AL*/ 


            void COLORFIX() {		// fix high colors for menu overlay mode
                  COLOR C[16]; int I,J;

                  SETPIC(0);
                  for (I=0; I<=15; I++) C[I].VALUE = I;
                  READCOLORMAP(&C,16);
                  for (I=0; I<=15; I++) {
                     for (J=1; J<=15; J++) C[J].VALUE = 16*J+I;
                  SETCOLORMAP(&C[1],15);  }
			}


            void CYMAP(COLOR *C) 	// MAKES A NEW CMAP IN C FROM MCMAP AND ALTCMAP
             {/*CY*/ 
				int I,T,T1,T2,T3,CYMAX;

               for (I=0; I<=15; I++) C[I].VALUE = I;
               READCOLORMAP(C,16);

               CYMAX = CYSPEEDMAX-ABSVAL(CYSPEED);
               if (CYCOUNT > (CYMODE == 1 ? 1:0))
                  { CYCOUNT = CYCOUNT-1; }
               else { CYNUM = NEXTCYNUM(CYNUM);
                     CYCOUNT = CYMAX; }

               switch (CYMODE) {
                  case 1:
                     T = CYNUM;
                     if (CYMAX == 0)
                           for (I=15; I>=6; I--) {
                              C[I].RED = MCMAP[T].RED;
                              C[I].GREEN = MCMAP[T].GREEN;
                              C[I].BLUE = MCMAP[T].BLUE;
                              T = (T <= 6 ? 15:T-1); }
                     else for (I=15; I>=6; I--) {
                              T1 = NEXTCYNUM(T);
                              INTERPCOLOR(C+I,MCMAP+T,MCMAP+T1,CYCOUNT,CYMAX);
                              T = T <= 6 ? 15:T-1; }
                     break;
                  case 2: case 3:
                     T = CYNUM; T1 = NEXTCYNUM(CYNUM);
                     if (CYMAX == 0)
                           {
                           if (CYMODE == 2) {
								C[T].RED = MCMAP[T].RED;
								C[T].GREEN = MCMAP[T].GREEN;
								C[T].BLUE = MCMAP[T].BLUE;
                           }
                           C[T1].RED = ALTCMAP[T1].RED;
                           C[T1].GREEN = ALTCMAP[T1].GREEN;
                           C[T1].BLUE = ALTCMAP[T1].BLUE;
                     }
                     else {
                           T2 = CYCOUNT*2-CYMAX/2;
                           T3 = (CYMAX*3)/2-CYCOUNT*2;
                           if (CYMODE == 2)
							 INTERPCOLOR(C+T,C+T,MCMAP+T,CHECKMINMAX(T2,0,CYMAX),CYMAX);
                           INTERPCOLOR(C+T1,ALTCMAP+T1,C+T1,CHECKMINMAX(T3,0,CYMAX),CYMAX);
                     }
                     break;
                  default: break;
                     }
                              }/*CY*/ 


void INTERPCOLOR(C,C1,C2,T,TMAX) 
	COLOR *C,*C1,*C2;
{
   C->RED = (C1->RED*T+C2->RED*(TMAX-T))/TMAX;
   C->GREEN = (C1->GREEN*T+C2->GREEN*(TMAX-T))/TMAX;
   C->BLUE = (C1->BLUE*T+C2->BLUE*(TMAX-T))/TMAX;
}


int NEXTCYNUM(CYNUM)  {
   if ((CYSPEED >= 0) == (CYMODE > 1))
      return (CYNUM <= 6 ? 15:CYNUM-1);
   else return ((CYNUM >= 15) || (CYNUM < 6) ? 6:CYNUM+1);
}


void COPYCOLOR() 
 {/*C*/ 
	POS P1, P2; COLOR C; word T,I;

   WRITEFORM(1,0,"COPY COLOR");
   WRITEFORM(1,0,"TOUCH COLOR TO BE CHANGED");

   TABGRID = 0;
   TABLETSTROKE(4,&P1,&P2,OVQ0,OVQ0);
   switch (FINDMENU(P1,DEFMENU,DEFMENULEN)) {
      default:
      case 0:
      case 1: return; 
      case 2: PTWIN->XORIG = P1.X; PTWIN->YORIG = P1.Y;
		 PMTORUNTABS(4,*PTWIN,PTRUN,1,Q0);
         C.VALUE = PAINTVAL;
         READCOLORMAP(&C,1);
         T = PTRUN[0].VALUE;// >> 4;
         C.VALUE = T;
         SETCOLORMAP(&C,1);
         if ((SWITCHES[14] != 0) && (T != 0))
          for (I=0; I<=15; I++)
           { C.VALUE = 16*T + I;
             SETCOLORMAP(&C,1);  }
         PAINTVAL = T;
         if (!CYMODE == -1) READCOLORMAP(MCMAP,16);
         SETPALSEL();
         DISPBRUSHES();
   }
}/*C*/ 


