;; This file can be used to set up the EL-3200 68020/68030/68ec030 event
;; system for statistical performance analysis.

;remove any residual event system setup
evtclr

;no tracing will occur unless asked for by the event system.
trace on
trcbeg off

;timer resets at a go
timrst on
;and begins counting bus cycles
timbeg on

;reset counters at go, but don't let 'em start.
ct0rst on 
ct1rst on
ct0beg off
ct1beg off

evtgrp 1

;; This timer value is the number of bus cycles that are allowed to elapse 
;; between grabs by the trace system. You will probably want to change it
;; a few times during a P.A. run to assure that the number is not in sync
;; with your program. If the period of this timer matches a periodicity in
;; your program, very inaccurate results might occur.

ev{4}=timer==1000
trig{4}=ev{4},timrst,flg0set,grp2

ev{3}=trcfull
trig{3}=ev{3},trcend

evtgrp 2

ev{10}=count0==5,flag0,status==prog
;; ev{10}=count0==5,flag0,status==prog,addr!=0x12345..0x23456

;; please don't change anything between here and the !!!!!! line

trig{10}=ev{10},trcone,flg0rst

ev{12}=status==prog
trig{12}=ev{12},ct0inc,ct1inc

ev{11}=count1==10
trig{11}=ev{11},ct0rst,ct1rst,grp1
;; !!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!

; Gather P.A. info during run.
perfact statistical

; data collection interval
perfint 3

; display P.A. data every time trace is uploaded.
perfmode always
