***********************************************************************
* File: alib.s
* File $Revision: 3.1 $
* $Date: 1991/01/21 16:28:30 $
*	Copyright (C) 1989 by Applied Microsystems Corp.
***********************************************************************
* NAME: alib.s
* DESC: 68K Sales Demon Start-up and assembly procedures
*
*	This module contains assembly code and data declarartions to support the
*	the cdemon demonstration program.  The assembly code portions provide 
*	processor and target specific functions and locations such as;
*		Startup Code
*		I/O Drivers
*		Position Dependant Locations
*		Execption Vectors
*	The startup and led output procedures are described in more detail later
*	in the module.  The location of the LEDS varies between the 68000/010
*	and the 68020/030/302 Sales Demonstration Target. This difference is
*	eliminated by writing pattern to both LEDS locations.  Finally the
*	execption vectors contain the initial stack and program counter
*	addresses as well as a bus and address error handler address.  The
*	Illegal instruction vector is reserved but not used since several
*	software debugger use this vector for software traps.
* 
***********************************************************************

	OPT	CASE
	sect	startup

	DC.B	'cdemon version 2.2'
	DC.B	'Copyright (C) 1989 by Applied Microsystems Corp.',0

ALIB IDNT

***********************************************************************
*
*       START - Run Time Start Procedure
*
*	This routine should be the first procedure executed direct
*	from the power-on reset vector and prior to jumping to the main
*	program.  The SP is initialized to STACKTOP which is defined
*	at link time.  If the program terminates which it should not
*	normally do then execution will resume at the EXIT label where
*	the LEDS are cleared and the program halts by jumping to
*	itself.  If an exception occures such as a bus or address error
*	execution will transfer to the ERROR label where the LEDS
*	indicate the exception number and the program halts by jumping 
*	to itself.
*

	XDEF      START               * PUBLIC START
	XDEF      EXIT                * PUBLIC EXIT
	XDEF      ERROR               * PUBLIC ERROR
	XDEF      HALT                * PUBLIC HALT
	xref	STACKTOP

CLEAR	EQU	  255		      * ALL BITS 1

START   MOVE.L    #STACKTOP,SP        * STACK POINTER INITIALIZATION
        MOVE.L    #0,A6               * FRAME POINTER INITIALIZATION
        JSR       _main               * JUMP TO MAIN C ROUTINE

EXIT	MOVE.W    #CLEAR,D0           * LOAD LEDS CLEAR PATTERN
	JMP       HALT                * ON EXIT GOTO HALT

ERROR	MOVE.W	  6(A7),D0	      * LOAD VECTOR OFFSET PATTERN
	NOT.W	  D0		      * COMPLIMENT D0 TO CORRECT FOR DISPLAY
	JMP       HALT                * ON ERROR GOTO HALT 

HALT	MOVE.B	  D0,LOLEDS	      * WRITE PATTERN TO 0x3000 LEDS
	MOVE.B	  D0,HILEDS	      * WRITE PATTERN TO 0xA000 LEDS
	JMP       HALT                * JUMP FOREVER HERE

*
*       OUTLED - Output pattern to led port Routine
*
*       The purpose of this procedure is to set the leds according
*       to the value passed as the pattern.  This routine is called
*       from c code so the value passed is via the stack frame pointer.
*
        XDEF      _outled             * PUBLIC outled

_outled	MOVE.W    $6(A7),LOLEDS       * WRITE PATTERN TO 0x3000 LEDS
	MOVE.W    $6(A7),HILEDS       * WRITE PATTERN TO 0xA000 LEDS
        RTS                           * RETURN

	section	code
        XREF      _main               * EXTERNAL .main
*
*       Memory Mapped I/O
*
*       The following section establishes the LED location of the
*	68302 Sales Demon. The LEDS are mapped as a word at location A000
*	with the lower bits, 1 thru 8, corresponding to LEDS 1 thru 8. 
*
        SECTION   MMIO_LO		* MEMORY MAPPED I/O SECTION
LOLEDS  DS.W      1			* FRONT PANEL LEDS

        SECTION   MMIO_HI		* MEMORY MAPPED I/O SECTION
HILEDS  DS.W      1                   * FRONT PANEL LEDS

*
*       INITIALIZED DATA
*
        SECTION   VECTORS	      * INITIALIZED DATA

*
*       VECTORS - Exception vectors for Motorola 68000 family cpu's
*
VECTOR0 DC.L      STACKTOP		* Power-on stack pointer
VECTOR1 DC.L      START			* Power-on program counter
VECTOR2	DC.L	  ERROR			* Bus Error
VECTOR3	DC.L	  ERROR			* Address Error
VECTOR4	DS.L	  1			* Illegal Instruction ( S/W BRK )

        END       START
