/**********************************************************************
* File: cdemon.c
* File $Revision: 3.2 $
* $Date: 1991/09/16 17:38:52 $
*	Copyright (C) 1989 by Applied Microsystems Corp.
***********************************************************************
* DESC:	Universal Sales Demon Blinking LED Demonstration Program
*
*	The purpose of this program is to provide a demonstration 
*	sample to use with various types of debuggers.  This program
*	exercises the LEDs of the Applied Microsystems Sales Demons.
*	This module contains the main application procedure and is the
*	first code executed after the startup procedure.  All other
*	modules and functions are called from this main procedure.  
*
**********************************************************************/

/**********************************************************************
**                    Include Header Information                     **
**********************************************************************/

#include "cdemon.h"

extern outled(), rol(), ror(), wait(); /* external functions */

/**********************************************************************
**                        Port Declarations                          **
**********************************************************************/

struct com_port             /* com port layout */
    {
    BYTE write_data,        /* TARGET -> EMULATOR */
          read_data;        /* EMULATOR -> TARGET */
    } com = {'\0','\0'};

char led_port[19] = "|*| | | | | | | |\r"; /* |0|1|2|3|4|5|6|7|\0 */

/**********************************************************************
**                   Global Variable Declarations                    **
**********************************************************************/

BYTE pattern;   /* bit pattern of the leds */
int  speed;     /* speed of the blinking process */
enum direction {right, left} direct; 	/* pattern direction */

/**********************************************************************
**                          Main C Routine                           **
**********************************************************************/

main()              /* Program Starts Here */
    {
    extern data();  /* data function is external */

    inital();       /* Initialize Variables */
    step();         /* Single Step Loop */
    data();         /* Data Structures */
    run();          /* Run Blinking Leds */
    }

/**********************************************************************
**                     Initialize Static Variables                   **
**********************************************************************/

inital()
    {
    pattern = ONE_ON;                   /* 0___ ____ */
    speed   = MEDIUM;                   /* SLOW - MEDIUM - FAST */
    direct  = left;                     /* left to right */
    }

/**********************************************************************
**                      Single Step LEDs Routine                     **
**********************************************************************/

step()
    {
    int loops;		/* dynamic variable with for loop count */

    for (loops = 5;loops != 0;loops--)    /* repeat output 5 times */
        {				/* 0=on 1=off*/
        outled(0xFE);  	            	/* 0111 1111 */
        outled(0xFC);       		/* 0011 1111 */
        outled(0xF8);        		/* 0001 1111 */
        outled(0xF0);               	/* 0000 1111 */
        outled(0xE0);        		/* 0000 0111 */
        outled(0xC0);        		/* 0000 0011 */
        outled(0x80);        		/* 0000 0001 */
        outled(0x00);        		/* 0000 0000 All On..! */
        outled(0x01);               	/* 1000 0000 */
        outled(0x03);           	/* 1100 0000 */
        outled(0x07);           	/* 1110 0000 */
        outled(0x0F);           	/* 1111 0000 */
        outled(0x1F);           	/* 1111 1000 */
        outled(0x3F);           	/* 1111 1100 */
        outled(0x7F);           	/* 1111 1110 */
        outled(0xFF);           	/* 1111 1111 All Off..! */
	}
    }

/**********************************************************************
**                     Run Blinking LEDs Routine                     **
**********************************************************************/

run()
    {
    BYTE maskbit;	/* dynamic variable for bit test of pattern */
    int  cputype = 5;	/* clock speed compensator set to default */
    int  i, forever = 1; /* trivial stuff */

    while (forever)
	{
		/* Build ascii chars in led port array from pattern */
	for (maskbit = 1, i = 0 ; i < 16; maskbit <<= 1)
	    {
	    led_port[i++] = '|';	/* start with a frame */
	    led_port[i++] = (pattern & maskbit)  ? ' ' : '*';
	    }				/* then add a space or asterisk */
	led_port[i] = '|';		/* finish with one last frame */

		/* Output pattern to LEDs */
	outled(pattern);

		/* Wait according to cputype and speed factors */
	wait(cputype,speed);

		/* Shift pattern according to direction flag */
	switch (direct)
	    {
	    case left : pattern = ror(pattern,1);
	                break;
	    case right: pattern = rol(pattern,1);
	                break;
	    }
        }
    }

/**********************************************************************
**                     End Of Cdemon Program                         **
**********************************************************************/

