p^p       c
/ #'+-0359#<M?uAB7E^F
KNPTY[I     Use PgDn for the next page, PgUp for the previous page, or Esc to exit       ͻ
          This demo program corresponds to Version 1.10 of PERISCOPE         
 l
 l
 l
 : ͻ;
 :  P E R I S C O P E ;
 : ͼ;
 l
 9:
 9  The Undercover Debugger :
 9:
 l
 l
      This demo program is not copyrighted and may be freely distributed     
 ͼ

 ͻ
  Data Base Decisions, creators of PEEKS 'N POKES and THE INSIDE TRACK, now  
  delivers debugging dynamite for the IBM PC ...  PERISCOPE!  Forget conven- 
  tional debugging delays ...  get your programs up and running with Peri-   
  scope's hardware/software solution to debugging dilemmas!                  
 ͼ
Hͻ
H An overview ... 
Hͼ

PERISCOPE is a debugging system for the IBM PC, XT, AT, Compaq and other close
compatibles.  It is a full-featured symbolic debugger, system monitor, and
break-out switch that will save you hours of debugging time.  PERISCOPE is 16K
of fast assembly code that supports the most popular languages, including
Assembly, BASIC, C, and Pascal.  Some of the time-saving features include --

Debug your program using symbol names instead of addresses.  For some
compilers, the source code line number is also available.

Run your program on a monochrome monitor while debugging it on a color
monitor, or vice-versa.  For single-monitor systems, switch from the debugger
screen to the program's screen with one keystroke -- great for debugging
screen-intensive programs.

Set a breakpoint on the 500th iteration of a loop, or find where a pointer is
corrupting memory using PERISCOPE's 'monitor' breakpoints.

Stop guessing what your program is doing -- the break-out switch stops the
system and lets you see what's happening.  Recover from parity errors, 'dead'
keyboard, and other situations where the system locks up!
The PERISCOPE system includes a special memory board named Submarine that is
installed in one of the PC's expansion slots, two push-button switches (one
located on the board's mounting bracket and one remote switch), the debugger
software, a 100-page manual in a 3-ring binder and a quick-reference card.

The memory board contains 16K of write-protected RAM.  The debugger software
is loaded into the memory and then the memory is write-protected to prevent a
runaway program from modifying it.

After PERISCOPE has been installed, the push-button switch can be used to
interrupt the program that is currently executing and enter the resident
debugger -- even when the system is hung.  When you leave the debugger via
the Quit command, PERISCOPE's command list is displayed --

  ͻ
   We interrupt this program ...  Normal boot (B), Continue (C), Debug (D), 
   Return to DOS (R), or Short boot (S)? _B
  ͼ

The short boot option preserves all but the first 64K of memory.
PERISCOPE is built to be able to recover from most anything your program can
do to hang the system.  Some of the safeguards built into PERISCOPE include:

- On entry, the BIOS vectors that PERISCOPE uses are saved.  PERISCOPE then
changes these interrupts back to their power-on (ROM) values, for maximum
reliability.  On exit from PERISCOPE, the program's vectors are restored.

- PERISCOPE uses BIOS interrupts for all but the Load, Name, and Write
commands so that there is no chance of PERISCOPE calling DOS when DOS is
already active.  The use of BIOS also allows you to trace DOS.

- The break-out switch is effective even when interrupts are disabled.  Active
timer and keyboard interrupts are detected and handled by PERISCOPE.  If
needed, the keyboard is also reset.

- Whenever possible, PERISCOPE restores the state of the system so that an
interrupted program will not be affected.  PERISCOPE never makes a beep --
this could alter the sound being generated by the interrupted program.  The
original keyboard buffer and CRT control buffers are saved on entry to
PERISCOPE and restored on exit.
Hͻ
H Recover from a hung system! 
Hͼ
The resident debugger is command-driven and has a command structure similar to
the standard PC-DOS debugger.  On-line help is available for all of the
commands.  The debugger has all the standard functions (except the assemble
capability and 8087 support) plus:

- User-selected windowing of data, register, stack, and/or disassembly
information.  You choose the data that is to be shown in windows and the size
of the windows when PERISCOPE is loaded from disk.

- Display memory in byte, word, and double word formats, skipping lines of
repetitive values.

- Display a block of memory by individual fields within a record.  For
example, you can display the Program Segment Prefix with each field in the
'record' labeled and on a separate line.  You can define records as needed.

- Display the contents of the record and symbol tables.

- Interactively add and change symbol definitions.

@ͻ
@ The standard functions, plus ... 
@ͼ
- Search memory for procedure and address references -- you can find all jumps
or calls to a particular address or all references to a data item.

- Set up to 16 'sticky' code breakpoints that are remembered until cleared.

- Set breakpoints on register, byte, and word values, and reads/writes to
ranges of memory.  For example, you can set breakpoints when register CX
equals 0FFFH, when a word in memory is less than some value, or when memory
from specified ranges is read.  These breakpoints cause the system to run much
slower than normal, but when they're needed, they can be invaluable.

- Debug device drivers, memory-resident, and non-DOS programs!

- Jump to the next instruction at the same level -- useful for executing
subroutine calls and interrupts at full speed.

- Translate hex to decimal and vice-versa.

- Enter multiple commands on one line and then repeat the entire command
string with one keystroke.
@ͻ
- Trace DOS as well as BIOS.$ ... more important features 
@ͼ
- And much more ...
PERISCOPE is symbolic -- you can use names from your program instead of
addresses.  Anywhere an address can be used, PERISCOPE also accepts a symbol
name.  The symbol names are read from the MAP file generated by the linker.
You can use linkers produced by Microsoft/IBM, Phoenix, and Digital Research.

Each symbol corresponds to a segment and an offset.  For example, to display
memory starting at the address labeled 'BUFFER', enter D @BUFFER.  If you
have a subroutine named 'PRINT_LINE', you can Go to the first invocation of
the subroutine by typing G @PRINT_LINE.

If you disassemble the program, the start of PRINT_LINE is shown as well as
any data elements that PRINT_LINE uses.  This symbolic capability can speed up
debugging tremendously, since you do not have to look for a particular
sequence of instructions to find a certain section of code, nor do you have to
worry about the location of code or data -- you can access it by name!  You
can also define new symbols or redefine existing symbols while the debugger is
active.
Hͻ
H Symbols are wonderful! 
Hͼ
Now, let's see a sample debugging session.

A>run sample.com
RUN (Version 1.10) Copyright 1984, 1985 Data Base Decisions
Program Segment Prefix (PSP) is 0B75:0000
Address references loaded into symbol table%ͻ
Record definitions loaded into record table% From the DOS prompt,#
P use the program loader 
P RUN to load SAMPLE.COM 
Pͼ


AX=0000  BX=0000  CX=008B  DX=0000  SP=FFFD  BP=0000  SI=0000  DI=0000
DS=0B75  ES=0B75  SS=0B75  CS=0B75  IP=0100#NV UP EI PL ZR NA PE NC
0SAMPLE:
0B75:0100 EB35*JMP%START,ͻ
>P The first instruction 
Q is shown -- note the  
Q symbol names SAMPLE#
Q and START.,
Qͼ
Hͻ
H To get help, enter '?' 
>?Fͼ
The commands are:  Breakpoint (BA, BB, BC, BM, BR, BW), Compare (C), Display
(D/DB, DD, DR, DW), Enter (E, ES), Fill (F), Go (G, GB, GT), Hex (H), Input
(I), Jump (J), Klear (K), Load (LA, LF), Move (M), Name (N), Output (O), Quit
(Q), Register (R), Search (S, SA), Trace (T), Unassemble (U), Write (WA, WF),
Xlate (X/XH, XA, XD), & Option (/S)
Hͻ
>? dD To get help for the dis-  
Syntax:  D [<range>] or DB [<range>]$ play command, enter '? d' 
Hͼ
Description:  This command is used to display a block of memory in hex and
ASCII.

Each line of the display shows the starting segment and offset, up to 16
bytes, and their ASCII representation.

If you enter 'D', this command displays memory starting where the last 'D'
command left off.  The R command sets the starting point to DS:100.  If you
enter 'D <number>', the number is presumed to be an offset, the segment is
presumed to be DS, and the length is presumed to be 80H.  If you enter 'D
<number> <length>' the number is presumed to be an offset, and the segment is
presumed to be DS ...
>d 0
0B75:0000  CD 20 C0 27 00 9A F0 FE-1D F0 3A 01 E3 02 07 01#M @'..p~.p:.c...
0B75:0010  E3 02 96 01 E3 02 00 00-00 00 00 00 00 00 00 00#c...c...........
+* 0003 LINES OF 00 SKIPPED *
0B75:0050  00 00 00 00 00 00 00 00-00 00 00 00 00 20 20 20#.............
0B75:0060  20 20 20 20 20 20 20 20-00 00 00 00 00 20 20 20+.....
0B75:0070  20 20 20 20 20 20 20 20-00 00 00 00 59 D9 59 00+....YYY.

>dw @totmem l 2
0B75:0133  009F

>dd 0:0 l 30
0000:0000  00BF:1501$BFF0:0B4B$BFF0:0B4B$BFF0:0B44
0000:0010  0060:0086$F000:FF54$0000:0000$0000:0000
0000:0020  F000:FEA5$F000:E987$0000:0000$0000:0000

Hͻ
H You can display memory in the 
H normal fashion, or in word or 
H double word format.  Or for#
H complex records ...+
Hͼ
>dr 0 @psp
Int 20%CD 20MM
Top Mem$27C0
Reserved#00P.
Long Call  9AP.
DOS Func#F01D:FEF0
Terminate  02E3:013A
Ctrl-Break 02E3:0107
Error&02E3:0196
DOS Use$00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00#................
+00 00 00 00 00 00A......
Environ$0000
DOS Use$00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00#................
+* 0001 LINES OF 00 SKIPPED *
+00 00 00 00 00 00 00 00 00 00 00 00 00 00)..............
PSP1'00 20 20 20 20 20 20 20 20 20 20 20 00 00 00 00#.+....
PSP2'00 20 20 20 20 20 20 20 20 20 20 20 00 00 00 00#.+....
+59 D9 59 00GYYY.

Hͻ
H You can display memory in rec- 
H ord formats of your own design 
Hͼ

Hͻ
H The 't' command is used to 
H single-step instructions#
Hͼ
>t
AX=0000  BX=0000  CX=008B  DX=0000  SP=FFFD  BP=0000  SI=0000  DI=0000
DS=0B75  ES=0B75  SS=0B75  CS=0B75  IP=0137#NV UP EI PL ZR NA PE NC
WR SS:FFFB = F346
0START:
0B75:0137 E81700(CALL$GETMEM

8ͻ
8 Note the two symbols -- START for this instruc-  
8 tion and GETMEM for the called procedure.  Also, 
8 the effective address for any memory reads or$
8 writes is shown.  In this case, one word will$
8 be written to SS:FFFB.  The current value of%
8 F346 is also shown.>
8ͼ
>u
0START:
0B75:0137 E81700(CALL$GETMEM
0B75:013A A13301(MOV%AX,[TOTMEM]
0B75:013D BF1001(MOV%DI,01105; TMEMORY
0B75:0140 E82400(CALL$CONVERT
0B75:0143 A13501(MOV%AX,[FREMEM]
0B75:0146 BF2C01(MOV%DI,012C5; AMEMORY
0B75:0149 E81B00(CALL$CONVERT
0B75:014C E83400(CALL$DISPLAYIT
0DOSRET:
0B75:014F CD20*INT%20
0GETMEM:
0B75:0151 B106*MOV%CL,06
0B75:0153 BE0200(MOV%SI,0002
0B75:0156 8B04*MOV%AX,[SI]

@ͻ
@ The disassemble command uses all available 
@ symbols to make the disassembly easier to  
@ read.  Compare this with the next page.$
@ͼ

>u
0B75:0137 E81700(CALL$0151
0B75:013A A13301(MOV%AX,[0133]
0B75:013D BF1001(MOV%DI,0110
0B75:0140 E82400(CALL$0167
0B75:0143 A13501(MOV%AX,[0135]
0B75:0146 BF2C01(MOV%DI,012C
0B75:0149 E81B00(CALL$0167
0B75:014C E83400(CALL$0183
0B75:014F CD20*INT%20
0B75:0151 B106*MOV%CL,06
0B75:0153 BE0200(MOV%SI,0002
0B75:0156 8B04*MOV%AX,[SI]



@ͻ
@ This disassembly is of the same code as 
@ the previous page, but without symbols. 
@ See how symbols improve readability?$
@ͼ
 6(int lower, upper, step;#ͻ
 7(float fahr, celsius;& This is a segment of the FTOC C program 
 8$main()8 from the Kernighan and Ritchie book.$
 9${=ͼ
10(lower = 0;)/* lower limit */
11(upper = 300;'/* upper limit */
12(step = 20;)/* step size */
13(fahr = lower;

0A10:
0E0E:0088 33C0*XOR%AX,AX
0A11:
0E0E:008A C7060A002C01  MOV%WORD PTR [UPPER],012C
0A12:
0E0E:0090 C7060C001400  MOV%WORD PTR [STEP],0014
0A13:
0E0E:0096 A30800(MOV%[LOWER],AX
0E0E:0099 E81704(CALL$CXV04
8ͻ
8 This is PERISCOPE's disassembly of the program from 
8 line 10 to line 13.  Note the symbols for the line  
8 numbers and the variables UPPER, STEP, and LOWER.#
8ͼ


>sa @start @displayit @convert
0B75:0140 E82400(CALL$CONVERT
0B75:0149 E81B00(CALL$CONVERT


>sa @start @displayit @totmem
0B75:013A A13301(MOV%AX,[TOTMEM]
0B75:015A A33301(MOV%[TOTMEM],AX

@ͻ
@ You can search a range of memory for in-  
@ structions that reference an address -- a 
@ quick way to find all jumps or calls to a 
@ procedure or all lines that use a data$
@ variable.  The examples above search from 
@ 'START' to 'DISPLAYIT' for references to  
@ the symbols 'CONVERT' and 'TOTMEM'.'
@ͼ
0B75:012C  AMEMORY60B75:011A  AVAIL
0B75:0135  FREMEM70B75:0137  START
0B75:014F  DOSRET70B75:0151  GETMEM
0B75:0167  CONVERT60B75:0173  CVTCHAR
0B75:0183  DISPLAYIT40B75:0100  SAMPLE
0B75:0110  TMEMORY60B75:0102  TOTAL
0B75:0133  TOTMEM
@ͻ
@ Symbols are read from the program's MAP 
@ file when the program loader is used to 
@ load the program.  The supported link-  
@ ers include Microsoft/IBM, Phoenix&
@ (Plink), and Digital Research (LINK86). 
@ͼ

>es ds:200 @array
8ͻ
8 You can add or redefine symbols while 
8 PERISCOPE is active, using the 'es'#
8 command, an address, and a name.&
8ͼ




>bc @dosret

>bw @totmem ne 0

>bm 0:0 0:3ff rw


/ͻ
/ PERISCOPE supports up to 16 'sticky' code breakpoints#
/ as well as several types of 'monitor' breakpoints.&
/ The commands above set a 'sticky' breakpoint at the%
/ symbol DOSRET, a word breakpoint when the data variable 
/ TOTMEM is not equal to zero, and a memory breakpoint$
/ on any reads or writes of memory from 0:0 to 0:3FF.%
/ͼ



>x 9f
009Fh&159d%0000 0000 1001 1111b


>x ax
009Fh&159d%0000 0000 1001 1111b


>xd 159
009Fh&159d%0000 0000 1001 1111b


8ͻ
8 You can translate hex to decimal or vice-versa. 
8 The binary equivalent is also displayed.(
8ͼ


>r
AX=009F  BX=002D  CX=0006  DX=0000  SP=FFFD  BP=0000  SI=0002  DI=0110
DS=0B75  ES=0B75  SS=0B75  CS=0B75  IP=0140#NV UP EI PL NZ NA PE NC
WR SS:FFFB = F206
0B75:0140 E82400(CALL$CONVERT


>j
AX=0000  BX=002D  CX=000A  DX=0031  SP=FFFD  BP=0000  SI=0002  DI=0110
DS=0B75  ES=0B75  SS=0B75  CS=0B75  IP=0143#NV UP EI PL ZR NA PE NC
RD DS:0135 = 0072
0B75:0143 A13501(MOV%AX,[FREMEM]


@ͻ
@ The jump command lets you skip over 
@ CALLs and INTs to get to the next#
@ instruction on the same level.&
@ͼ


>h 270+150
03C0

>h 270-150
0120

>h 270*150
0003 3300

>h 270/150
0001 r 0120

@ͻ
@ PERISCOPE also supports hex arith- 
@ metic -- addition, subtraction,$
@ multiplication, and division.&
@ͼ
0B75:0102  54 6F 74 61 6C 20-6D 65 6D 6F 72 79 3A 20)Total memory:
0B75:0110  33 32 30 20 4B 42 20 20-20 20 4D 65 6D 6F 72 79#320 KB$Memory
0B75:0120  20 61 76 61 69 6C 61 62-6C 65 3A 20 32 37 31 20$available: 271
0B75:0130  4B 42 24 40 01 0F 01 E8-17 00 A1 33 01 BF 10 01#KB$@...h..!3.?..
D
AX=0000  BX=0031  CX=000A  DX=0032  SP=FFFC  BP=0000  SI=0002  DI=012C
DS=0B75  ES=0B75  SS=0B75  CS=0B75  IP=0183#NV UP DI PL ZR NA PE NC
R
0DISPLAYIT:
0B75:0183 B409*MOV%AH,09
0B75:0185 BA0201(MOV%DX,01025; TOTAL
0B75:0188 CD21*INT%21
0B75:018A C3,RET
0B75:018B 0000*ADD%[BX+SI],AL
U
>g @displayit
>d @total/ͻ
>7 PERISCOPE does windows, too!  This screen$
8 shows Data, Register, and Unassembly windows 
8 in use.  You choose the types of information 
8 to be shown in the windows, as well as the#
8 order and size of the windows./
8ͼ

?+Help
BA*Display/clear all breakpoints
BB*Display/clear/set byte breakpoints
BC*Display/clear/set code breakpoints
BM*Display/clear/set memory breakpoints
BR*Display/clear/set register breakpoints
BW*Display/clear/set word breakpoints)ͻ
C+Compare memory= These are some 
D or DB%Display memory in byte format. of PERISCOPE's 
DD*Display memory in double word format' commands ...#
DR*Display memory using a record format'ͼ
DW*Display memory in word format
E+Enter changes to memory
ES*Enter symbol definition
F+Fill memory with a byte/string pattern
G+Go until code breakpoint reached
GB or GT$Go until code/monitor breakpoint reached
H+Hex arithmetic
I+Read I/O port

J+Jump to next instruction
K+Clear debug screen
LA*Load absolute sectors from disk
LF*Load file from disk
M+Move (copy) a block of memory
N+Format PSP for disk I/O
O+Write I/O port=ͻ
Q+Quit PERISCOPE= These are the$
R+Display or change registers0 rest of Peri-$
S+Search memory for a byte/string pattern$ scope's commands 
SA*Search for address references.ͼ
T+Trace execution
U+Unassemble memory
WA*Write absolute sectors to disk
WF*Write file to disk
X or XH%Translate hex number
XA*Translate address
XD*Translate decimal number
/S*Change segment in symbol table
PERISCOPE will work for programs written in any language, but the greatest
benefits will be achieved by languages that are able to generate symbols as
desired.  To check your compiler, read through the tips below and then run the
linker, specifying a MAP file and the /L and /M options.  Now, look at the
MAP file -- any of the names in the Publics by Name list or any of the line
numbers at the end of the MAP file can be used as symbols.  External refer-
ences to other modules or subroutines are always included in the MAP file.

For Assembly programs, any data item or procedure declared PUBLIC will
generate an entry in the MAP file.  If you declare all data items and
procedure names as PUBLIC, a disassembly of your program will look almost the
same as the original -- without comments of course!  Hint -- declare multiple
public entries on one line near the front of your program for the easiest
program maintenance.

Hͻ
H The languages supported 
H include ASM ...)
Hͼ
For BASIC programs, the symbol names available are the ones used by the
BASIC compiler and any external subroutines.  (We're working on a program that
will give you symbolic access to all data variables and line numbers for
compiled BASIC.) To debug an assembly language subroutine, you can use G
@SUBNAME to get to the first execution of SUBNAME.  For interpretive BASIC,
you can insert a CCH as the first byte of a subroutine to transfer control to
the resident debugger when the subroutine is executed.

For Lattice, Microsoft and other C programs, external data variables will
generate entries in the MAP file, allowing you to access them by name.  The
source program line numbers are available as symbols when the -d option is
used at compile time.  PERISCOPE's memory breakpoint is great for tracking
down memory corruption caused by C pointers gone awry.

For Microsoft or IBM Pascal programs, data variables declared as PUBLIC will
generate entries in the MAP file, allowing you to access them by name.  The
source program line numbers are also available as symbols.

Hͻ
H ... BASIC, C and Pascal 
Hͼ


The system requirements for PERISCOPE are:

&- An IBM PC, XT, AT, Compaq, Columbia, Leading Edge, or Sperry PC

&- Any version of PC-DOS

&- 64K RAM

&- One disk drive

&- An 80-column monitor (two preferred)

Pͻ
P System Requirements 
Pͼ

If an IBM AT is used, PERISCOPE intercepts exception interrupts 06H (illegal
opcode) and 0DH (segment wraparound) to keep these exceptions from locking the
system.  The real-mode opcodes of the 80286 are also supported by PERISCOPE.
The PERISCOPE system includes:

&- The memory board with 16K of write-protected memory
&- A remote switch
&- The debugger software
&- A 100-page manual in a three-ring binder
&- A quick-reference card

The memory board is warranted to be free from manufacturing defects for one
year from the date of purchase.  Software and documentation updates will be
provided at a nominal charge of $10.00 or less to all registered users.

PERISCOPE is an incredible bargain at $295!  We're so sure you'll like it that
we offer a 30-day money-back guarantee!  Order your copy of PERISCOPE today
from your dealer or directly from Data Base Decisions.

-ͻ
- Get your programs up and running -- UP PERISCOPE! 
-ͼ

#Data Base Decisions * 14 Bonnie Lane * Atlanta, GA 30328 * 404/256-3860
)For orders or more information, call toll-free 800/722-7006
9MasterCard and Visa Accepted
<u
  `@ãb  G6
` / <t5< u6
IuNNQuFFE;wٸ;r҉6
 "  ô 
 & 3Ë6
4>&< rF<t<
t%<t3<t8< t4<t:<t@  PXPǹ 3@X	PXPXPXF   듸  &$0<0u  &eP$X33= u 